/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.permission;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.entity.identity.Y9IdentityToResourceAndAuthorityBase;
import net.risesoft.entity.identity.person.Y9PersonToResourceAndAuthority;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.ResourceTypeEnum;
import net.risesoft.model.platform.VueButton;
import net.risesoft.model.platform.VueMenu;
import net.risesoft.service.identity.Y9PersonToResourceAndAuthorityService;
import net.risesoft.y9public.entity.resource.Y9Menu;
import net.risesoft.y9public.entity.resource.Y9Operation;
import net.risesoft.y9public.service.resource.Y9MenuService;
import net.risesoft.y9public.service.resource.Y9OperationService;
import org.springframework.stereotype.Component;

@Component
public class VueMenuBuilder {
    private final Y9MenuService y9MenuService;
    private final Y9OperationService y9OperationService;
    private final Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService;

    private VueButton buildVueButton(Y9Operation y9Operation) {
        VueButton button = new VueButton();
        button.setName(y9Operation.getName());
        button.setIcon(y9Operation.getIconUrl());
        button.setButtonId(y9Operation.getCustomId());
        button.setDisplayType(y9Operation.getDisplayType());
        button.setUrl(y9Operation.getUrl());
        button.setEventName(y9Operation.getEventName());
        return button;
    }

    private List<VueButton> buildVueButtons(String personId, AuthorityEnum authority, String menuId) {
        ArrayList<VueButton> buttonList = new ArrayList<VueButton>();
        List<Y9PersonToResourceAndAuthority> authorizedButtonList = this.y9PersonToResourceAndAuthorityService.list(personId, menuId, ResourceTypeEnum.OPERATION, authority);
        List y9OperationList = authorizedButtonList.stream().map(Y9IdentityToResourceAndAuthorityBase::getResourceId).distinct().map(this.y9OperationService::getById).sorted().collect(Collectors.toList());
        for (Y9Operation y9Operation : y9OperationList) {
            if (!y9Operation.getEnabled().booleanValue()) continue;
            buttonList.add(this.buildVueButton(y9Operation));
        }
        return buttonList;
    }

    private VueMenu buildVueMenu(String personId, AuthorityEnum authority, String menuId, Y9Menu y9Menu) {
        VueMenu vueMenu = new VueMenu();
        vueMenu.setName(y9Menu.getName());
        vueMenu.setPath(y9Menu.getUrl());
        vueMenu.setRedirect(y9Menu.getRedirect());
        vueMenu.setComponent(y9Menu.getComponent());
        vueMenu.setMeta(y9Menu.getMeta());
        vueMenu.setTarget(y9Menu.getTarget());
        ArrayList<VueMenu> subVueMenuList = new ArrayList<VueMenu>();
        this.buildVueMenus(personId, authority, menuId, subVueMenuList);
        vueMenu.setChildren(subVueMenuList);
        List<VueButton> buttonList = this.buildVueButtons(personId, authority, menuId);
        vueMenu.setButtons(buttonList);
        return vueMenu;
    }

    public void buildVueMenus(String personId, AuthorityEnum authority, String resourceId, List<VueMenu> vueMenuList) {
        List<Y9PersonToResourceAndAuthority> authorizedMenuList = this.y9PersonToResourceAndAuthorityService.list(personId, resourceId, ResourceTypeEnum.MENU, authority);
        List menuList = authorizedMenuList.stream().map(Y9IdentityToResourceAndAuthorityBase::getResourceId).distinct().map(this.y9MenuService::getById).sorted().collect(Collectors.toList());
        for (Y9Menu y9Menu : menuList) {
            if (!y9Menu.getEnabled().booleanValue()) continue;
            VueMenu vueMenu = this.buildVueMenu(personId, authority, y9Menu.getId(), y9Menu);
            vueMenuList.add(vueMenu);
        }
    }

    @Generated
    public VueMenuBuilder(Y9MenuService y9MenuService, Y9OperationService y9OperationService, Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService) {
        this.y9MenuService = y9MenuService;
        this.y9OperationService = y9OperationService;
        this.y9PersonToResourceAndAuthorityService = y9PersonToResourceAndAuthorityService;
    }
}

