/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.permission;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.permission.VueMenuBuilder;
import net.risesoft.api.platform.permission.PersonResourceApi;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.model.platform.Menu;
import net.risesoft.model.platform.Resource;
import net.risesoft.model.platform.VueMenu;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.identity.Y9PersonToResourceAndAuthorityService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9Menu;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/personResource"}, produces={"application/json"})
public class PersonResourceApiImpl
implements PersonResourceApi {
    private final Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService;
    private final VueMenuBuilder vueMenuBuilder;

    public Y9Result<Boolean> hasPermission(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="resourceId") @NotBlank String resourceId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PersonToResourceAndAuthorityService.hasPermission(personId, resourceId, authority));
    }

    public Y9Result<Boolean> hasPermissionByCustomId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="customId") @NotBlank String customId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PersonToResourceAndAuthorityService.hasPermissionByCustomId(personId, customId, authority));
    }

    public Y9Result<List<VueMenu>> listMenusRecursively(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="authority") AuthorityEnum authority, @RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<VueMenu> vueMenuList = new ArrayList<VueMenu>();
        this.vueMenuBuilder.buildVueMenus(personId, authority, resourceId, vueMenuList);
        return Y9Result.success(vueMenuList);
    }

    public Y9Result<List<Menu>> listSubMenus(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="authority") AuthorityEnum authority, @RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Menu> y9MenuList = this.y9PersonToResourceAndAuthorityService.listSubMenus(personId, resourceId, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9MenuList, Menu.class));
    }

    public Y9Result<List<Resource>> listSubResources(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="authority") AuthorityEnum authority, @RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9ResourceBase> y9ResourceBaseList = this.y9PersonToResourceAndAuthorityService.listSubResources(personId, resourceId, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9ResourceBaseList, Resource.class));
    }

    @Generated
    public PersonResourceApiImpl(Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService, VueMenuBuilder vueMenuBuilder) {
        this.y9PersonToResourceAndAuthorityService = y9PersonToResourceAndAuthorityService;
        this.vueMenuBuilder = vueMenuBuilder;
    }
}

