/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.dto.CreatePersonDTO;
import net.risesoft.api.platform.org.dto.PersonInfoDTO;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9PersonExt;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.identity.person.Y9PersonToRole;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.PersonExt;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Role;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.identity.Y9PersonToRoleService;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9PersonExtService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.role.Y9Role;
import net.risesoft.y9public.service.role.Y9RoleService;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/person"}, produces={"application/json"})
public class PersonApiImpl
implements PersonApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonExtService y9PersonExtService;
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9RoleService y9RoleService;
    private final Y9PersonToRoleService y9PersonToRoleService;

    public Y9Result<Boolean> checkLoginName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="loginName") @NotBlank String loginName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PersonService.isLoginNameAvailable(personId, loginName));
    }

    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonService.delete(personId);
        return Y9Result.success();
    }

    public Y9Result<Object> disable(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonService.changeDisabled(personId);
        return Y9Result.success();
    }

    public Y9Result<Person> get(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findById(personId).orElse(null);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Result<Person> getByLoginName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="loginName") @NotBlank String loginName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findByLoginName(loginName).orElse(null);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Result<Person> getByCaId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="caId") @NotBlank String caId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findByCaId(caId).orElse(null);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Result<Person> getByLoginNameAndParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="loginName") @NotBlank String loginName, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person person = this.y9PersonService.getByLoginNameAndParentId(loginName, parentId).orElse(null);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)person, Person.class)));
    }

    public Y9Result<PersonExt> getPersonExtByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9PersonExt y9PersonExt = this.y9PersonExtService.findByPersonId(personId).orElse(null);
        return Y9Result.success((Object)((PersonExt)Y9ModelConvertUtil.convert((Object)y9PersonExt, PersonExt.class)));
    }

    public Y9Result<String> getPersonPhoto(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PersonExtService.getEncodePhotoByPersonId(personId));
    }

    public Y9Result<List<Person>> list(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.list(Boolean.FALSE);
        Collections.sort(y9PersonList);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Person>> listByIdTypeAndIdNum(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="idType") @NotBlank String idType, @RequestParam(value="idNum") @NotBlank String idNum) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByIdTypeAndIdNum(idType, idNum, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Person>> listByName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(name="name", required=false) String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByNameLike(name, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Person>> listByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByParentId(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Person>> listByParentIdAndDisabled(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="disabled") Boolean disabled) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByParentId(parentId, disabled);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Group>> listGroupsByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.y9GroupService.listByPersonId(personId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9GroupList, Group.class));
    }

    public Y9Result<List<OrgUnit>> listParentsByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> parentList = this.y9PersonService.listParents(personId);
        return Y9Result.success(ModelConvertUtil.orgBaseToOrgUnit(parentList));
    }

    public Y9Result<List<PersonInfoDTO>> listPersonInfoByName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(name="name", required=false) String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByNameLike(name, Boolean.FALSE);
        ArrayList<PersonInfoDTO> personInfoDTOList = new ArrayList<PersonInfoDTO>();
        if (!y9PersonList.isEmpty()) {
            for (Y9Person person : y9PersonList) {
                PersonInfoDTO personInfoDTO = new PersonInfoDTO();
                personInfoDTO.setPerson((Person)Y9ModelConvertUtil.convert((Object)person, Person.class, (String[])new String[]{"password"}));
                if (!Boolean.TRUE.equals(person.getDisabled())) {
                    List<Y9Position> positions = this.y9PositionService.listByPersonId(person.getId(), Boolean.FALSE);
                    personInfoDTO.setPositionList(Y9ModelConvertUtil.convert(positions, Position.class));
                }
                personInfoDTOList.add(personInfoDTO);
            }
        }
        return Y9Result.success(personInfoDTOList);
    }

    public Y9Result<List<Position>> listPositionsByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByPersonId(personId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PositionList, Position.class));
    }

    public Y9Result<List<Person>> listRecursivelyByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.compositeOrgBaseService.listAllDescendantPersons(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Person>> listRecursivelyByParentIdAndName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="name") @NotBlank String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.compositeOrgBaseService.searchAllPersonsRecursionDownward(parentId, name, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<List<Role>> listRoles(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<Role> roleList = new ArrayList<Role>();
        List<Y9PersonToRole> y9PersonToRoleList = this.y9PersonToRoleService.listByPersonId(personId);
        for (Y9PersonToRole y9PersonToRole : y9PersonToRoleList) {
            Y9Role y9Role = this.y9RoleService.getById(y9PersonToRole.getRoleId());
            roleList.add(ModelConvertUtil.y9RoleToRole(y9Role));
        }
        return Y9Result.success(roleList);
    }

    public Y9Result<Person> modifyPassword(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="oldPassword") @NotBlank String oldPassword, @RequestParam(value="newPassword") @NotBlank String newPassword) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.modifyPassword(personId, oldPassword, newPassword);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Page<Person> pageByName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(required=false) String name, @Validated Y9PageQuery pageQuery) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByNameLike(name, pageQuery);
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Y9Page<Person> pageByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="disabled") boolean disabled, @Validated Y9PageQuery pageQuery) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByParentId(parentId, disabled, pageQuery);
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Y9Page<Person> pageByParentIdAndName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="disabled") boolean disabled, @RequestParam(value="name", required=false) String name, Y9PageQuery pageQuery) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByParentId(parentId, disabled, name, pageQuery);
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Y9Result<Person> savePersonAvatar(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="avatar") @NotBlank String avatar) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.saveAvator(personId, avatar);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Result<Object> savePersonPhoto(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="photo") @NotBlank String photo) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonExtService.savePersonPhoto(personId, photo);
        return Y9Result.success();
    }

    public Y9Result<Object> savePersonSign(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="sign") @NotBlank String sign) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findById(personId).orElse(null);
        if (y9Person != null) {
            this.y9PersonExtService.savePersonSign(y9Person, sign);
        }
        return Y9Result.success();
    }

    public Y9Result<Person> savePersonWeixinId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="weixinId") @NotBlank String weixinId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.saveWeixinId(personId, weixinId);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    public Y9Result<Person> savePersonWithExt(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestBody @Validated CreatePersonDTO personDTO) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = (Y9Person)Y9ModelConvertUtil.convert((Object)personDTO, Y9Person.class);
        Y9PersonExt y9PersonExt = (Y9PersonExt)Y9ModelConvertUtil.convert((Object)personDTO, Y9PersonExt.class);
        y9Person = this.y9PersonService.saveOrUpdate(y9Person, y9PersonExt);
        return Y9Result.success((Object)((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class)));
    }

    @Generated
    public PersonApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9GroupService y9GroupService, Y9PersonExtService y9PersonExtService, Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9RoleService y9RoleService, Y9PersonToRoleService y9PersonToRoleService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9GroupService = y9GroupService;
        this.y9PersonExtService = y9PersonExtService;
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.y9RoleService = y9RoleService;
        this.y9PersonToRoleService = y9PersonToRoleService;
    }
}

