/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Organization;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/orgUnit"}, produces={"application/json"})
public class OrgUnitApiImpl
implements OrgUnitApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9OrganizationService y9OrganizationService;

    public Y9Result<OrgUnit> getBureau(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseService.findOrgUnitBureau(orgUnitId).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase));
    }

    public Y9Result<OrgUnit> getOrgUnit(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseService.findOrgUnit(orgUnitId).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase));
    }

    public Y9Result<OrgUnit> getOrgUnitDeletedById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseService.findOrgUnitDeleted(orgUnitId).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase));
    }

    public Y9Result<OrgUnit> getOrgUnitPersonOrPosition(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseService.findOrgUnitPersonOrPosition(orgUnitId).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase));
    }

    public Y9Result<Organization> getOrganization(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Organization y9OrgBase = this.compositeOrgBaseService.getOrgUnitOrganization(orgUnitId);
        return Y9Result.success((Object)((Organization)Y9ModelConvertUtil.convert((Object)y9OrgBase, Organization.class)));
    }

    public Y9Result<OrgUnit> getParent(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(orgUnitId).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.orgBaseToOrgUnit(parent));
    }

    public Y9Result<List<OrgUnit>> getSubTree(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId, @RequestParam(value="treeType") OrgTreeTypeEnum treeType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.getTree(orgUnitId, treeType, Boolean.FALSE);
        return Y9Result.success(ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList));
    }

    public Y9Result<List<Organization>> treeRoot(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Organization> y9OrganizationList = this.y9OrganizationService.list(Boolean.FALSE, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9OrganizationList, Organization.class));
    }

    public Y9Result<List<OrgUnit>> treeSearch(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="name") @NotBlank String name, @RequestParam(value="treeType") OrgTreeTypeEnum treeType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.treeSearch(name, treeType, Boolean.FALSE);
        return Y9Result.success(ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList));
    }

    public Y9Result<List<OrgUnit>> treeSearchByDn(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="name") @NotBlank String name, @RequestParam(value="treeType") OrgTreeTypeEnum treeType, @RequestParam(value="dnName") @NotBlank String dnName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.treeSearch(name, treeType, dnName, Boolean.FALSE);
        return Y9Result.success(ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList));
    }

    @Generated
    public OrgUnitApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9OrganizationService y9OrganizationService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9OrganizationService = y9OrganizationService;
    }
}

