/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.ManagerApi;
import net.risesoft.entity.Y9Manager;
import net.risesoft.model.platform.Manager;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.Y9ManagerService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/manager"}, produces={"application/json"})
public class ManagerApiImpl
implements ManagerApi {
    private final Y9ManagerService y9ManagerService;

    public Y9Result<Manager> get(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="managerId") @NotBlank String managerId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Manager y9Manager = this.y9ManagerService.findById(managerId).orElse(null);
        return Y9Result.success((Object)((Manager)Y9ModelConvertUtil.convert((Object)y9Manager, Manager.class)));
    }

    public Y9Result<Manager> getByLoginName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="loginName") @NotBlank String loginName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Manager y9Manager = this.y9ManagerService.findByLoginName(loginName).orElse(null);
        return Y9Result.success((Object)((Manager)Y9ModelConvertUtil.convert((Object)y9Manager, Manager.class)));
    }

    public Y9Result<Boolean> isDeptManager(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="managerId") @NotBlank String managerId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9ManagerService.isDeptManager(managerId, departmentId));
    }

    @Generated
    public ManagerApiImpl(Y9ManagerService y9ManagerService) {
        this.y9ManagerService = y9ManagerService;
    }
}

