/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.GroupApi;
import net.risesoft.api.platform.org.dto.CreateGroupDTO;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Person;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.relation.Y9PersonsToGroupsService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/group"}, produces={"application/json"})
public class GroupApiImpl
implements GroupApi {
    private final Y9PersonsToGroupsService y9PersonsToGroupsService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonService y9PersonService;

    public Y9Result<Object> addPerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonsToGroupsService.addPersons(groupId, new String[]{personId});
        return Y9Result.success();
    }

    public Y9Result<Group> create(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestBody @Validated CreateGroupDTO createGroupDTO) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Group y9Group = (Y9Group)Y9ModelConvertUtil.convert((Object)createGroupDTO, Y9Group.class);
        y9Group = this.y9GroupService.createGroup(y9Group);
        return Y9Result.success((Object)((Group)Y9ModelConvertUtil.convert((Object)y9Group, Group.class)));
    }

    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9GroupService.delete(groupId);
        return Y9Result.success();
    }

    public Y9Result<Group> get(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Group y9Group = this.y9GroupService.findById(groupId).orElse(null);
        return Y9Result.success((Object)((Group)Y9ModelConvertUtil.convert((Object)y9Group, Group.class)));
    }

    public Y9Result<List<Group>> listByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.y9GroupService.listByParentId(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9GroupList, Group.class));
    }

    public Y9Result<List<Person>> listPersonsByGroupId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByGroupId(groupId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<Object> removePerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonsToGroupsService.removePersons(groupId, new String[]{personId});
        return Y9Result.success();
    }

    @Generated
    public GroupApiImpl(Y9PersonsToGroupsService y9PersonsToGroupsService, Y9GroupService y9GroupService, Y9PersonService y9PersonService) {
        this.y9PersonsToGroupsService = y9PersonsToGroupsService;
        this.y9GroupService = y9GroupService;
        this.y9PersonService = y9PersonService;
    }
}

