/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.dto.CreateDepartmentDTO;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9DepartmentProp;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.enums.platform.DepartmentPropCategoryEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.DepartmentProp;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.Y9DepartmentPropService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/department"}, produces={"application/json"})
public class DepartmentApiImpl
implements DepartmentApi {
    private final Y9DepartmentService y9DepartmentService;
    private final Y9DepartmentPropService y9DepartmentPropService;

    public Y9Result<Department> create(@RequestParam(value="tenantId") @NotBlank String tenantId, @Validated @RequestBody CreateDepartmentDTO department) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Department y9Department = (Y9Department)Y9ModelConvertUtil.convert((Object)department, Y9Department.class);
        y9Department = this.y9DepartmentService.saveOrUpdate(y9Department);
        return Y9Result.success((Object)((Department)Y9ModelConvertUtil.convert((Object)y9Department, Department.class)));
    }

    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9DepartmentService.delete(departmentId);
        return Y9Result.success();
    }

    public Y9Result<Object> disable(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9DepartmentService.changeDisable(departmentId);
        return Y9Result.success();
    }

    public Y9Result<Department> get(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Department y9Department = this.y9DepartmentService.findById(departmentId).orElse(null);
        return Y9Result.success((Object)((Department)Y9ModelConvertUtil.convert((Object)y9Department, Department.class)));
    }

    public Y9Result<List<Department>> listBureauByNameLike(@NotBlank String tenantId, String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listBureauByNameLike(name, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    public Y9Result<List<Department>> listByIds(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="ids") @NotEmpty List<String> ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.list(ids);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    public Y9Result<List<Department>> listByName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="name") @NotBlank String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByNameLike(name, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    public Y9Result<List<Department>> listByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByParentId(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    public Y9Result<List<DepartmentProp>> listDepartmentPropByOrgUnitIdAndCategory(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId, @RequestParam(value="category") DepartmentPropCategoryEnum category) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9DepartmentProp> y9DepartmentPropList = this.y9DepartmentPropService.listByOrgBaseIdAndCategory(orgUnitId, category);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentPropList, DepartmentProp.class));
    }

    public Y9Result<List<OrgUnit>> listDepartmentPropOrgUnits(String tenantId, String departmentId, Integer category) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.y9DepartmentService.listDepartmentPropOrgUnits(departmentId, category, Boolean.FALSE);
        return Y9Result.success(ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList));
    }

    public Y9Result<List<Department>> listRecursivelyByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listRecursivelyByParentId(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    @Generated
    public DepartmentApiImpl(Y9DepartmentService y9DepartmentService, Y9DepartmentPropService y9DepartmentPropService) {
        this.y9DepartmentService = y9DepartmentService;
        this.y9DepartmentPropService = y9DepartmentPropService;
    }
}

