/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.service.tenant.impl;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import net.risesoft.enums.platform.DataSourceTypeEnum;
import net.risesoft.enums.platform.TenantTypeEnum;
import net.risesoft.exception.DataSourceErrorCodeEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import net.risesoft.y9.util.Y9Assert;
import net.risesoft.y9.util.base64.Y9Base64Util;
import net.risesoft.y9public.entity.tenant.Y9DataSource;
import net.risesoft.y9public.manager.tenant.Y9DataSourceManager;
import net.risesoft.y9public.repository.tenant.Y9DataSourceRepository;
import net.risesoft.y9public.service.tenant.Y9DataSourceService;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure1;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure11;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure13;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure3;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure5;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure7;
import net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl$AjcClosure9;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@Service(value="dataSourceService")
public class Y9DataSourceServiceImpl
implements Y9DataSourceService {
    private static final String DEFAULT_PASSWORD = "111111";
    private final Y9DataSourceRepository datasourceRepository;
    private final Y9DataSourceManager y9DataSourceManager;
    private final DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private final ConcurrentMap<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final ConcurrentMap<String, Y9DataSource> y9DataSourceMap = new ConcurrentHashMap<String, Y9DataSource>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public Y9DataSourceServiceImpl(Y9DataSourceRepository datasourceRepository, Y9DataSourceManager y9DataSourceManager) {
        this.datasourceRepository = datasourceRepository;
        this.y9DataSourceManager = y9DataSourceManager;
    }

    private static boolean isY9DataSourceModified(Y9DataSource cachedY9DataSource, Y9DataSource queriedY9DataSource) {
        boolean modified = false;
        if (cachedY9DataSource == null) {
            modified = true;
        } else if (Objects.equals(queriedY9DataSource.getType(), DataSourceTypeEnum.DRUID)) {
            if (!Objects.equals(cachedY9DataSource.getType(), DataSourceTypeEnum.DRUID)) {
                modified = true;
            }
            if (!queriedY9DataSource.getJndiName().equals(cachedY9DataSource.getJndiName())) {
                modified = true;
            }
        } else if (!(queriedY9DataSource.getUrl().equals(cachedY9DataSource.getUrl()) && queriedY9DataSource.getInitialSize().equals(cachedY9DataSource.getInitialSize()) && queriedY9DataSource.getMaxActive().equals(cachedY9DataSource.getMaxActive()) && queriedY9DataSource.getMinIdle().equals(cachedY9DataSource.getMinIdle()) && queriedY9DataSource.getUsername().equals(cachedY9DataSource.getUsername()) && queriedY9DataSource.getPassword().equals(cachedY9DataSource.getPassword()) && queriedY9DataSource.getType().equals((Object)cachedY9DataSource.getType()))) {
            modified = true;
        }
        return modified;
    }

    @Override
    public String buildDataSourceName(String shortName, TenantTypeEnum tenantType, String systemName) {
        return this.y9DataSourceManager.buildDataSourceName(shortName, tenantType, systemName);
    }

    @Override
    @Transactional(readOnly=false)
    public void changePassword(String id, String oldPassword, String newPassword) {
        String string = id;
        String string2 = oldPassword;
        String string3 = newPassword;
        Object[] objectArray = new Object[]{this, string, string2, string3};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource createTenantDefaultDataSource(String dbName) {
        String string = dbName;
        Object[] objectArray = new Object[]{this, string};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure3(objectArray), ajc$tjp_1);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource createTenantDefaultDataSource(String shortName, TenantTypeEnum tenantType, String systemName) {
        String string = shortName;
        TenantTypeEnum tenantTypeEnum = tenantType;
        String string2 = systemName;
        Object[] objectArray = new Object[]{this, string, tenantTypeEnum, string2};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    public Y9DataSource createTenantDefaultDataSource(String dbName, String id) {
        return this.y9DataSourceManager.createTenantDefaultDataSource(dbName, id);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Override
    @Transactional(readOnly=false)
    public void dropTenantDefaultDataSource(String dataSourceId, String dbName) {
        String string = dataSourceId;
        String string2 = dbName;
        Object[] objectArray = new Object[]{this, string, string2};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure9(objectArray), ajc$tjp_4);
    }

    @Override
    public Optional<Y9DataSource> findById(String id) {
        return this.datasourceRepository.findById((Object)id);
    }

    @Override
    public Optional<Y9DataSource> findByJndiName(String jndiName) {
        return this.datasourceRepository.findByJndiName(jndiName);
    }

    @Override
    public Y9DataSource getById(String id) {
        return (Y9DataSource)this.datasourceRepository.findById((Object)id).orElseThrow(() -> Y9ExceptionUtil.notFoundException((ErrorCode)DataSourceErrorCodeEnum.DATA_SOURCE_NOT_FOUND, (Object[])new Object[]{id}));
    }

    @Override
    public DataSource getDataSource(String id) {
        DataSource dataSource = (DataSource)this.dataSourceMap.get(id);
        Y9DataSource queriedY9DataSource = this.getById(id);
        Y9DataSource cachedY9DataSource = (Y9DataSource)this.y9DataSourceMap.get(id);
        if (Y9DataSourceServiceImpl.isY9DataSourceModified(cachedY9DataSource, queriedY9DataSource)) {
            DataSourceTypeEnum type = queriedY9DataSource.getType();
            if (Objects.equals(type, DataSourceTypeEnum.JNDI)) {
                dataSource = this.dataSourceLookup.getDataSource(queriedY9DataSource.getJndiName());
            } else {
                DruidDataSource ds = new DruidDataSource();
                if (StringUtils.isNotBlank((CharSequence)queriedY9DataSource.getDriver())) {
                    ds.setDriverClassName(queriedY9DataSource.getDriver());
                }
                ds.setTestOnBorrow(true);
                ds.setTestOnReturn(true);
                ds.setTestWhileIdle(true);
                ds.setValidationQuery("SELECT 1 FROM DUAL");
                ds.setInitialSize(queriedY9DataSource.getInitialSize().intValue());
                ds.setMaxActive(queriedY9DataSource.getMaxActive().intValue());
                ds.setMinIdle(queriedY9DataSource.getMinIdle().intValue());
                ds.setUrl(queriedY9DataSource.getUrl());
                ds.setUsername(queriedY9DataSource.getUsername());
                ds.setPassword(Y9Base64Util.decode((String)queriedY9DataSource.getPassword()));
                dataSource = ds;
            }
            this.dataSourceMap.put(id, dataSource);
            this.y9DataSourceMap.put(id, queriedY9DataSource);
        }
        return dataSource;
    }

    @Override
    public Page<Y9DataSource> page(Y9PageQuery pageQuery) {
        PageRequest pageable = PageRequest.of((int)pageQuery.getPage4Db(), (int)pageQuery.getSize());
        return this.datasourceRepository.findAll((Pageable)pageable);
    }

    @Override
    @Transactional(readOnly=false)
    public void resetDefaultPassword(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure11(objectArray), ajc$tjp_5);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource save(Y9DataSource y9DataSource) {
        Y9DataSource y9DataSource2 = y9DataSource;
        Object[] objectArray = new Object[]{this, y9DataSource2};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceServiceImpl$AjcClosure13(objectArray), ajc$tjp_6);
    }

    static {
        Y9DataSourceServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ void changePassword_aroundBody0(Y9DataSourceServiceImpl ajc$this, String id, String oldPassword, String newPassword) {
        Y9DataSource y9DataSource = ajc$this.getById(id);
        Y9Assert.isTrue((boolean)Objects.equals(Y9Base64Util.encode((String)oldPassword), y9DataSource.getPassword()), (ErrorCode)DataSourceErrorCodeEnum.DATA_SOURCE_OLD_PASSWORD_IS_WRONG, (Object[])new Object[0]);
        y9DataSource.setPassword(Y9Base64Util.encode((String)newPassword));
        ajc$this.save(y9DataSource);
    }

    static final /* synthetic */ Y9DataSource createTenantDefaultDataSource_aroundBody2(Y9DataSourceServiceImpl ajc$this, String dbName) {
        return ajc$this.y9DataSourceManager.createTenantDefaultDataSource(dbName);
    }

    static final /* synthetic */ Y9DataSource createTenantDefaultDataSource_aroundBody4(Y9DataSourceServiceImpl ajc$this, String shortName, TenantTypeEnum tenantType, String systemName) {
        return ajc$this.y9DataSourceManager.createTenantDefaultDataSource(shortName, tenantType, systemName);
    }

    static final /* synthetic */ void delete_aroundBody6(Y9DataSourceServiceImpl ajc$this, String id) {
        ajc$this.y9DataSourceManager.delete(id);
    }

    static final /* synthetic */ void dropTenantDefaultDataSource_aroundBody8(Y9DataSourceServiceImpl ajc$this, String dataSourceId, String dbName) {
        ajc$this.y9DataSourceManager.dropTenantDefaultDataSource(dataSourceId, dbName);
    }

    static final /* synthetic */ void resetDefaultPassword_aroundBody10(Y9DataSourceServiceImpl ajc$this, String id) {
        Y9DataSource y9DataSource = ajc$this.getById(id);
        Y9Assert.isNotTrue((boolean)Objects.equals(y9DataSource.getType(), DataSourceTypeEnum.JNDI), (ErrorCode)DataSourceErrorCodeEnum.JNDI_DATA_SOURCE_RESET_PASSWORD_NOT_ALLOWED, (Object[])new Object[0]);
        y9DataSource.setPassword(DEFAULT_PASSWORD);
        ajc$this.save(y9DataSource);
    }

    static final /* synthetic */ Y9DataSource save_aroundBody12(Y9DataSourceServiceImpl ajc$this, Y9DataSource y9DataSource) {
        return ajc$this.y9DataSourceManager.save(y9DataSource);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Y9DataSourceServiceImpl.java", Y9DataSourceServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changePassword", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String:java.lang.String:java.lang.String", "id:oldPassword:newPassword", "", "void"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTenantDefaultDataSource", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String", "dbName", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 106);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTenantDefaultDataSource", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String:net.risesoft.enums.platform.TenantTypeEnum:java.lang.String", "shortName:tenantType:systemName", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 112);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String", "id", "", "void"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dropTenantDefaultDataSource", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String:java.lang.String", "dataSourceId:dbName", "", "void"), 129);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resetDefaultPassword", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "java.lang.String", "id", "", "void"), 194);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.y9public.service.tenant.impl.Y9DataSourceServiceImpl", "net.risesoft.y9public.entity.tenant.Y9DataSource", "y9DataSource", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 206);
    }
}

