/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.service.resource.impl;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jodd.util.Base64;
import lombok.Generated;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.ResourceErrorCodeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.y9.exception.Y9BusinessException;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.entity.resource.Y9AppIcon;
import net.risesoft.y9public.repository.resource.Y9AppIconRepository;
import net.risesoft.y9public.service.Y9FileStoreService;
import net.risesoft.y9public.service.resource.Y9AppIconService;
import net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl$AjcClosure1;
import net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl$AjcClosure3;
import net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl$AjcClosure5;
import net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl$AjcClosure7;
import net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl$AjcClosure9;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;
import org.springframework.web.multipart.MultipartFile;

@Service(value="appIconService")
public class Y9AppIconServiceImpl
implements Y9AppIconService {
    @Generated
    private static final Logger LOGGER;
    private final Y9AppIconRepository appIconRepository;
    private final Y9FileStoreService y9FileStoreService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Override
    @Transactional(readOnly=false)
    public void delete(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9AppIconServiceImpl$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Y9AppIcon appIcon) {
        Y9AppIcon y9AppIcon = appIcon;
        Object[] objectArray = new Object[]{this, y9AppIcon};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9AppIconServiceImpl$AjcClosure3(objectArray), ajc$tjp_1);
    }

    @Override
    public Optional<Y9AppIcon> findById(String id) {
        return this.appIconRepository.findById((Object)id);
    }

    @Override
    public Optional<Y9AppIcon> findByName(String name) {
        return this.appIconRepository.findByName(name);
    }

    @Override
    public Y9AppIcon getById(String id) {
        return (Y9AppIcon)this.appIconRepository.findById((Object)id).orElseThrow(() -> Y9ExceptionUtil.notFoundException((ErrorCode)ResourceErrorCodeEnum.APP_ICON_NOT_FOUND, (Object[])new Object[]{id}));
    }

    @Override
    public List<Y9AppIcon> listAll() {
        return this.appIconRepository.findAll();
    }

    @Override
    public List<Y9AppIcon> listByName(String name) {
        return this.appIconRepository.findByNameContaining(name);
    }

    @Override
    public Page<Y9AppIcon> pageAll(Y9PageQuery pageQuery) {
        PageRequest pageable = PageRequest.of((int)pageQuery.getPage4Db(), (int)pageQuery.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.appIconRepository.findAll((Pageable)pageable);
    }

    @Override
    @Transactional(readOnly=false)
    public void refreshAppIconData() {
        Object[] objectArray = new Object[]{this};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9AppIconServiceImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9AppIcon save(MultipartFile iconFile, String remark) throws Y9BusinessException {
        MultipartFile multipartFile = iconFile;
        String string = remark;
        Object[] objectArray = new Object[]{this, multipartFile, string};
        return (Y9AppIcon)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9AppIconServiceImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Y9AppIcon appIcon) {
        Y9AppIcon y9AppIcon = appIcon;
        Object[] objectArray = new Object[]{this, y9AppIcon};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9AppIconServiceImpl$AjcClosure9(objectArray), ajc$tjp_4);
    }

    @Override
    public Page<Y9AppIcon> searchByName(String name, Y9PageQuery pageQuery) {
        PageRequest pageable = PageRequest.of((int)pageQuery.getPage4Db(), (int)pageQuery.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.appIconRepository.findByNameContaining(name, (Pageable)pageable);
    }

    @Generated
    public Y9AppIconServiceImpl(Y9AppIconRepository appIconRepository, Y9FileStoreService y9FileStoreService) {
        this.appIconRepository = appIconRepository;
        this.y9FileStoreService = y9FileStoreService;
    }

    static {
        Y9AppIconServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(Y9AppIconServiceImpl.class);
    }

    static final /* synthetic */ void delete_aroundBody0(Y9AppIconServiceImpl ajc$this, String id) {
        ajc$this.appIconRepository.deleteById((Object)id);
    }

    static final /* synthetic */ void delete_aroundBody2(Y9AppIconServiceImpl ajc$this, Y9AppIcon appIcon) {
        ajc$this.appIconRepository.delete((Object)appIcon);
    }

    static final /* synthetic */ void refreshAppIconData_aroundBody4(Y9AppIconServiceImpl ajc$this) {
        List apps = ajc$this.appIconRepository.findAll();
        for (Y9AppIcon appicon : apps) {
            try {
                byte[] b = ajc$this.y9FileStoreService.downloadFileToBytes(appicon.getPath());
                String iconData = Base64.encodeToString((byte[])b);
                appicon.setIconData(iconData);
                ajc$this.appIconRepository.save((Object)appicon);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    static final /* synthetic */ Y9AppIcon save_aroundBody6(Y9AppIconServiceImpl ajc$this, MultipartFile iconFile, String remark) {
        byte[] iconData = null;
        try {
            if (!iconFile.isEmpty()) {
                iconData = iconFile.getBytes();
            }
        }
        catch (IOException e1) {
            LOGGER.warn(e1.getMessage(), (Throwable)e1);
            throw new Y9BusinessException(500, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e1.getMessage());
        }
        String originalFilename = iconFile.getOriginalFilename();
        String imgName = FilenameUtils.getName((String)originalFilename);
        String imgType = FilenameUtils.getExtension((String)imgName);
        Optional y9AppIconOptional = ajc$this.appIconRepository.findByName(imgName);
        Y9AppIcon appIcon = null;
        if (y9AppIconOptional.isEmpty()) {
            appIcon = new Y9AppIcon();
            appIcon.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            appIcon.setName(imgName);
        } else {
            appIcon = (Y9AppIcon)y9AppIconOptional.get();
        }
        appIcon.setRemark(remark);
        appIcon.setType(imgType);
        String fullPath = Y9FileStore.buildPath((String[])new String[]{"riseplatform", "public", "appIcon"});
        try {
            appIcon.setPath(ajc$this.y9FileStoreService.uploadFile(iconFile, fullPath, imgName).getId());
            appIcon.setIconData(Base64.encodeToString((byte[])iconData));
            return (Y9AppIcon)ajc$this.appIconRepository.save((Object)appIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Y9BusinessException(500, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    static final /* synthetic */ void save_aroundBody8(Y9AppIconServiceImpl ajc$this, Y9AppIcon appIcon) {
        ajc$this.appIconRepository.save((Object)appIcon);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Y9AppIconServiceImpl.java", Y9AppIconServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl", "java.lang.String", "id", "", "void"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl", "net.risesoft.y9public.entity.resource.Y9AppIcon", "appIcon", "", "void"), 51);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshAppIconData", "net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl", "", "", "", "void"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl", "org.springframework.web.multipart.MultipartFile:java.lang.String", "iconFile:remark", "net.risesoft.y9.exception.Y9BusinessException", "net.risesoft.y9public.entity.resource.Y9AppIcon"), 106);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.y9public.service.resource.impl.Y9AppIconServiceImpl", "net.risesoft.y9public.entity.resource.Y9AppIcon", "appIcon", "", "void"), 147);
    }
}

