/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.pubsub.Y9PublishService;
import net.risesoft.y9.pubsub.message.Y9MessageCommon;
import net.risesoft.y9.pubsub.message.Y9MessageOrg;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Y9PublishServiceUtil {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9PublishServiceUtil.class);
    private static boolean inited = false;
    private static List<Y9PublishService> y9PublishServices = new ArrayList<Y9PublishService>();
    private static JdbcTemplate jdbcTemplate;

    private static void checkBeans() {
        if (inited) {
            return;
        }
        try {
            Map beans = Y9Context.getBeans(Y9PublishService.class);
            y9PublishServices.addAll(beans.values());
            jdbcTemplate = (JdbcTemplate)Y9Context.getBean((String)"jdbcTemplate4Public");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        inited = true;
    }

    public static void persistAndPublishMessageOrg(Y9MessageOrg msg, String eventName, String description) {
        Y9PublishServiceUtil.checkBeans();
        Y9PublishServiceUtil.publishMessageOrg(msg);
        Y9PublishServiceUtil.persistMessageOrg(msg, eventName, description);
    }

    private static void persistMessageCommon(Y9MessageCommon msg, String eventName, String description, String clientIp) {
        try {
            String objId = "";
            String tenantId = "";
            String operator = Y9LoginUserHolder.getUserInfo() == null ? "\u7cfb\u7edf" : Y9LoginUserHolder.getUserInfo().getName();
            jdbcTemplate.update("insert into Y9_PUBLISHED_EVENT(ID,TENANT_ID,EVENT_TYPE,EVENT_NAME,OBJ_ID,OPERATOR,CLIENT_IP,EVENT_DESCRIPTION, CREATE_TIME) values(?,?,?,?,?,?,?,?,?)", new Object[]{Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE), tenantId, msg.getEventType(), eventName, objId, operator, clientIp, description, new Date()});
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static void persistMessageOrg(Y9MessageOrg msg, String eventName, String description) {
        try {
            String operator = Y9LoginUserHolder.getUserInfo() == null ? "\u7cfb\u7edf" : Y9LoginUserHolder.getUserInfo().getName();
            String clientIp = null;
            ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (sra != null) {
                HttpServletRequest request = sra.getRequest();
                clientIp = Y9Context.getIpAddr((HttpServletRequest)request);
            }
            if (StringUtils.isBlank(clientIp)) {
                clientIp = Y9Context.getHostIp();
            }
            String objId = "";
            Serializable orgObj = msg.getOrgObj();
            if (orgObj instanceof OrgUnit) {
                OrgUnit orgUnit = (OrgUnit)orgObj;
                objId = orgUnit.getId();
            }
            jdbcTemplate.update("insert into Y9_PUBLISHED_EVENT(ID,TENANT_ID,EVENT_TYPE,EVENT_NAME,OBJ_ID,OPERATOR,CLIENT_IP,EVENT_DESCRIPTION,ENTITY_JSON, CREATE_TIME) values(?,?,?,?,?,?,?,?,?,?)", new Object[]{Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE), msg.getTenantId(), msg.getEventType(), eventName, objId, operator, clientIp, description, Y9JsonUtil.writeValueAsString((Object)orgObj), new Date()});
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void persistAndPublishMessageCommon(Y9MessageCommon msg, String eventName, String description, String clientIp) {
        Y9PublishServiceUtil.checkBeans();
        Y9PublishServiceUtil.persistMessageCommon(msg, eventName, description, clientIp);
    }

    public static void publishMessageCommon(Y9MessageCommon msg) {
        Y9PublishServiceUtil.checkBeans();
        for (Y9PublishService s : y9PublishServices) {
            s.publishMessageCommon(msg);
        }
    }

    public static void publishMessageOrg(Y9MessageOrg msg) {
        Y9PublishServiceUtil.checkBeans();
        for (Y9PublishService s : y9PublishServices) {
            s.publishMessageOrg(msg);
        }
    }
}

