/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.util.Objects;
import net.risesoft.consts.OrgLevelConsts;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.enums.platform.OrgTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class Y9OrgUtil {
    public static boolean isMoved(Y9OrgBase originOrgBase, Y9OrgBase updateOrgBase) {
        return !Objects.equals(originOrgBase.getParentId(), updateOrgBase.getParentId());
    }

    public static boolean isCurrentOrAncestorChanged(Y9OrgBase originOrgBase, Y9OrgBase updateOrgBase) {
        return !Objects.equals(originOrgBase.getDn(), updateOrgBase.getDn()) || !Objects.equals(originOrgBase.getGuidPath(), updateOrgBase.getGuidPath());
    }

    public static boolean isRenamed(Y9OrgBase originOrgBase, Y9OrgBase updateOrgBase) {
        return !Objects.equals(originOrgBase.getName(), updateOrgBase.getName());
    }

    public static boolean isAncestorOf(Y9OrgBase a, Y9OrgBase b) {
        return Y9OrgUtil.isDescendantOf(b, a);
    }

    public static boolean isSameOf(Y9OrgBase a, Y9OrgBase b) {
        return Objects.equals(a, b);
    }

    public static boolean isDescendantOf(Y9OrgBase a, Y9OrgBase b) {
        return a.getGuidPath().contains(b.getGuidPath()) && !Objects.equals(a.getGuidPath(), b.getGuidPath());
    }

    public static String buildDn(OrgTypeEnum orgTypeEnum, String name, String parentDn) {
        if (StringUtils.isEmpty((CharSequence)parentDn)) {
            return OrgLevelConsts.getOrgLevel((OrgTypeEnum)orgTypeEnum) + name;
        }
        return OrgLevelConsts.getOrgLevel((OrgTypeEnum)orgTypeEnum) + name + "," + parentDn;
    }

    public static String buildGuidPath(String parentGuidPath, String id) {
        if (StringUtils.isEmpty((CharSequence)parentGuidPath)) {
            return id;
        }
        return parentGuidPath + "," + id;
    }
}

