/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.org.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.exception.AuthenticationErrorCodeEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.manager.org.CompositeOrgBaseManager;
import net.risesoft.model.platform.AuthenticateResult;
import net.risesoft.model.platform.Message;
import net.risesoft.model.platform.Person;
import net.risesoft.repository.Y9DepartmentRepository;
import net.risesoft.repository.Y9PersonRepository;
import net.risesoft.service.org.AuthService;
import net.risesoft.util.Y9PlatformUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9.util.base64.Y9Base64Util;
import net.risesoft.y9.util.signing.Y9MessageDigest;
import net.risesoft.y9public.entity.user.Y9User;
import net.risesoft.y9public.repository.user.Y9UserRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static final String LOGINNAME_EMPTY = "loginName cannt be empty";
    private static final String PASSWORD_EMPTY = "password cannt be empty";
    private final Y9UserRepository y9UserRepository;
    private final Y9DepartmentRepository y9DepartmentRepository;
    private final Y9PersonRepository y9PersonRepository;
    private final CompositeOrgBaseManager compositeOrgBaseManager;

    @Override
    public Message authenticate(String loginName, String password) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)loginName)) {
            message.setStatus("fail");
            message.setMsg(LOGINNAME_EMPTY);
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            message.setStatus("fail");
            message.setMsg(PASSWORD_EMPTY);
            return message;
        }
        String newpassword = "";
        try {
            newpassword = Y9Base64Util.decode((String)password);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
        if (y9PersonOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)y9PersonOptional.get()).getPassword())) {
            message.setStatus("fail");
            message.setMsg("loginName or password is incorrect");
            return message;
        }
        message.setStatus("success");
        message.setMsg(((Y9Person)y9PersonOptional.get()).getId());
        return message;
    }

    @Override
    public Message authenticate2(String tenantName, String loginName, String password) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            message.setStatus("fail");
            message.setMsg("tenantName cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)loginName)) {
            message.setStatus("fail");
            message.setMsg(LOGINNAME_EMPTY);
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            message.setStatus("fail");
            message.setMsg(PASSWORD_EMPTY);
            return message;
        }
        String newpassword = "";
        try {
            newpassword = Y9Base64Util.decode((String)password);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
        if (y9PersonOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)y9PersonOptional.get()).getPassword())) {
            message.setStatus("fail");
            message.setMsg("loginName or password is incorrect");
            return message;
        }
        message.setStatus("success");
        message.setMsg(((Y9Person)y9PersonOptional.get()).getId());
        return message;
    }

    @Override
    public AuthenticateResult authenticate3(String loginName, String base64EncodedPassword) {
        AuthenticateResult authenticateResult = new AuthenticateResult();
        String newpassword = "";
        try {
            newpassword = Y9Base64Util.decode((String)base64EncodedPassword);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Y9Person person = null;
        String tenantId = "";
        if (loginName.contains("&")) {
            String realLoginName = loginName.split("&")[0];
            String fakeLoginName = loginName.split("&")[1];
            List tenantIds = Y9PlatformUtil.getTenantByLoginName((String)"operation");
            if (!tenantIds.isEmpty()) {
                tenantId = (String)tenantIds.get(0);
            }
            Optional y9UserOptional = this.y9UserRepository.findByTenantIdAndLoginNameAndOriginalTrue(tenantId, fakeLoginName);
            Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(realLoginName);
            if (y9UserOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9User)y9UserOptional.get()).getPassword()) || y9PersonOptional.isEmpty()) {
                throw Y9ExceptionUtil.businessException((ErrorCode)AuthenticationErrorCodeEnum.LOGINNAME_PASSWORD_INCORRECT, (Object[])new Object[0]);
            }
            person = (Y9Person)y9PersonOptional.get();
        } else {
            Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
            if (y9PersonOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)y9PersonOptional.get()).getPassword())) {
                throw Y9ExceptionUtil.businessException((ErrorCode)AuthenticationErrorCodeEnum.LOGINNAME_PASSWORD_INCORRECT, (Object[])new Object[0]);
            }
            person = (Y9Person)y9PersonOptional.get();
        }
        Y9OrgBase department = this.compositeOrgBaseManager.getOrgUnitAsParent(person.getParentId());
        Y9OrgBase bureau = this.compositeOrgBaseManager.getOrgUnitBureau(person.getId());
        authenticateResult.setPerson((Person)Y9ModelConvertUtil.convert((Object)person, Person.class));
        authenticateResult.setTenantId(Y9LoginUserHolder.getTenantId());
        authenticateResult.setDeptName(department.getName());
        authenticateResult.setBureauName(bureau.getName());
        return authenticateResult;
    }

    @Override
    public Message authenticate3(String tenantName, String loginName, String password) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            message.setStatus("fail");
            message.setMsg("tenantName cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)loginName)) {
            message.setStatus("fail");
            message.setMsg(LOGINNAME_EMPTY);
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            message.setStatus("fail");
            message.setMsg(PASSWORD_EMPTY);
            return message;
        }
        String newpassword = "";
        try {
            newpassword = Y9Base64Util.decode((String)password);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Y9Person person = null;
        String tenantId = "";
        if (loginName.contains("&")) {
            Optional y9UserOptional;
            String realLoginName = loginName.split("&")[0];
            String fakeLoginName = loginName.split("&")[1];
            List tenantIds = Y9PlatformUtil.getTenantByLoginName((String)"operation");
            if (!tenantIds.isEmpty()) {
                tenantId = (String)tenantIds.get(0);
            }
            if ((y9UserOptional = this.y9UserRepository.findByTenantIdAndLoginNameAndOriginalTrue(tenantId, fakeLoginName)).isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9User)y9UserOptional.get()).getPassword())) {
                message.setStatus("fail");
                message.setMsg("loginName or password is incorrect");
                return message;
            }
            person = this.y9PersonRepository.findByLoginNameAndOriginalTrue(realLoginName).orElse(null);
        } else {
            Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
            if (y9PersonOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)y9PersonOptional.get()).getPassword())) {
                message.setStatus("fail");
                message.setMsg("loginName or password is incorrect");
                return message;
            }
            person = (Y9Person)y9PersonOptional.get();
        }
        message.setStatus("success");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("person", person);
        map.put("tenantId", Y9LoginUserHolder.getTenantId());
        Y9Department y9Department = this.y9DepartmentRepository.findById((Object)person.getParentId()).orElse(null);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseManager.getOrgUnitBureau(person.getId());
        map.put("deptName", y9Department != null ? y9Department.getName() : "");
        map.put("bureauName", y9OrgBase != null ? y9OrgBase.getName() : "");
        message.setMsg(Y9JsonUtil.writeValueAsString(map));
        return message;
    }

    @Override
    public Message authenticate4(String tenantName, String loginName) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            message.setStatus("fail");
            message.setMsg("tenantName cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)loginName)) {
            message.setStatus("fail");
            message.setMsg(LOGINNAME_EMPTY);
            return message;
        }
        Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
        if (y9PersonOptional.isEmpty()) {
            message.setStatus("fail");
            message.setMsg("No matching user according to the loginName");
            return message;
        }
        message.setStatus("success");
        HashMap<String, Object> jsonObject = new HashMap<String, Object>(16);
        jsonObject.put("person", y9PersonOptional.get());
        jsonObject.put("tenantId", Y9LoginUserHolder.getTenantId());
        message.setMsg(jsonObject.toString());
        return message;
    }

    @Override
    public AuthenticateResult authenticate5(String mobile, String base64EncodedPassword) {
        AuthenticateResult authenticateResult = new AuthenticateResult();
        String password = Y9Base64Util.decode((String)base64EncodedPassword);
        Optional optionalY9Person = this.y9PersonRepository.findByDisabledFalseAndMobileAndOriginal(mobile, Boolean.TRUE);
        if (optionalY9Person.isEmpty() || !Y9MessageDigest.bcryptMatch((String)password, (String)((Y9Person)optionalY9Person.get()).getPassword())) {
            throw Y9ExceptionUtil.businessException((ErrorCode)AuthenticationErrorCodeEnum.LOGINNAME_PASSWORD_INCORRECT, (Object[])new Object[0]);
        }
        Y9Person person = (Y9Person)optionalY9Person.get();
        Y9OrgBase department = this.compositeOrgBaseManager.getOrgUnitAsParent(person.getParentId());
        Y9OrgBase bureau = this.compositeOrgBaseManager.getOrgUnitBureau(person.getId());
        authenticateResult.setPerson((Person)Y9ModelConvertUtil.convert((Object)person, Person.class));
        authenticateResult.setTenantId(Y9LoginUserHolder.getTenantId());
        authenticateResult.setDeptName(department.getName());
        authenticateResult.setBureauName(bureau.getName());
        return authenticateResult;
    }

    @Override
    public Message authenticate5(String tenantShortName, String mobile, String password) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)tenantShortName)) {
            message.setStatus("fail");
            message.setMsg("tenantShortName cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            message.setStatus("fail");
            message.setMsg("mobile cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            message.setStatus("fail");
            message.setMsg(PASSWORD_EMPTY);
            return message;
        }
        String newpassword = Y9Base64Util.decode((String)password);
        Optional optionalY9Person = this.y9PersonRepository.findByDisabledFalseAndMobileAndOriginal(mobile, Boolean.TRUE);
        if (optionalY9Person.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)optionalY9Person.get()).getPassword())) {
            message.setStatus("fail");
            message.setMsg("mobile or password is incorrect");
            return message;
        }
        Y9Person person = (Y9Person)optionalY9Person.get();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("person", person);
        map.put("tenantId", Y9LoginUserHolder.getTenantId());
        Y9Department y9Department = this.y9DepartmentRepository.findById((Object)person.getParentId()).orElse(null);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseManager.getOrgUnitBureau(person.getId());
        map.put("deptName", y9Department != null ? y9Department.getName() : "");
        map.put("bureauName", y9OrgBase != null ? y9OrgBase.getName() : "");
        message.setStatus("success");
        message.setMsg(Y9JsonUtil.writeValueAsString(map));
        return message;
    }

    @Override
    public Message authenticate6(String tenantShortName, String loginName, String password, String parentId) {
        Message message = new Message();
        if (StringUtils.isEmpty((CharSequence)tenantShortName)) {
            message.setStatus("fail");
            message.setMsg("tenantName cannt be empty");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)loginName)) {
            message.setStatus("fail");
            message.setMsg(LOGINNAME_EMPTY);
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            message.setStatus("fail");
            message.setMsg(PASSWORD_EMPTY);
            return message;
        }
        String newpassword = "";
        try {
            newpassword = Y9Base64Util.decode((String)password);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Y9Person person = null;
        String tenantId = "";
        if (loginName.contains("&")) {
            Optional y9UserOptional;
            String realLoginName = loginName.split("&")[0];
            String fakeLoginName = loginName.split("&")[1];
            List tenantIds = Y9PlatformUtil.getTenantByLoginName((String)"operation");
            if (!tenantIds.isEmpty()) {
                tenantId = (String)tenantIds.get(0);
            }
            if ((y9UserOptional = this.y9UserRepository.findByTenantIdAndLoginNameAndOriginalTrue(tenantId, fakeLoginName)).isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9User)y9UserOptional.get()).getPassword())) {
                message.setStatus("fail");
                message.setMsg("loginName or password is incorrect");
                return message;
            }
            person = this.y9PersonRepository.findByLoginNameAndOriginalTrue(realLoginName).orElse(null);
        } else {
            Optional y9PersonOptional = this.y9PersonRepository.findByLoginNameAndOriginalTrue(loginName);
            if (y9PersonOptional.isEmpty() || !Y9MessageDigest.bcryptMatch((String)newpassword, (String)((Y9Person)y9PersonOptional.get()).getPassword())) {
                message.setStatus("fail");
                message.setMsg("loginName or password is incorrect");
                return message;
            }
            person = (Y9Person)y9PersonOptional.get();
        }
        message.setStatus("success");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("person", person);
        map.put("tenantId", Y9LoginUserHolder.getTenantId());
        Y9Department y9Department = this.y9DepartmentRepository.findById((Object)person.getParentId()).orElse(null);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseManager.getOrgUnitBureau(person.getId());
        map.put("deptName", y9Department != null ? y9Department.getName() : "");
        map.put("bureauName", y9OrgBase != null ? y9OrgBase.getName() : "");
        message.setMsg(Y9JsonUtil.writeValueAsString(map));
        return message;
    }

    @Generated
    public AuthServiceImpl(Y9UserRepository y9UserRepository, Y9DepartmentRepository y9DepartmentRepository, Y9PersonRepository y9PersonRepository, CompositeOrgBaseManager compositeOrgBaseManager) {
        this.y9UserRepository = y9UserRepository;
        this.y9DepartmentRepository = y9DepartmentRepository;
        this.y9PersonRepository = y9PersonRepository;
        this.compositeOrgBaseManager = compositeOrgBaseManager;
    }
}

