/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.identity.impl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.relation.Y9PersonsToGroups;
import net.risesoft.entity.relation.Y9PersonsToPositions;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.manager.identity.Y9PersonToRoleManager;
import net.risesoft.manager.identity.Y9PositionToRoleManager;
import net.risesoft.manager.org.Y9PersonManager;
import net.risesoft.manager.org.Y9PositionManager;
import net.risesoft.service.identity.IdentityRoleCalculator;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.service.relation.Y9PersonsToGroupsService;
import net.risesoft.service.relation.Y9PersonsToPositionsService;
import net.risesoft.y9public.entity.role.Y9Role;
import net.risesoft.y9public.manager.role.Y9RoleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdentityRoleCalculatorImpl
implements IdentityRoleCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityRoleCalculatorImpl.class);
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9PersonsToGroupsService y9PersonsToGroupsService;
    private final Y9PersonsToPositionsService y9PersonsToPositionsService;
    private final Y9PersonManager y9PersonManager;
    private final Y9RoleManager y9RoleManager;
    private final Y9PositionManager y9PositionManager;
    private final Y9PersonToRoleManager y9PersonToRoleManager;
    private final Y9PositionToRoleManager y9PositionToRoleManager;

    private void recalculate(Y9Person y9Person, List<Y9Role> personRelatedY9RoleList) {
        this.removeInvalidByPersonId(y9Person.getId(), personRelatedY9RoleList);
        for (Y9Role y9Role : personRelatedY9RoleList) {
            this.y9PersonToRoleManager.save(y9Person, y9Role);
        }
    }

    private void recalculate(Y9Position y9Position, List<Y9Role> positionRelatedY9RoleList) {
        this.removeInvalidByPositionId(y9Position.getId(), positionRelatedY9RoleList);
        for (Y9Role y9Role : positionRelatedY9RoleList) {
            this.y9PositionToRoleManager.save(y9Position, y9Role);
        }
    }

    @Override
    public void recalculateByOrgUnitId(String orgUnitId) {
        Optional<Y9OrgBase> y9OrgBaseOptional = this.compositeOrgBaseService.findOrgUnit(orgUnitId);
        if (y9OrgBaseOptional.isPresent()) {
            Y9OrgBase y9OrgBase = y9OrgBaseOptional.get();
            OrgTypeEnum orgType = y9OrgBase.getOrgType();
            switch (orgType) {
                case ORGANIZATION: {
                    List<String> personIdList = this.y9PersonService.findIdByGuidPathStartingWith(y9OrgBase.getGuidPath());
                    for (String string : personIdList) {
                        this.recalculateByPersonId(string);
                    }
                    List<String> positionIdList = this.y9PositionService.findIdByGuidPathStartingWith(y9OrgBase.getGuidPath());
                    for (String positionId : positionIdList) {
                        this.recalculateByPositionId(positionId);
                    }
                    break;
                }
                case DEPARTMENT: {
                    List<String> list = this.y9PersonService.findIdByGuidPathStartingWith(y9OrgBase.getGuidPath());
                    for (String string : list) {
                        this.recalculateByPersonId(string);
                    }
                    List<String> positionIds = this.y9PositionService.findIdByGuidPathStartingWith(y9OrgBase.getGuidPath());
                    for (String positionId : positionIds) {
                        this.recalculateByPositionId(positionId);
                    }
                    break;
                }
                case GROUP: {
                    List<Y9PersonsToGroups> list = this.y9PersonsToGroupsService.findByGroupId(orgUnitId);
                    for (Y9PersonsToGroups orgPersonsGroup : list) {
                        String orgPersonId = orgPersonsGroup.getPersonId();
                        this.recalculateByPersonId(orgPersonId);
                    }
                    break;
                }
                case POSITION: {
                    this.recalculateByPositionId(orgUnitId);
                    List<Y9PersonsToPositions> y9PersonsToPositionsList = this.y9PersonsToPositionsService.findByPositionId(orgUnitId);
                    for (Y9PersonsToPositions y9PersonsToPositions : y9PersonsToPositionsList) {
                        this.recalculateByPersonId(y9PersonsToPositions.getPersonId());
                    }
                    break;
                }
                case PERSON: {
                    this.recalculateByPersonId(orgUnitId);
                    break;
                }
            }
        }
    }

    @Override
    public void recalculateByPersonId(String personId) {
        try {
            Optional<Y9Person> y9PersonOptional = this.y9PersonManager.findById(personId);
            if (y9PersonOptional.isPresent()) {
                Y9Person y9Person = y9PersonOptional.get();
                List<Y9Role> personRelatedY9RoleList = this.y9RoleManager.listOrgUnitRelatedWithoutNegative(y9Person.getId());
                this.recalculate(y9Person, personRelatedY9RoleList);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u8ba1\u7b97\u4eba\u5458[{}]\u89d2\u8272\u53d1\u751f\u5f02\u5e38", (Object)personId, (Object)e);
        }
    }

    private void recalculateByPositionId(String positionId) {
        try {
            List<Y9Role> positionRelatedY9RoleList = this.y9RoleManager.listOrgUnitRelatedWithoutNegative(positionId);
            Y9Position y9Position = this.y9PositionManager.getById(positionId);
            this.recalculate(y9Position, positionRelatedY9RoleList);
        }
        catch (Exception e) {
            LOGGER.warn("\u8ba1\u7b97\u5c97\u4f4d[{}]\u89d2\u8272\u53d1\u751f\u5f02\u5e38", (Object)positionId, (Object)e);
        }
    }

    private void removeInvalidByPersonId(String personId, List<Y9Role> newCalculatedY9RoleList) {
        List<String> originY9RoleIdList = this.y9PersonToRoleManager.findRoleIdByPersonId(personId);
        Set newCalculatedY9RoleIdSet = newCalculatedY9RoleList.stream().map(Y9Role::getId).collect(Collectors.toSet());
        for (String roleId : originY9RoleIdList) {
            if (newCalculatedY9RoleIdSet.contains(roleId)) continue;
            this.y9PersonToRoleManager.removeByPersonIdAndRoleId(personId, roleId);
        }
    }

    private void removeInvalidByPositionId(String positionId, List<Y9Role> newCalculatedY9RoleList) {
        List<String> originY9RoleIdList = this.y9PositionToRoleManager.listRoleIdByPositionId(positionId);
        Set newCalculatedY9RoleIdSet = newCalculatedY9RoleList.stream().map(Y9Role::getId).collect(Collectors.toSet());
        for (String roleId : originY9RoleIdList) {
            if (newCalculatedY9RoleIdSet.contains(roleId)) continue;
            this.y9PositionToRoleManager.deleteByPositionIdAndRoleId(positionId, roleId);
        }
    }

    @Generated
    public IdentityRoleCalculatorImpl(CompositeOrgBaseService compositeOrgBaseService, Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9PersonsToGroupsService y9PersonsToGroupsService, Y9PersonsToPositionsService y9PersonsToPositionsService, Y9PersonManager y9PersonManager, Y9RoleManager y9RoleManager, Y9PositionManager y9PositionManager, Y9PersonToRoleManager y9PersonToRoleManager, Y9PositionToRoleManager y9PositionToRoleManager) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.y9PersonsToGroupsService = y9PersonsToGroupsService;
        this.y9PersonsToPositionsService = y9PersonsToPositionsService;
        this.y9PersonManager = y9PersonManager;
        this.y9RoleManager = y9RoleManager;
        this.y9PositionManager = y9PositionManager;
        this.y9PersonToRoleManager = y9PersonToRoleManager;
        this.y9PositionToRoleManager = y9PositionToRoleManager;
    }
}

