/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.identity.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.permission.Y9Authorization;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.AuthorizationPrincipalTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.manager.identity.Y9PersonToResourceAndAuthorityManager;
import net.risesoft.manager.identity.Y9PositionToResourceAndAuthorityManager;
import net.risesoft.manager.org.CompositeOrgBaseManager;
import net.risesoft.manager.org.Y9PersonManager;
import net.risesoft.repository.permission.Y9AuthorizationRepository;
import net.risesoft.repository.relation.Y9OrgBasesToRolesRepository;
import net.risesoft.service.identity.IdentityResourceCalculator;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import net.risesoft.y9public.entity.role.Y9Role;
import net.risesoft.y9public.manager.role.Y9RoleManager;
import net.risesoft.y9public.service.resource.CompositeResourceService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdentityResourceCalculatorImpl
implements IdentityResourceCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityResourceCalculatorImpl.class);
    private final Y9AuthorizationRepository y9AuthorizationRepository;
    private final Y9OrgBasesToRolesRepository y9OrgBasesToRolesRepository;
    private final CompositeOrgBaseManager compositeOrgBaseManager;
    private final CompositeResourceService compositeResourceService;
    private final Y9PersonManager y9PersonManager;
    private final Y9RoleManager y9RoleManager;
    private final Y9PersonToResourceAndAuthorityManager y9PersonToResourceAndAuthorityManager;
    private final Y9PositionToResourceAndAuthorityManager y9PositionToResourceAndAuthorityManager;

    private boolean anyHidden(List<Y9Authorization> resourceRelatedY9AuthorizationList) {
        return resourceRelatedY9AuthorizationList.stream().anyMatch(authorization -> AuthorityEnum.HIDDEN.equals((Object)authorization.getAuthority()));
    }

    private List<String> getIdentityRelatedPrincipalId(String identityId) {
        ArrayList<String> principalIdList = new ArrayList<String>();
        List<Y9Role> y9RoleList = this.y9RoleManager.listOrgUnitRelatedWithoutNegative(identityId);
        principalIdList.addAll(y9RoleList.stream().map(Y9Role::getId).collect(Collectors.toList()));
        List<String> orgUnitIdList = this.y9RoleManager.listOrgUnitIdRecursively(identityId);
        principalIdList.addAll(orgUnitIdList);
        return principalIdList.stream().distinct().collect(Collectors.toList());
    }

    public List<Y9Authorization> listByResourceIdRelated(String resourceId) {
        ArrayList<Y9Authorization> authorizationList = new ArrayList<Y9Authorization>();
        this.listByResourceIdRelated(authorizationList, resourceId);
        return authorizationList;
    }

    private void listByResourceIdRelated(List<Y9Authorization> authorizationList, String resourceId) {
        if (StringUtils.isNotBlank((CharSequence)resourceId)) {
            authorizationList.addAll(this.y9AuthorizationRepository.findByResourceId(resourceId));
            this.listByResourceIdRelated(authorizationList, this.compositeResourceService.findById(resourceId).getParentId());
        }
    }

    @Override
    public void recalculateByOrgUnitId(String orgUnitId) {
        Optional<Y9OrgBase> y9OrgBaseOptional = this.compositeOrgBaseManager.findOrgUnit(orgUnitId);
        if (y9OrgBaseOptional.isPresent()) {
            Y9OrgBase y9OrgBase = y9OrgBaseOptional.get();
            if (OrgTypeEnum.PERSON.equals((Object)y9OrgBase.getOrgType())) {
                this.recalculateByPerson((Y9Person)y9OrgBase);
                return;
            }
            if (OrgTypeEnum.POSITION.equals((Object)y9OrgBase.getOrgType())) {
                this.recalculateByPosition((Y9Position)y9OrgBase);
                List<Y9Person> y9PersonList = this.y9PersonManager.listByPositionId(y9OrgBase.getId(), Boolean.FALSE);
                for (Y9Person y9Person : y9PersonList) {
                    this.recalculateByPerson(y9Person);
                }
                return;
            }
            List<Y9Person> personList = this.compositeOrgBaseManager.listAllDescendantPersons(orgUnitId);
            for (Y9Person person : personList) {
                this.recalculateByPerson(person);
            }
            List<Y9Position> positionList = this.compositeOrgBaseManager.listAllDescendantPositions(orgUnitId);
            for (Y9Position position : positionList) {
                this.recalculateByPosition(position);
            }
        }
    }

    @Override
    public void recalculateByPerson(Y9Person person) {
        try {
            List<String> principalIdList = this.getIdentityRelatedPrincipalId(person.getId());
            List principalRelatedY9AuthorizationList = this.y9AuthorizationRepository.getByPrincipalIdIn(principalIdList);
            List<String> authorizationIdList = principalRelatedY9AuthorizationList.stream().map(Y9Authorization::getId).collect(Collectors.toList());
            this.y9PersonToResourceAndAuthorityManager.deleteByPersonIdAndAuthorizationIdNotIn(person.getId(), authorizationIdList);
            Map<String, List<Y9Authorization>> resourceIdAuthorizationListMap = principalRelatedY9AuthorizationList.stream().collect(Collectors.groupingBy(Y9Authorization::getResourceId));
            for (String resourceId : resourceIdAuthorizationListMap.keySet()) {
                Y9ResourceBase y9ResourceBase = this.compositeResourceService.findById(resourceId);
                this.recalculateByPerson(resourceIdAuthorizationListMap, new HashSet<String>(), y9ResourceBase, person, new Y9Authorization());
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u8ba1\u7b97\u4eba\u5458[{}]\u6743\u9650\u53d1\u751f\u5f02\u5e38", (Object)person.getId(), (Object)e);
        }
    }

    @Override
    public void recalculateByPosition(Y9Position position) {
        try {
            List<String> principalIdList = this.getIdentityRelatedPrincipalId(position.getId());
            List principalRelatedY9AuthorizationList = this.y9AuthorizationRepository.getByPrincipalIdIn(principalIdList);
            List<String> authorizationIdList = principalRelatedY9AuthorizationList.stream().map(Y9Authorization::getId).collect(Collectors.toList());
            this.y9PositionToResourceAndAuthorityManager.deleteByPositionIdAndAuthorizationIdNotIn(position.getId(), authorizationIdList);
            Map<String, List<Y9Authorization>> resourceIdAuthorizationListMap = principalRelatedY9AuthorizationList.stream().collect(Collectors.groupingBy(Y9Authorization::getResourceId));
            for (String resourceId : resourceIdAuthorizationListMap.keySet()) {
                Y9ResourceBase y9ResourceBase = this.compositeResourceService.findById(resourceId);
                this.recalculateByPosition(resourceIdAuthorizationListMap, new HashSet<String>(), y9ResourceBase, position, new Y9Authorization());
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u8ba1\u7b97\u5c97\u4f4d[{}]\u6743\u9650\u53d1\u751f\u5f02\u5e38", (Object)position.getId(), (Object)e);
        }
    }

    @Override
    public void recalculateByResourceId(String resourceId) {
        List<Y9Authorization> authorizationList = this.listByResourceIdRelated(resourceId);
        for (Y9Authorization y9Authorization : authorizationList) {
            if (AuthorizationPrincipalTypeEnum.ROLE.equals((Object)y9Authorization.getPrincipalType())) {
                List orgUnitIdList = this.y9OrgBasesToRolesRepository.listOrgIdsByRoleId(y9Authorization.getPrincipalId());
                for (String orgUnitId : orgUnitIdList) {
                    this.recalculateByOrgUnitId(orgUnitId);
                }
                continue;
            }
            this.recalculateByOrgUnitId(y9Authorization.getPrincipalId());
        }
    }

    private void recalculateByPerson(Map<String, List<Y9Authorization>> resourceIdAuthorizationListMap, Set<String> solvedResourceIdSet, Y9ResourceBase y9ResourceBase, Y9Person person, Y9Authorization inheritY9Authorization) {
        block4: {
            block5: {
                String resourceId = y9ResourceBase.getId();
                if (solvedResourceIdSet.contains(resourceId)) break block4;
                solvedResourceIdSet.add(resourceId);
                List<Y9Authorization> resourceRelatedY9AuthorizationList = resourceIdAuthorizationListMap.get(resourceId);
                if (resourceRelatedY9AuthorizationList == null || resourceRelatedY9AuthorizationList.isEmpty()) break block5;
                if (this.anyHidden(resourceRelatedY9AuthorizationList)) {
                    this.y9PersonToResourceAndAuthorityManager.deleteByPersonIdAndResourceId(person.getId(), resourceId);
                    return;
                }
                for (Y9Authorization y9Authorization : resourceRelatedY9AuthorizationList) {
                    this.y9PersonToResourceAndAuthorityManager.saveOrUpdate(y9ResourceBase, person, y9Authorization, Boolean.FALSE);
                    List<Y9ResourceBase> subResourceList = this.compositeResourceService.listChildrenById(y9ResourceBase.getId());
                    for (Y9ResourceBase resource : subResourceList) {
                        this.recalculateByPerson(resourceIdAuthorizationListMap, solvedResourceIdSet, resource, person, y9Authorization);
                    }
                }
                break block4;
            }
            if (!Boolean.TRUE.equals(y9ResourceBase.getInherit()) || AuthorityEnum.HIDDEN.equals((Object)inheritY9Authorization.getAuthority())) break block4;
            this.y9PersonToResourceAndAuthorityManager.saveOrUpdate(y9ResourceBase, person, inheritY9Authorization, Boolean.TRUE);
            List<Y9ResourceBase> subResourceList = this.compositeResourceService.listChildrenById(y9ResourceBase.getId());
            for (Y9ResourceBase resource : subResourceList) {
                this.recalculateByPerson(resourceIdAuthorizationListMap, solvedResourceIdSet, resource, person, inheritY9Authorization);
            }
        }
    }

    private void recalculateByPosition(Map<String, List<Y9Authorization>> resourceIdAuthorizationListMap, Set<String> solvedResourceIdSet, Y9ResourceBase y9ResourceBase, Y9Position position, Y9Authorization inheritY9Authorization) {
        block4: {
            block5: {
                String resourceId = y9ResourceBase.getId();
                if (solvedResourceIdSet.contains(resourceId)) break block4;
                solvedResourceIdSet.add(resourceId);
                List<Y9Authorization> resourceRelatedY9AuthorizationList = resourceIdAuthorizationListMap.get(y9ResourceBase.getId());
                if (resourceRelatedY9AuthorizationList == null || resourceRelatedY9AuthorizationList.isEmpty()) break block5;
                if (this.anyHidden(resourceRelatedY9AuthorizationList)) {
                    this.y9PositionToResourceAndAuthorityManager.deleteByPositionIdAndResourceId(position.getId(), resourceId);
                    return;
                }
                for (Y9Authorization y9Authorization : resourceRelatedY9AuthorizationList) {
                    this.y9PositionToResourceAndAuthorityManager.saveOrUpdate(y9ResourceBase, position, y9Authorization, Boolean.FALSE);
                    List<Y9ResourceBase> subResourceList = this.compositeResourceService.listChildrenById(y9ResourceBase.getId());
                    for (Y9ResourceBase resource : subResourceList) {
                        this.recalculateByPosition(resourceIdAuthorizationListMap, solvedResourceIdSet, resource, position, y9Authorization);
                    }
                }
                break block4;
            }
            if (!Boolean.TRUE.equals(y9ResourceBase.getInherit()) || AuthorityEnum.HIDDEN.equals((Object)inheritY9Authorization.getAuthority())) break block4;
            this.y9PositionToResourceAndAuthorityManager.saveOrUpdate(y9ResourceBase, position, inheritY9Authorization, Boolean.TRUE);
            List<Y9ResourceBase> subResourceList = this.compositeResourceService.listChildrenById(y9ResourceBase.getId());
            for (Y9ResourceBase resource : subResourceList) {
                this.recalculateByPosition(resourceIdAuthorizationListMap, solvedResourceIdSet, resource, position, inheritY9Authorization);
            }
        }
    }

    @Generated
    public IdentityResourceCalculatorImpl(Y9AuthorizationRepository y9AuthorizationRepository, Y9OrgBasesToRolesRepository y9OrgBasesToRolesRepository, CompositeOrgBaseManager compositeOrgBaseManager, CompositeResourceService compositeResourceService, Y9PersonManager y9PersonManager, Y9RoleManager y9RoleManager, Y9PersonToResourceAndAuthorityManager y9PersonToResourceAndAuthorityManager, Y9PositionToResourceAndAuthorityManager y9PositionToResourceAndAuthorityManager) {
        this.y9AuthorizationRepository = y9AuthorizationRepository;
        this.y9OrgBasesToRolesRepository = y9OrgBasesToRolesRepository;
        this.compositeOrgBaseManager = compositeOrgBaseManager;
        this.compositeResourceService = compositeResourceService;
        this.y9PersonManager = y9PersonManager;
        this.y9RoleManager = y9RoleManager;
        this.y9PersonToResourceAndAuthorityManager = y9PersonToResourceAndAuthorityManager;
        this.y9PositionToResourceAndAuthorityManager = y9PositionToResourceAndAuthorityManager;
    }
}

