/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.listener;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.relation.Y9PersonsToGroups;
import net.risesoft.entity.relation.Y9PersonsToPositions;
import net.risesoft.enums.SettingEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.manager.org.Y9GroupManager;
import net.risesoft.manager.org.Y9PersonManager;
import net.risesoft.manager.org.Y9PositionManager;
import net.risesoft.model.platform.PersonsGroups;
import net.risesoft.model.platform.PersonsPositions;
import net.risesoft.service.setting.Y9SettingService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.util.Y9PublishServiceUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.pubsub.event.Y9EntityCreatedEvent;
import net.risesoft.y9.pubsub.event.Y9EntityDeletedEvent;
import net.risesoft.y9.pubsub.event.Y9EntityUpdatedEvent;
import net.risesoft.y9.pubsub.message.Y9MessageOrg;
import net.risesoft.y9.util.Y9StringUtil;
import net.risesoft.y9.util.signing.Y9MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class OrgEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgEventListener.class);
    private final Y9GroupManager y9GroupManager;
    private final Y9PersonManager y9PersonManager;
    private final Y9PositionManager y9PositionManager;
    private final Y9SettingService y9SettingService;

    @TransactionalEventListener
    public void onOrgUnitCreated(Y9EntityCreatedEvent<? extends Y9OrgBase> event) {
        Y9OrgBase y9OrgBase = (Y9OrgBase)event.getEntity();
        OrgTypeEnum orgType = y9OrgBase.getOrgType();
        String eventName = Y9StringUtil.format((String)"\u65b0\u589e{}", (Object[])new Object[]{orgType.getName()});
        String eventDescription = Y9StringUtil.format((String)"\u65b0\u589e{}[{}]", (Object[])new Object[]{orgType.getName(), y9OrgBase.getName()});
        String eventType = null;
        switch (orgType) {
            case ORGANIZATION: {
                eventType = "RISEORGEVENT_TYPE_ADD_ORGANIZATION";
                break;
            }
            case GROUP: {
                eventType = "RISEORGEVENT_TYPE_ADD_GROUP";
                break;
            }
            case POSITION: {
                eventType = "RISEORGEVENT_TYPE_ADD_POSITION";
                break;
            }
            case DEPARTMENT: {
                eventType = "RISEORGEVENT_TYPE_ADD_DEPARTMENT";
                break;
            }
            case PERSON: {
                eventType = "RISEORGEVENT_TYPE_ADD_PERSON";
            }
        }
        if (!OrgTypeEnum.MANAGER.equals((Object)orgType)) {
            Y9MessageOrg msg = new Y9MessageOrg((Serializable)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase), eventType, Y9LoginUserHolder.getTenantId());
            Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u8282\u70b9\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
            }
        }
    }

    @TransactionalEventListener
    public void onOrgUnitDeleted(Y9EntityDeletedEvent<? extends Y9OrgBase> event) {
        Y9OrgBase y9OrgBase = (Y9OrgBase)event.getEntity();
        OrgTypeEnum orgType = y9OrgBase.getOrgType();
        String eventName = Y9StringUtil.format((String)"\u5220\u9664{}", (Object[])new Object[]{orgType.getName()});
        String eventDescription = Y9StringUtil.format((String)"\u5220\u9664{}[{}]", (Object[])new Object[]{orgType.getName(), y9OrgBase.getName()});
        String eventType = null;
        switch (orgType) {
            case ORGANIZATION: {
                eventType = "RISEORGEVENT_TYPE_DELETE_ORGANIZATION";
                break;
            }
            case GROUP: {
                eventType = "RISEORGEVENT_TYPE_DELETE_GROUP";
                break;
            }
            case POSITION: {
                eventType = "RISEORGEVENT_TYPE_DELETE_POSITION";
                break;
            }
            case DEPARTMENT: {
                eventType = "RISEORGEVENT_TYPE_DELETE_DEPARTMENT";
                break;
            }
            case PERSON: {
                eventType = "RISEORGEVENT_TYPE_DELETE_PERSON";
            }
        }
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5220\u9664\u7ec4\u7ec7\u8282\u70b9\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @TransactionalEventListener
    public void onOrgUnitUpdated(Y9EntityUpdatedEvent<? extends Y9OrgBase> event) {
        Y9OrgBase originOrgUnit = (Y9OrgBase)event.getOriginEntity();
        Y9OrgBase updatedOrgUnit = (Y9OrgBase)event.getUpdatedEntity();
        OrgTypeEnum orgType = updatedOrgUnit.getOrgType();
        String eventName = Y9StringUtil.format((String)"\u66f4\u65b0{}", (Object[])new Object[]{orgType.getName()});
        String eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0{}[{}]", (Object[])new Object[]{orgType.getName(), originOrgUnit.getName()});
        if (!Objects.equals(originOrgUnit.getParentId(), updatedOrgUnit.getParentId())) {
            eventName = Y9StringUtil.format((String)"\u79fb\u52a8{}", (Object[])new Object[]{orgType.getName()});
            eventDescription = Y9StringUtil.format((String)"\u79fb\u52a8{}[{}]", (Object[])new Object[]{orgType.getName(), originOrgUnit.getName()});
        } else if (!Objects.equals(originOrgUnit.getDisabled(), updatedOrgUnit.getDisabled())) {
            eventName = Y9StringUtil.format((String)"{}{}", (Object[])new Object[]{updatedOrgUnit.getDisabled() != false ? "\u7981\u7528" : "\u542f\u7528", orgType.getName()});
            eventDescription = Y9StringUtil.format((String)"{}{}[{}]", (Object[])new Object[]{updatedOrgUnit.getDisabled() != false ? "\u7981\u7528" : "\u542f\u7528", orgType.getName(), originOrgUnit.getName()});
        } else if (!Objects.equals(originOrgUnit.getTabIndex(), updatedOrgUnit.getTabIndex())) {
            eventName = Y9StringUtil.format((String)"\u66f4\u65b0{}\u6392\u5e8f\u53f7", (Object[])new Object[]{orgType.getName()});
            eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0{}[{}]\u6392\u5e8f\u53f7\u4e3a[{}]", (Object[])new Object[]{orgType.getName(), originOrgUnit.getName(), updatedOrgUnit.getTabIndex()});
        }
        String eventType = null;
        switch (orgType) {
            case ORGANIZATION: {
                eventType = "RISEORGEVENT_TYPE_UPDATE_ORGANIZATION";
                break;
            }
            case GROUP: {
                eventType = "RISEORGEVENT_TYPE_UPDATE_GROUP";
                break;
            }
            case POSITION: {
                eventType = "RISEORGEVENT_TYPE_UPDATE_POSITION";
                break;
            }
            case DEPARTMENT: {
                eventType = "RISEORGEVENT_TYPE_UPDATE_DEPARTMENT";
                break;
            }
            case PERSON: {
                eventType = "RISEORGEVENT_TYPE_UPDATE_PERSON";
                Y9Person originPerson = (Y9Person)originOrgUnit;
                Y9Person updatedPerson = (Y9Person)updatedOrgUnit;
                if (Objects.equals(originPerson.getPassword(), updatedPerson.getPassword())) break;
                eventName = "\u4fee\u6539\u5bc6\u7801";
                eventDescription = Y9StringUtil.format((String)"\u4fee\u6539[{}]\u5bc6\u7801", (Object[])new Object[]{updatedOrgUnit.getName()});
                String defaultPassword = this.y9SettingService.get(SettingEnum.USER_DEFAULT_PASSWORD, String.class);
                if (!Y9MessageDigest.bcryptMatch((String)defaultPassword, (String)updatedPerson.getPassword())) break;
                eventName = "\u91cd\u7f6e\u5bc6\u7801";
                eventDescription = Y9StringUtil.format((String)"\u91cd\u7f6e[{}]\u5bc6\u7801", (Object[])new Object[]{updatedOrgUnit.getName()});
            }
        }
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)ModelConvertUtil.orgBaseToOrgUnit(updatedOrgUnit), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u66f4\u65b0\u7ec4\u7ec7\u8282\u70b9\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToGroupsCreated(Y9EntityCreatedEvent<Y9PersonsToGroups> event) {
        Y9PersonsToGroups y9PersonsToGroups = (Y9PersonsToGroups)event.getEntity();
        Y9Person person = this.y9PersonManager.getById(y9PersonsToGroups.getPersonId());
        Y9Group group = this.y9GroupManager.getById(y9PersonsToGroups.getGroupId());
        String eventName = "\u7528\u6237\u7ec4\u6dfb\u52a0\u4eba\u5458";
        String eventDescription = Y9StringUtil.format((String)"\u7528\u6237\u7ec4[{}]\u6dfb\u52a0\u4eba\u5458[{}]", (Object[])new Object[]{group.getName(), person.getName()});
        String eventType = "RISEORGEVENT_TYPE_GROUP_ADDPERSON";
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsGroups)ModelConvertUtil.convert((Object)y9PersonsToGroups, PersonsGroups.class)), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u65b0\u589e\u4eba\u5458\u7528\u6237\u7ec4\u5173\u8054\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToGroupsDeleted(Y9EntityDeletedEvent<Y9PersonsToGroups> event) {
        Y9PersonsToGroups y9PersonsToGroups = (Y9PersonsToGroups)event.getEntity();
        Optional<Y9Person> y9PersonOptional = this.y9PersonManager.findById(y9PersonsToGroups.getPersonId());
        Optional<Y9Group> y9GroupOptional = this.y9GroupManager.findById(y9PersonsToGroups.getGroupId());
        if (y9GroupOptional.isPresent() && y9PersonOptional.isPresent()) {
            Y9Person person = y9PersonOptional.get();
            Y9Group group = y9GroupOptional.get();
            String eventName = "\u7528\u6237\u7ec4\u79fb\u9664\u4eba\u5458";
            String eventDescription = Y9StringUtil.format((String)"\u7528\u6237\u7ec4[{}]\u79fb\u9664\u4eba\u5458[{}]", (Object[])new Object[]{group.getName(), person.getName()});
            String eventType = "RISEORGEVENT_TYPE_GROUP_REMOVEPERSON";
            Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsGroups)ModelConvertUtil.convert((Object)y9PersonsToGroups, PersonsGroups.class)), eventType, Y9LoginUserHolder.getTenantId());
            Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u8282\u70b9\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
            }
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToGroupsUpdated(Y9EntityUpdatedEvent<Y9PersonsToGroups> event) {
        String eventDescription;
        String eventName;
        Y9PersonsToGroups originPersonToGroups = (Y9PersonsToGroups)event.getOriginEntity();
        Y9PersonsToGroups updatedPersonToGroups = (Y9PersonsToGroups)event.getUpdatedEntity();
        Y9Person person = this.y9PersonManager.getById(updatedPersonToGroups.getPersonId());
        Y9Group group = this.y9GroupManager.getById(updatedPersonToGroups.getGroupId());
        String eventType = "RISEORGEVENT_TYPE_GROUP_ORDER";
        if (!Objects.equals(originPersonToGroups.getGroupOrder(), updatedPersonToGroups.getGroupOrder())) {
            eventName = "\u66f4\u65b0\u4eba\u5458\u7684\u7528\u6237\u7ec4\u6392\u5e8f";
            eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0\u4eba\u5458[{}]\u7684\u7528\u6237\u7ec4[{}]\u6392\u5e8f\u4e3a[{}]", (Object[])new Object[]{person.getName(), group.getName(), updatedPersonToGroups.getGroupOrder()});
        } else {
            eventName = "\u66f4\u65b0\u7528\u6237\u7ec4\u7684\u4eba\u5458\u6392\u5e8f";
            eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0\u7528\u6237\u7ec4[{}]\u7684\u6210\u5458[{}]\u6392\u5e8f\u4e3a[{}]", (Object[])new Object[]{group.getName(), person.getName(), updatedPersonToGroups.getPersonOrder()});
        }
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsGroups)ModelConvertUtil.convert((Object)updatedPersonToGroups, PersonsGroups.class)), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u66f4\u65b0Y9PersonsToGroups\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToPositionsCreated(Y9EntityCreatedEvent<Y9PersonsToPositions> event) {
        Y9PersonsToPositions y9PersonsToPositions = (Y9PersonsToPositions)event.getEntity();
        Y9Person person = this.y9PersonManager.getById(y9PersonsToPositions.getPersonId());
        Y9Position position = this.y9PositionManager.getById(y9PersonsToPositions.getPositionId());
        String eventName = "\u5c97\u4f4d\u6dfb\u52a0\u4eba\u5458";
        String eventDescription = Y9StringUtil.format((String)"\u5c97\u4f4d[{}]\u6dfb\u52a0\u4eba\u5458[{}]", (Object[])new Object[]{position.getName(), person.getName()});
        String eventType = "RISEORGEVENT_TYPE_POSITION_ADDPERSON";
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsPositions)ModelConvertUtil.convert((Object)y9PersonsToPositions, PersonsPositions.class)), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u65b0\u589e\u4eba\u5458\u7528\u6237\u7ec4\u5173\u8054\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToPositionsDeleted(Y9EntityDeletedEvent<Y9PersonsToPositions> event) {
        Y9PersonsToPositions y9PersonsToPositions = (Y9PersonsToPositions)event.getEntity();
        Optional<Y9Person> y9PersonOptional = this.y9PersonManager.findById(y9PersonsToPositions.getPersonId());
        Optional<Y9Position> y9PositionOptional = this.y9PositionManager.findById(y9PersonsToPositions.getPositionId());
        if (y9PersonOptional.isPresent() && y9PositionOptional.isPresent()) {
            Y9Person person = y9PersonOptional.get();
            Y9Position position = y9PositionOptional.get();
            String eventName = "\u5c97\u4f4d\u79fb\u9664\u4eba\u5458";
            String eventDescription = Y9StringUtil.format((String)"\u5c97\u4f4d[{}]\u79fb\u9664\u4eba\u5458[{}]", (Object[])new Object[]{position.getName(), person.getName()});
            String eventType = "RISEORGEVENT_TYPE_POSITION_REMOVEPERSON";
            Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsPositions)ModelConvertUtil.convert((Object)y9PersonsToPositions, PersonsPositions.class)), eventType, Y9LoginUserHolder.getTenantId());
            Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u8282\u70b9\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
            }
        }
    }

    @TransactionalEventListener
    public void onY9PersonsToPositionsUpdated(Y9EntityUpdatedEvent<Y9PersonsToPositions> event) {
        String eventDescription;
        String eventName;
        Y9PersonsToPositions originPersonsToPositions = (Y9PersonsToPositions)event.getOriginEntity();
        Y9PersonsToPositions updatedPersonsToPositions = (Y9PersonsToPositions)event.getUpdatedEntity();
        Y9Person person = this.y9PersonManager.getById(updatedPersonsToPositions.getPersonId());
        Y9Position position = this.y9PositionManager.getById(updatedPersonsToPositions.getPositionId());
        String eventType = "RISEORGEVENT_TYPE_POSITION_ORDER";
        if (!Objects.equals(originPersonsToPositions.getPersonOrder(), updatedPersonsToPositions.getPersonOrder())) {
            eventName = "\u66f4\u65b0\u5c97\u4f4d\u7684\u4eba\u5458\u6392\u5e8f";
            eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0\u5c97\u4f4d[{}]\u7684\u4eba\u5458[{}]\u6392\u5e8f\u4e3a[{}]", (Object[])new Object[]{position.getName(), person.getName(), updatedPersonsToPositions.getPersonOrder()});
        } else {
            eventName = "\u66f4\u65b0\u4eba\u5458\u7684\u5c97\u4f4d\u6392\u5e8f";
            eventDescription = Y9StringUtil.format((String)"\u66f4\u65b0\u4eba\u5458[{}]\u7684\u5c97\u4f4d[{}]\u6392\u5e8f\u4e3a[{}]", (Object[])new Object[]{person.getName(), position.getName(), updatedPersonsToPositions.getPositionOrder()});
        }
        Y9MessageOrg msg = new Y9MessageOrg((Serializable)((PersonsPositions)ModelConvertUtil.convert((Object)updatedPersonsToPositions, PersonsPositions.class)), eventType, Y9LoginUserHolder.getTenantId());
        Y9PublishServiceUtil.persistAndPublishMessageOrg(msg, eventName, eventDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u66f4\u65b0Y9PersonsToPositions\u540e\u4fdd\u5b58\u53ca\u53d1\u9001\u6d88\u606f\u5230\u4e2d\u95f4\u4ef6\u5b8c\u6210");
        }
    }

    @Generated
    public OrgEventListener(Y9GroupManager y9GroupManager, Y9PersonManager y9PersonManager, Y9PositionManager y9PositionManager, Y9SettingService y9SettingService) {
        this.y9GroupManager = y9GroupManager;
        this.y9PersonManager = y9PersonManager;
        this.y9PositionManager = y9PositionManager;
        this.y9SettingService = y9SettingService;
    }
}

