/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.dataio.org;

import cn.hutool.core.io.resource.ClassPathResource;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.dataio.JxlsUtil;
import net.risesoft.dataio.org.Y9OrgTreeDataHandler;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Job;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.enums.platform.SexEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.pojo.ObjectSheet;
import net.risesoft.pojo.PersonInformation;
import net.risesoft.pojo.PersonSheet;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9JobService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.jxls.reader.ReaderBuilder;
import org.jxls.reader.XLSReadStatus;
import org.jxls.reader.XLSReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="y9OrgTreeExcelDataHandler")
public class Y9OrgTreeExcelDataHandlerImpl
implements Y9OrgTreeDataHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9OrgTreeExcelDataHandlerImpl.class);
    private static final String SPLITTER = ",";
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9DepartmentService y9DepartmentService;
    private final Y9PersonService y9PersonService;
    private final Y9OrganizationService y9OrganizationService;
    private final Y9PositionService y9PositionService;
    private final Y9GroupService y9GroupService;
    private final Y9JobService y9JobService;

    private void executeDepartment(String parentId, List<ObjectSheet> departmentList) {
        List<Y9Department> departments = this.y9DepartmentService.listByParentId(parentId, false);
        if (!departments.isEmpty()) {
            for (Y9Department department : departments) {
                ObjectSheet departmentSheet = new ObjectSheet();
                ArrayList<PersonSheet> personSheetList = new ArrayList<PersonSheet>();
                List<Y9Person> personList = this.y9PersonService.listByParentId(department.getId(), false);
                if (personList != null) {
                    for (Y9Person y9Person : personList) {
                        PersonSheet person = new PersonSheet();
                        person.setDn(y9Person.getDn());
                        person.setEmail(y9Person.getEmail());
                        person.setLoginName(y9Person.getLoginName());
                        person.setMobile(y9Person.getMobile());
                        person.setName(y9Person.getName());
                        person.setOfficeFax(y9Person.getOfficeFax());
                        person.setOfficePhone(y9Person.getOfficePhone());
                        person.setTabIndex(y9Person.getTabIndex());
                        personSheetList.add(person);
                    }
                } else {
                    PersonSheet person = new PersonSheet();
                    person.setNum(1);
                    personSheetList.add(person);
                }
                departmentSheet.setDn(department.getDn());
                departmentSheet.setName(department.getName());
                departmentSheet.setNum(departmentList.size() + 1);
                departmentSheet.setPersonList(personSheetList);
                departmentList.add(departmentSheet);
            }
            for (Y9Department department : departments) {
                this.executeDepartment(department.getId(), departmentList);
            }
        }
    }

    private List<ObjectSheet> executeGroup(List<Y9Group> groupList) {
        ArrayList<ObjectSheet> list = new ArrayList<ObjectSheet>();
        if (!groupList.isEmpty()) {
            int i = 1;
            for (Y9Group group : groupList) {
                ObjectSheet groupSheet = new ObjectSheet();
                ArrayList<PersonSheet> personSheetList = new ArrayList<PersonSheet>();
                List<Y9Person> personList = this.y9PersonService.listByGroupId(group.getId(), Boolean.FALSE);
                if (personList != null) {
                    for (Y9Person y9Person : personList) {
                        PersonSheet person = new PersonSheet();
                        person.setDn(y9Person.getDn());
                        person.setName(y9Person.getName());
                        personSheetList.add(person);
                    }
                } else {
                    PersonSheet person = new PersonSheet();
                    personSheetList.add(person);
                }
                groupSheet.setDn(group.getDn());
                groupSheet.setName(group.getName());
                groupSheet.setPersonList(personSheetList);
                groupSheet.setNum(i++);
                list.add(groupSheet);
            }
        }
        return list;
    }

    private List<ObjectSheet> executePosition(List<Y9Position> positionList) {
        ArrayList<ObjectSheet> list = new ArrayList<ObjectSheet>();
        if (!positionList.isEmpty()) {
            int i = 1;
            for (Y9Position position : positionList) {
                ObjectSheet positionSheet = new ObjectSheet();
                ArrayList<PersonSheet> personSheetList = new ArrayList<PersonSheet>();
                List<Y9Person> personList = this.y9PersonService.listByPositionId(position.getId(), Boolean.FALSE);
                if (personList != null) {
                    for (Y9Person y9Person : personList) {
                        PersonSheet person = new PersonSheet();
                        person.setDn(y9Person.getDn());
                        person.setName(y9Person.getName());
                        personSheetList.add(person);
                    }
                } else {
                    PersonSheet person = new PersonSheet();
                    personSheetList.add(person);
                }
                positionSheet.setDn(position.getDn());
                positionSheet.setName(position.getName());
                positionSheet.setPersonList(personSheetList);
                positionSheet.setNum(i++);
                list.add(positionSheet);
            }
        }
        return list;
    }

    @Override
    public void exportOrgTree(String orgId, OutputStream outputStream) {
        try (InputStream in = new ClassPathResource("/template/exportTemplate.xlsx").getStream();){
            Map<String, Object> map = this.xlsOrgTreeData(orgId);
            JxlsUtil jxlsUtil = new JxlsUtil();
            jxlsUtil.exportExcel(in, outputStream, map);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void exportPerson(String orgBaseId, OutputStream outputStream) {
        try (InputStream in = new ClassPathResource("/template/exportSimpleTemplate.xlsx").getStream();){
            Map<String, Object> map = this.xlsPersonData(orgBaseId);
            JxlsUtil jxlsUtil = new JxlsUtil();
            jxlsUtil.exportExcel(in, outputStream, map);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Y9Result<Object> importOrgTree(InputStream inputStream, String orgId) {
        return null;
    }

    @Override
    public Y9Result<Object> importPerson(InputStream dataInputStream, String orgId) {
        ArrayList personList = new ArrayList();
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        ret.put("success", false);
        HashMap map = new HashMap(16);
        map.put("personList", personList);
        StringBuilder repeatNames = new StringBuilder();
        StringBuilder repeatMobiles = new StringBuilder();
        StringBuilder mobileNulls = new StringBuilder();
        StringBuilder mobileErrors = new StringBuilder();
        try {
            BufferedInputStream xmlInputStream = new BufferedInputStream(this.getClass().getResourceAsStream("/template/xmlconfig.xml"));
            XLSReader xlsReader = ReaderBuilder.buildFromXML((InputStream)xmlInputStream);
            XLSReadStatus readStatus = xlsReader.read(dataInputStream, map);
            if (readStatus.isStatusOK()) {
                LOGGER.info("################\u6210\u529f\u8bfb\u53d6\u5230XLS\u6587\u4ef6\u6570\u636e##########################");
                for (PersonInformation pf : personList) {
                    Map<String, Object> retMap = this.impData2Db(pf, orgId);
                    if ("true".equals(retMap.get("isRepeat"))) {
                        if (StringUtils.isBlank((CharSequence)repeatNames)) {
                            repeatNames.append(retMap.get("name").toString());
                        } else {
                            repeatNames.append(repeatNames + "\u3001" + retMap.get("name").toString());
                        }
                    }
                    if ("true".equals(retMap.get("isMobileNull"))) {
                        if (StringUtils.isBlank((CharSequence)mobileNulls)) {
                            mobileNulls.append(retMap.get("mobileNullNames").toString());
                        } else {
                            mobileNulls.append(mobileNulls + "\u3001" + retMap.get("mobileNullNames").toString());
                        }
                    }
                    if ("true".equals(retMap.get("isMobileError"))) {
                        if (StringUtils.isBlank((CharSequence)mobileErrors)) {
                            mobileErrors.append(retMap.get("mobileErrorNames").toString());
                        } else {
                            mobileErrors.append(mobileErrors + "\u3001" + retMap.get("mobileErrorNames").toString());
                        }
                    }
                    if (!"true".equals(retMap.get("isMobileRepeat"))) continue;
                    if (StringUtils.isBlank((CharSequence)repeatMobiles)) {
                        repeatMobiles.append(retMap.get("mobileNames").toString() + ":" + retMap.get("mobiles").toString());
                        continue;
                    }
                    repeatMobiles.append(repeatMobiles + "\u3001" + retMap.get("mobileNames").toString() + ":" + retMap.get("mobiles").toString());
                }
                ret.put("success", true);
                if (StringUtils.isBlank((CharSequence)repeatNames.toString())) {
                    ret.put("isRepeat", false);
                } else {
                    ret.put("isRepeat", true);
                    ret.put("names", repeatNames.toString());
                }
                if (StringUtils.isBlank((CharSequence)mobileNulls.toString())) {
                    ret.put("isMobileNull", false);
                } else {
                    ret.put("isMobileNull", true);
                    ret.put("mobileNulls", mobileNulls.toString());
                }
                if (StringUtils.isBlank((CharSequence)mobileErrors.toString())) {
                    ret.put("isMobileError", false);
                } else {
                    ret.put("isMobileError", true);
                    ret.put("mobileErrors", mobileErrors.toString());
                }
                if (StringUtils.isBlank((CharSequence)repeatMobiles.toString())) {
                    ret.put("isMobileRepeat", false);
                } else {
                    ret.put("isMobileRepeat", true);
                    ret.put("mobiles", repeatMobiles.toString());
                }
                return Y9Result.success(ret, (String)"\u4e0a\u4f20\u7ec4\u7ec7\u673a\u6784XLS\u6210\u529f");
            }
            LOGGER.info("################\u8bfb\u53d6XLS\u6587\u4ef6\u6570\u636e\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01##########################");
            ret.put("success", false);
            return Y9Result.failure((String)"\u8bfb\u53d6XLS\u6587\u4ef6\u6570\u636e\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            LOGGER.warn("\u5bfc\u5165XLS\u7ec4\u7ec7\u67b6\u6784\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return Y9Result.failure((String)("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage()));
        }
    }

    private Map<String, Object> impData2Db(PersonInformation pf, String orgId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("isRepeat", "false");
        retMap.put("isMobileRepeat", "false");
        retMap.put("isMobileNull", "false");
        retMap.put("isMobileError", "false");
        Object fullPath = StringUtils.isBlank((CharSequence)pf.getFullPath()) ? pf.getName() : pf.getFullPath() + SPLITTER + pf.getName();
        String[] paths = ((String)fullPath).split(SPLITTER);
        Y9OrgBase y9OrgBase = this.compositeOrgBaseService.getOrgUnit(orgId);
        Object dn = y9OrgBase.getDn();
        String parentId = y9OrgBase.getId();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                String personMobile;
                String personName = pf.getLoginName().replaceAll("\\s*", "");
                Optional<Y9Person> y9PersonOptional = this.y9PersonService.findByLoginName(personName);
                if (y9PersonOptional.isPresent()) {
                    retMap.put("isRepeat", "true");
                    retMap.put("name", pf.getLoginName().replaceAll("\\s*", ""));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)pf.getMobile())) {
                    retMap.put("isMobileNull", "true");
                    retMap.put("mobileNullNames", pf.getLoginName().replaceAll("\\s*", ""));
                    continue;
                }
                if (pf.getMobile().indexOf("E") > 0) {
                    BigDecimal mobileValue = new BigDecimal(pf.getMobile());
                    String mobile = mobileValue.toPlainString();
                    pf.setMobile(mobile);
                }
                if ((personMobile = pf.getMobile().replaceAll("\\s*", "")).length() != 11) {
                    retMap.put("isMobileError", "true");
                    retMap.put("mobileErrorNames", pf.getLoginName().replaceAll("\\s*", ""));
                    continue;
                }
                Y9Person y9Person = new Y9Person();
                y9Person.setName(paths[i].replaceAll("\\s*", ""));
                y9Person.setEmail(pf.getEmail());
                y9Person.setMobile(pf.getMobile().replaceAll("\\s*", ""));
                y9Person.setLoginName(pf.getLoginName().replaceAll("\\s*", ""));
                y9Person.setSex("\u7537".equals(pf.getSex()) ? SexEnum.MALE : SexEnum.FEMALE);
                y9Person.setParentId(parentId);
                String jobs = pf.getJobs();
                if (StringUtils.isNotBlank((CharSequence)jobs)) {
                    String[] jobArray = jobs.split(SPLITTER);
                    ArrayList<String> y9JobIdList = new ArrayList<String>();
                    for (String job : jobArray) {
                        y9JobIdList.add(this.y9JobService.create(job, job).getId());
                    }
                    this.y9PersonService.saveOrUpdate(y9Person, null, null, y9JobIdList);
                    continue;
                }
                this.y9PersonService.saveOrUpdate(y9Person, null);
                continue;
            }
            List<Y9Department> departmentList = this.y9DepartmentService.listByDn((String)(dn = "ou=" + paths[i] + SPLITTER + (String)dn), false);
            if (!departmentList.isEmpty()) {
                parentId = departmentList.get(0).getId();
                continue;
            }
            Y9Department department = new Y9Department();
            department.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            department.setTenantId(Y9LoginUserHolder.getTenantId());
            department.setName(paths[i].replaceAll("\\s*", ""));
            department.setOrgType(OrgTypeEnum.DEPARTMENT);
            department.setParentId(parentId);
            Y9Department dept = this.y9DepartmentService.saveOrUpdate(department);
            parentId = dept.getId();
        }
        return retMap;
    }

    private String reverseSplit(String path) {
        if (!path.contains(SPLITTER)) {
            return path;
        }
        String[] oldString = path.split(SPLITTER);
        StringBuilder strBuffer = new StringBuilder();
        for (int length = oldString.length; length > 0; --length) {
            strBuffer.append(oldString[length - 1]);
            strBuffer.append(SPLITTER);
        }
        String newString = strBuffer.toString();
        return newString.substring(0, newString.lastIndexOf(SPLITTER));
    }

    private Map<String, Object> xlsOrgTreeData(String organizationId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Y9Organization> organizationList = new ArrayList<Y9Organization>();
        Y9Organization y9Organization = this.y9OrganizationService.getById(organizationId);
        organizationList.add(y9Organization);
        ArrayList<ObjectSheet> departmentList = new ArrayList<ObjectSheet>();
        this.executeDepartment(y9Organization.getId(), departmentList);
        List<ObjectSheet> groupList = this.executeGroup(this.y9GroupService.listAll());
        List<ObjectSheet> positionList = this.executePosition(this.y9PositionService.listAll());
        map.put("organizationList", organizationList);
        map.put("departmentList", departmentList);
        map.put("groupList", groupList);
        map.put("positionList", positionList);
        ArrayList<String> listSheetNames = new ArrayList<String>();
        listSheetNames.add("\u7ec4\u7ec7\u673a\u6784");
        listSheetNames.add("\u90e8\u95e8");
        listSheetNames.add("\u4eba\u5458");
        listSheetNames.add("\u7528\u6237\u7ec4");
        listSheetNames.add("\u5c97\u4f4d");
        listSheetNames.add("\u89d2\u8272");
        map.put("sheetNames", listSheetNames);
        map.put("listSheetNames", listSheetNames);
        return map;
    }

    private Map<String, Object> xlsPersonData(String orgBaseId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Y9Person> persons = this.compositeOrgBaseService.listAllDescendantPersons(orgBaseId);
        ArrayList<PersonInformation> personList = new ArrayList<PersonInformation>();
        for (Y9Person person : persons) {
            PersonInformation personInformation = new PersonInformation();
            String fullPath = person.getDn().replace("cn=", "").replace(",ou=", SPLITTER).replace(",o=", SPLITTER);
            String path = fullPath.substring(0, fullPath.lastIndexOf(SPLITTER));
            if (path.contains(SPLITTER) && fullPath.lastIndexOf(SPLITTER) == fullPath.lastIndexOf(SPLITTER)) {
                path = path.substring(fullPath.indexOf(SPLITTER) + 1);
                personInformation.setFullPath(this.reverseSplit(path));
            } else if (!path.contains(SPLITTER)) {
                personInformation.setFullPath(null);
            } else {
                path = path.substring(fullPath.indexOf(SPLITTER) + 1, fullPath.lastIndexOf(SPLITTER));
                personInformation.setFullPath(this.reverseSplit(path));
            }
            personInformation.setName(fullPath.substring(0, fullPath.indexOf(SPLITTER)));
            personInformation.setEmail(person.getEmail());
            personInformation.setLoginName(person.getLoginName());
            personInformation.setMobile(person.getMobile());
            personInformation.setSex(SexEnum.FEMALE.equals((Object)person.getSex()) ? "\u5973" : "\u7537");
            List<Y9Job> y9JobList = this.y9JobService.findByPersonId(person.getId());
            personInformation.setJobs(y9JobList.stream().map(Y9Job::getName).collect(Collectors.joining(SPLITTER)));
            personList.add(personInformation);
        }
        map.put("personList", personList);
        return map;
    }

    @Generated
    public Y9OrgTreeExcelDataHandlerImpl(CompositeOrgBaseService compositeOrgBaseService, Y9DepartmentService y9DepartmentService, Y9PersonService y9PersonService, Y9OrganizationService y9OrganizationService, Y9PositionService y9PositionService, Y9GroupService y9GroupService, Y9JobService y9JobService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9DepartmentService = y9DepartmentService;
        this.y9PersonService = y9PersonService;
        this.y9OrganizationService = y9OrganizationService;
        this.y9PositionService = y9PositionService;
        this.y9GroupService = y9GroupService;
        this.y9JobService = y9JobService;
    }
}

