/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.PersonApi;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9PersonExt;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.identity.person.Y9PersonToRole;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.PersonExt;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Role;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.service.identity.Y9PersonToRoleService;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9PersonExtService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.entity.role.Y9Role;
import net.risesoft.y9public.service.Y9FileStoreService;
import net.risesoft.y9public.service.role.Y9RoleService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0PersonApiImpl")
@RequestMapping(value={"/services/rest/person"}, produces={"application/json"})
@Deprecated
public class PersonApiImpl
implements PersonApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonApiImpl.class);
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonExtService y9PersonExtService;
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9RoleService y9RoleService;
    private final Y9FileStoreService y9FileStoreService;
    private final Y9Properties y9conf;
    private final Y9PersonToRoleService y9PersonToRoleService;

    public boolean changeDisabled(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonService.changeDisabled(personId);
        return true;
    }

    public boolean checkLoginName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="loginName") @NotBlank String loginName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.y9PersonService.isLoginNameAvailable(personId, loginName);
    }

    public Person createPerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personJson") @NotBlank String personJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = (Y9Person)Y9JsonUtil.readValue((String)personJson, Y9Person.class);
        y9Person = this.y9PersonService.saveOrUpdate(y9Person, null);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public boolean deleteById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonService.delete(personId);
        return true;
    }

    public OrgUnit getBureau(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase bureau = this.compositeOrgBaseService.findOrgUnitBureau(personId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(bureau);
    }

    public Person getByLoginNameAndParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="loginName") @NotBlank String loginName, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person person = this.y9PersonService.getByLoginNameAndParentId(loginName, parentId).orElse(null);
        return (Person)Y9ModelConvertUtil.convert((Object)person, Person.class);
    }

    public OrgUnit getParent(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(personId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(parent);
    }

    public Person getPerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findById(personId).orElse(null);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public Person getPersonByLoginNameAndTenantId(@RequestParam(value="loginName") @NotBlank String loginName, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.findByLoginName(loginName).orElse(null);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public PersonExt getPersonExtByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9PersonExt y9PersonExt = this.y9PersonExtService.findByPersonId(personId).orElse(null);
        return (PersonExt)Y9ModelConvertUtil.convert((Object)y9PersonExt, PersonExt.class);
    }

    public String getPersonPhoto(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.y9PersonExtService.getEncodePhotoByPersonId(personId);
    }

    public List<Person> listAllPersons(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.list(false);
        Collections.sort(y9PersonList);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Person> listByIdTypeAndIdNum(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="idType") @NotBlank String idType, @RequestParam(value="idNum") @NotBlank String idNum) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByIdTypeAndIdNum(idType, idNum, false);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Person> listByNameLike(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(name="name", required=false) String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByNameLike(name, false);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Group> listGroups(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.y9GroupService.listByPersonId(personId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9GroupList, Group.class);
    }

    public List<OrgUnit> listParents(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> parentList = this.y9PersonService.listParents(personId);
        return ModelConvertUtil.orgBaseToOrgUnit(parentList);
    }

    public List<Map<String, Object>> listPersonInfoByNameLike(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(name="name", required=false) String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByNameLike(name, false);
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        if (!y9PersonList.isEmpty()) {
            for (Y9Person person : y9PersonList) {
                HashMap<String, Object> returnMap = new HashMap<String, Object>();
                person.setPassword(null);
                returnMap.put("person", person);
                returnMap.put("personExt", this.y9PersonExtService.findByPersonId(person.getId()));
                returnMap.put("avator", person.getAvator());
                returnMap.put("disabled", person.getDisabled());
                if (!Boolean.TRUE.equals(person.getDisabled())) {
                    List<Y9Position> positions = this.y9PositionService.listByPersonId(person.getId(), Boolean.FALSE);
                    if (!positions.isEmpty()) {
                        StringBuilder ids = new StringBuilder();
                        StringBuilder names = new StringBuilder();
                        for (Y9Position position : positions) {
                            ids.append(position.getId() + ",");
                            names.append(position.getName() + ",");
                        }
                        String nameString = names.toString();
                        String idsString = ids.toString();
                        returnMap.put("positionNames", nameString.substring(0, nameString.lastIndexOf(",")));
                        returnMap.put("positionIds", idsString.substring(0, idsString.lastIndexOf(",")));
                    } else {
                        returnMap.put("positionNames", "\u6682\u672a\u8bbe\u7f6e");
                    }
                }
                infoList.add(returnMap);
            }
        }
        return infoList;
    }

    public List<Position> listPositions(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByPersonId(personId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9PositionList, Position.class);
    }

    public List<Role> listRoles(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<Role> roleList = new ArrayList<Role>();
        List<Y9PersonToRole> y9PersonToRoleList = this.y9PersonToRoleService.listByPersonId(personId);
        for (Y9PersonToRole y9PersonToRole : y9PersonToRoleList) {
            Y9Role y9Role = this.y9RoleService.getById(y9PersonToRole.getRoleId());
            roleList.add(ModelConvertUtil.y9RoleToRole(y9Role));
        }
        return roleList;
    }

    public Person modifyPassword(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="newPassword") @NotBlank String newPassword) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.modifyPassword(personId, null, newPassword);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public Y9Page<Person> pageByNameLike(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(required=false) String name, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByNameLike(name, new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Y9Page<Person> pageByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="disabled") boolean disabled, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByParentId(parentId, disabled, new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Y9Page<Person> pageByParentIdAndUserName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="disabled") boolean disabled, @RequestParam(value="userName") @NotBlank String userName, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9Person> persons = this.y9PersonService.pageByParentId(parentId, disabled, userName, new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        List personList = Y9ModelConvertUtil.convert((List)persons.getContent(), Person.class);
        return Y9Page.success((int)persons.getNumber(), (int)persons.getTotalPages(), (long)persons.getTotalElements(), (List)personList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public Person savePerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personJson") @NotBlank String personJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = (Y9Person)Y9JsonUtil.readValue((String)personJson, Y9Person.class);
        Y9PersonExt y9PersonExt = (Y9PersonExt)Y9JsonUtil.readValue((String)personJson, Y9PersonExt.class);
        y9Person = this.y9PersonService.saveOrUpdate(y9Person, y9PersonExt);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public Person savePersonAvator(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="avator") @NotBlank String avator) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.saveAvator(personId, avator);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public Person savePersonAvatorByBase64(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="picnote") @NotBlank String picnote, @RequestParam(value="fileExt") String fileExt) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.getById(personId);
        try {
            if (StringUtils.isNotBlank((CharSequence)picnote)) {
                Base64 base64 = new Base64();
                if (picnote.contains("base64,")) {
                    picnote = picnote.split("base64,")[1];
                }
                byte[] data = base64.decode(picnote);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String fullPath = Y9FileStore.buildPath((String[])new String[]{Y9Context.getSystemName(), "avator"});
                String fileNewName = y9Person.getLoginName() + "_" + sdf.format(new Date()) + "." + (StringUtils.isBlank((CharSequence)fileExt) ? "png" : fileExt);
                LOGGER.debug("******savePersonAvatorByBase64:{}", (Object)fileNewName);
                Y9FileStore y9FileStore = this.y9FileStoreService.uploadFile(data, fullPath, fileNewName);
                String url = this.y9conf.getCommon().getOrgBaseUrl() + "/s/" + y9FileStore.getId() + "." + y9FileStore.getFileExt();
                y9Person = this.y9PersonService.saveAvator(personId, url);
                return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Boolean savePersonPhoto(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="photo") @NotBlank String photo) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonExtService.savePersonPhoto(personId, photo);
        return true;
    }

    public Person savePersonWithExt(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personJson") @NotBlank String personJson, @RequestParam(value="personextJson") @NotBlank String personextJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = (Y9Person)Y9JsonUtil.readValue((String)personJson, Y9Person.class);
        Y9PersonExt y9PersonExt = (Y9PersonExt)Y9JsonUtil.readValue((String)personextJson, Y9PersonExt.class);
        y9Person = this.y9PersonService.saveOrUpdate(y9Person, y9PersonExt);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    public Person saveWeixinId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="weixinId") @NotBlank String weixinId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Person y9Person = this.y9PersonService.saveWeixinId(personId, weixinId);
        return (Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class);
    }

    @Generated
    public PersonApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9GroupService y9GroupService, Y9PersonExtService y9PersonExtService, Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9RoleService y9RoleService, Y9FileStoreService y9FileStoreService, Y9Properties y9conf, Y9PersonToRoleService y9PersonToRoleService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9GroupService = y9GroupService;
        this.y9PersonExtService = y9PersonExtService;
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.y9RoleService = y9RoleService;
        this.y9FileStoreService = y9FileStoreService;
        this.y9conf = y9conf;
        this.y9PersonToRoleService = y9PersonToRoleService;
    }
}

