/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.OrganizationApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0OrganizationApiImpl")
@RequestMapping(value={"/services/rest/organization"}, produces={"application/json"})
@Deprecated
public class OrganizationApiImpl
implements OrganizationApi {
    private final Y9DepartmentService y9DepartmentService;
    private final Y9GroupService orgGroupService;
    private final Y9OrganizationService orgOrganizationService;
    private final Y9PersonService orgPersonService;
    private final Y9PositionService orgPositionService;

    public Organization getOrganization(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Organization y9Organization = this.orgOrganizationService.findById(organizationId).orElse(null);
        return (Organization)Y9ModelConvertUtil.convert((Object)y9Organization, Organization.class);
    }

    public List<Department> listAllBureaus(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listBureau(organizationId, false);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public List<Organization> listAllOrganizations(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Organization> y9OrganizationList = this.orgOrganizationService.list(false, false);
        return Y9ModelConvertUtil.convert(y9OrganizationList, Organization.class);
    }

    public List<Organization> listByType(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="virtual") Boolean virtual) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Organization> y9OrganizationList = this.orgOrganizationService.list(virtual, false);
        return Y9ModelConvertUtil.convert(y9OrganizationList, Organization.class);
    }

    public List<Department> listDepartments(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByParentId(organizationId, false);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public List<Group> listGroups(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.orgGroupService.listByParentId(organizationId, false);
        return Y9ModelConvertUtil.convert(y9GroupList, Group.class);
    }

    public List<Person> listPersons(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.orgPersonService.listByParentId(organizationId, false);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Position> listPositions(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.orgPositionService.listByParentId(organizationId, false);
        return Y9ModelConvertUtil.convert(y9PositionList, Position.class);
    }

    @Generated
    public OrganizationApiImpl(Y9DepartmentService y9DepartmentService, Y9GroupService orgGroupService, Y9OrganizationService orgOrganizationService, Y9PersonService orgPersonService, Y9PositionService orgPositionService) {
        this.y9DepartmentService = y9DepartmentService;
        this.orgGroupService = orgGroupService;
        this.orgOrganizationService = orgOrganizationService;
        this.orgPersonService = orgPersonService;
        this.orgPositionService = orgPositionService;
    }
}

