/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.DepartmentApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9DepartmentProp;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.enums.platform.DepartmentPropCategoryEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.DepartmentProp;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentPropService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0DepartmentApiImpl")
@RequestMapping(value={"/services/rest/department"}, produces={"application/json"})
@Deprecated
public class DepartmentApiImpl
implements DepartmentApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9DepartmentService y9DepartmentService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9DepartmentPropService y9DepartmentPropService;

    public Department createDepartment(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentJson") @NotBlank String departmentJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Department y9Department = (Y9Department)Y9JsonUtil.readValue((String)departmentJson, Y9Department.class);
        y9Department = this.y9DepartmentService.saveOrUpdate(y9Department);
        return (Department)Y9ModelConvertUtil.convert((Object)y9Department, Department.class);
    }

    public boolean deleteDepartment(@RequestParam(value="deptId") @NotBlank String deptId, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9DepartmentService.delete(deptId);
        return true;
    }

    public boolean disableDepartment(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9DepartmentService.changeDisable(departmentId);
        return true;
    }

    public OrgUnit getBureau(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase bureau = this.compositeOrgBaseService.findOrgUnitBureau(departmentId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(bureau);
    }

    public Department getDepartment(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Department y9Department = this.y9DepartmentService.findById(departmentId).orElse(null);
        return (Department)Y9ModelConvertUtil.convert((Object)y9Department, Department.class);
    }

    public OrgUnit getParent(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(departmentId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(parent);
    }

    public List<Person> listAllPersons(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.compositeOrgBaseService.listAllDescendantPersons(departmentId);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Person> listAllPersonsByDisabled(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId, @RequestParam(value="disabled") Boolean disabled) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.compositeOrgBaseService.listAllDescendantPersons(departmentId, disabled);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Person> listAllPersonsByDisabledAndName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId, @RequestParam(value="disabled") Boolean disabled, @RequestParam(value="name") @NotBlank String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.compositeOrgBaseService.searchAllPersonsRecursionDownward(departmentId, name, disabled);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Department> listByDn(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="dn") @NotBlank String dn) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByDn(dn, false);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public List<DepartmentProp> listByOrgBaseIdAndCategory(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId, @RequestParam(value="category") Integer category) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9DepartmentProp> y9DepartmentPropList = this.y9DepartmentPropService.listByOrgBaseIdAndCategory(orgUnitId, (DepartmentPropCategoryEnum)Y9EnumUtil.valueOf(DepartmentPropCategoryEnum.class, (Object)category));
        return Y9ModelConvertUtil.convert(y9DepartmentPropList, DepartmentProp.class);
    }

    public List<Department> listByTenantIdAndDeptName(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="deptName") @NotBlank String deptName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByNameLike(deptName, false);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public List<Department> listDepartments(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="ids") @NotEmpty List<String> ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.list(ids);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public List<Group> listGroups(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.y9GroupService.listByParentId(departmentId, false);
        return Y9ModelConvertUtil.convert(y9GroupList, Group.class);
    }

    public List<OrgUnit> listLeaders(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.y9DepartmentService.listDepartmentPropOrgUnits(departmentId, DepartmentPropCategoryEnum.LEADER.getValue(), Boolean.FALSE);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    public List<OrgUnit> listManagers(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.y9DepartmentService.listDepartmentPropOrgUnits(departmentId, DepartmentPropCategoryEnum.MANAGER.getValue(), Boolean.FALSE);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    public List<Person> listPersons(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByParentId(departmentId, false);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Person> listPersonsByDisabled(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId, @RequestParam(value="disabled") Boolean disabled) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByParentId(departmentId, disabled);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<Position> listPositions(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByParentId(departmentId, false);
        return Y9ModelConvertUtil.convert(y9PositionList, Position.class);
    }

    public List<Department> listSubDepartments(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentId") @NotBlank String departmentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByParentId(departmentId, false);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public Department saveDepartment(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="departmentJson") @NotBlank String departmentJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Department y9Department = (Y9Department)Y9JsonUtil.readValue((String)departmentJson, Y9Department.class);
        y9Department = this.y9DepartmentService.saveOrUpdate(y9Department);
        return (Department)Y9ModelConvertUtil.convert((Object)y9Department, Department.class);
    }

    @Generated
    public DepartmentApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9DepartmentService y9DepartmentService, Y9GroupService y9GroupService, Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9DepartmentPropService y9DepartmentPropService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9DepartmentService = y9DepartmentService;
        this.y9GroupService = y9GroupService;
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.y9DepartmentPropService = y9DepartmentPropService;
    }
}

