/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.customgroup;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import net.risesoft.api.platform.v0.customgroup.CustomGroupApi;
import net.risesoft.entity.Y9CustomGroup;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.relation.Y9CustomGroupMember;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.CustomGroup;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.service.org.Y9CustomGroupService;
import net.risesoft.service.relation.Y9CustomGroupMembersService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0CustomGroupApiImpl")
@RequestMapping(value={"/services/rest/customGroup"}, produces={"application/json"})
@Deprecated
public class CustomGroupApiImpl
implements CustomGroupApi {
    private final Y9CustomGroupMembersService customGroupMembersService;
    private final Y9CustomGroupService customGroupService;

    public void addMember(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="customGroupId") @NotBlank String customGroupId, @RequestParam(value="orgUnitList") @NotEmpty List<String> orgUnitList) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customGroupMembersService.save(orgUnitList, customGroupId);
    }

    public boolean deleteAllGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupIds") @NotEmpty List<String> groupIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customGroupService.delete(groupIds);
        return true;
    }

    public CustomGroup findCustomGroupByCustomId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="customId") @NotBlank String customId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9CustomGroup y9CustomGroup = this.customGroupService.findByCustomId(customId).orElse(null);
        return (CustomGroup)Y9ModelConvertUtil.convert((Object)y9CustomGroup, CustomGroup.class);
    }

    public CustomGroup findCustomGroupById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9CustomGroup customGroup = this.customGroupService.findById(groupId).orElse(null);
        return (CustomGroup)Y9ModelConvertUtil.convert((Object)customGroup, CustomGroup.class);
    }

    public List<Person> listAllPersonByGroupId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.customGroupMembersService.listAllPersonsByGroupId(groupId);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public List<CustomGroup> listCustomGroupByUserId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9CustomGroup> y9CustomGroupList = this.customGroupService.listByPersonId(personId);
        return Y9ModelConvertUtil.convert(y9CustomGroupList, CustomGroup.class);
    }

    public List<CustomGroupMember> listCustomGroupMemberByGroupId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9CustomGroupMember> y9CustomGroupMemberList = this.customGroupMembersService.listByGroupId(groupId);
        return Y9ModelConvertUtil.convert(y9CustomGroupMemberList, CustomGroupMember.class);
    }

    public List<CustomGroupMember> listCustomGroupMemberByGroupIdAndMemberType(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") String personId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="memberType") @NotBlank String memberType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9CustomGroupMember> y9CustomGroupMemberList = this.customGroupMembersService.listByGroupIdAndMemberType(groupId, (OrgTypeEnum)Y9EnumUtil.valueOf(OrgTypeEnum.class, (Object)memberType));
        return Y9ModelConvertUtil.convert(y9CustomGroupMemberList, CustomGroupMember.class);
    }

    public Y9Page<CustomGroup> pageCustomGroupByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9CustomGroup> y9CustomGroupPage = this.customGroupService.pageByPersonId(personId, new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        return Y9Page.success((int)page, (int)y9CustomGroupPage.getTotalPages(), (long)y9CustomGroupPage.getTotalElements(), (List)Y9ModelConvertUtil.convert((List)y9CustomGroupPage.getContent(), CustomGroup.class));
    }

    public Y9Page<CustomGroupMember> pageCustomGroupMemberByGroupId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9CustomGroupMember> y9CustomGroupMemberPage = this.customGroupMembersService.pageByGroupId(groupId, new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        return Y9Page.success((int)page, (int)y9CustomGroupMemberPage.getTotalPages(), (long)y9CustomGroupMemberPage.getTotalElements(), (List)Y9ModelConvertUtil.convert((List)y9CustomGroupMemberPage.getContent(), CustomGroupMember.class));
    }

    public Y9Page<CustomGroupMember> pageCustomGroupMemberByGroupIdAndMemberType(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="memberType") @NotBlank String memberType, @RequestParam(value="page") int page, @RequestParam(value="rows") int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Page<Y9CustomGroupMember> y9CustomGroupMemberPage = this.customGroupMembersService.pageByGroupIdAndMemberType(groupId, (OrgTypeEnum)Y9EnumUtil.valueOf(OrgTypeEnum.class, (Object)memberType), new Y9PageQuery(Integer.valueOf(page), Integer.valueOf(rows)));
        return Y9Page.success((int)page, (int)y9CustomGroupMemberPage.getTotalPages(), (long)y9CustomGroupMemberPage.getTotalElements(), (List)Y9ModelConvertUtil.convert((List)y9CustomGroupMemberPage.getContent(), CustomGroupMember.class));
    }

    public boolean removeMembers(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="memberIds") @NotEmpty List<String> memberIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customGroupMembersService.delete(memberIds);
        return true;
    }

    public CustomGroup saveCustomGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, CustomGroup customGroup) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9CustomGroup y9CustomGroup = new Y9CustomGroup();
        Y9BeanUtil.copyProperties((Object)customGroup, (Object)y9CustomGroup);
        return (CustomGroup)Y9ModelConvertUtil.convert((Object)this.customGroupService.save(y9CustomGroup), CustomGroup.class);
    }

    public boolean saveCustomGroupOrder(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="sortIds") @NotEmpty List<String> sortIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.customGroupService.saveCustomGroupOrder(sortIds);
    }

    public boolean saveMemberOrder(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="memberIds") @NotEmpty List<String> memberIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.customGroupMembersService.saveOrder(memberIds);
    }

    public CustomGroup saveOrUpdateCustomGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="personIds") @NotEmpty List<String> personIds, @RequestParam(value="groupId") String groupId, @RequestParam(value="groupName") @NotBlank String groupName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9CustomGroup customGroup = this.customGroupService.saveOrUpdate(personId, personIds, groupId, groupName);
        return (CustomGroup)Y9ModelConvertUtil.convert((Object)customGroup, CustomGroup.class);
    }

    public boolean shareCustomGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personIds") @NotEmpty List<String> personIds, @RequestParam(value="groupIds") @NotEmpty List<String> groupIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.customGroupService.share(personIds, groupIds);
    }

    @Generated
    public CustomGroupApiImpl(Y9CustomGroupMembersService customGroupMembersService, Y9CustomGroupService customGroupService) {
        this.customGroupMembersService = customGroupMembersService;
        this.customGroupService = customGroupService;
    }
}

