/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.tenant;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.tenant.TenantApi;
import net.risesoft.enums.platform.TenantTypeEnum;
import net.risesoft.model.platform.Tenant;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.tenant.Y9Tenant;
import net.risesoft.y9public.service.tenant.Y9TenantService;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/tenant"}, produces={"application/json"})
public class TenantApiImpl
implements TenantApi {
    private final Y9TenantService y9TenantService;

    public Y9Result<Tenant> findByName(@RequestParam(value="tenantName") @NotBlank String tenantName) {
        Y9Tenant y9Tenant = this.y9TenantService.findByTenantName(tenantName).orElse(null);
        return Y9Result.success((Object)((Tenant)Y9ModelConvertUtil.convert((Object)y9Tenant, Tenant.class)));
    }

    public Y9Result<Tenant> findByShortName(@RequestParam(value="shortName") @NotBlank String shortName) {
        Y9Tenant y9Tenant = this.y9TenantService.findByShortName(shortName).orElse(null);
        return Y9Result.success((Object)((Tenant)Y9ModelConvertUtil.convert((Object)y9Tenant, Tenant.class)));
    }

    public Y9Result<Tenant> getById(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9Tenant y9Tenant = this.y9TenantService.getById(tenantId);
        return Y9Result.success((Object)((Tenant)Y9ModelConvertUtil.convert((Object)y9Tenant, Tenant.class)));
    }

    public Y9Result<List<Tenant>> listAllTenants() {
        List<Y9Tenant> tenantEntityList = this.y9TenantService.listAll();
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(tenantEntityList, Tenant.class));
    }

    public Y9Result<List<Tenant>> listByTenantType(@RequestParam(value="tenantType") TenantTypeEnum tenantType) {
        List<Y9Tenant> y9TenantList = this.y9TenantService.listByTenantType(tenantType);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9TenantList, Tenant.class));
    }

    @Generated
    public TenantApiImpl(Y9TenantService y9TenantService) {
        this.y9TenantService = y9TenantService;
    }
}

