/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.resource;

import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.resource.ResourceApi;
import net.risesoft.enums.platform.ResourceTypeEnum;
import net.risesoft.model.platform.Resource;
import net.risesoft.pojo.Y9Result;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9Menu;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import net.risesoft.y9public.service.resource.CompositeResourceService;
import net.risesoft.y9public.service.resource.Y9MenuService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/resource"}, produces={"application/json"})
public class ResourceApiImpl
implements ResourceApi {
    private final CompositeResourceService compositeResourceService;
    private final Y9MenuService y9MenuService;

    public Y9Result<Resource> createMenuResource(@RequestParam(value="resourceId") @NotBlank String resourceId, @RequestParam(value="resourceName") @NotBlank String resourceName, @RequestParam(value="parentResourceId") @NotBlank String parentResourceId, @RequestParam(value="customId") @NotBlank String customId) {
        Y9Menu y9Menu;
        Y9ResourceBase parentResource = this.compositeResourceService.findById(parentResourceId);
        Optional y9MenuOptional = this.y9MenuService.findById(resourceId);
        if (y9MenuOptional.isEmpty()) {
            y9Menu = new Y9Menu();
            y9Menu.setId(resourceId);
        } else {
            y9Menu = (Y9Menu)y9MenuOptional.get();
        }
        if (parentResource != null) {
            y9Menu.setAppId(parentResource.getAppId());
            y9Menu.setSystemId(parentResource.getSystemId());
            y9Menu.setParentId(parentResourceId);
        }
        y9Menu.setName(resourceName);
        y9Menu.setInherit(Boolean.FALSE);
        y9Menu.setHidden(Boolean.FALSE);
        y9Menu.setEnabled(Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)customId)) {
            y9Menu.setCustomId(customId);
        }
        y9Menu = this.y9MenuService.saveOrUpdate(y9Menu);
        return Y9Result.success((Object)ModelConvertUtil.resourceBaseToResource((Y9ResourceBase)y9Menu));
    }

    public Y9Result<Resource> findByCustomIdAndParentId(@RequestParam(value="customId") @NotBlank String customId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="resourceType") ResourceTypeEnum resourceType) {
        Y9ResourceBase y9ResourceBase = this.compositeResourceService.findByCustomIdAndParentId(customId, parentId, resourceType).orElse(null);
        return Y9Result.success((Object)ModelConvertUtil.resourceBaseToResource(y9ResourceBase));
    }

    public Y9Result<Resource> getParentResource(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9ResourceBase y9ResourceBase = this.compositeResourceService.findById(resourceId);
        Y9ResourceBase parent = this.compositeResourceService.findById(y9ResourceBase.getParentId());
        return Y9Result.success((Object)ModelConvertUtil.resourceBaseToResource(parent));
    }

    public Y9Result<Resource> getResource(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9ResourceBase y9ResourceBase = this.compositeResourceService.findById(resourceId);
        return Y9Result.success((Object)ModelConvertUtil.resourceBaseToResource(y9ResourceBase));
    }

    public Y9Result<List<Resource>> listSubMenus(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        List<Y9Menu> y9MenuList = this.y9MenuService.findByParentId(resourceId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9MenuList, Resource.class));
    }

    public Y9Result<List<Resource>> listSubResources(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        List<Y9ResourceBase> y9ResourceBaseList = this.compositeResourceService.listRootResourceBySystemId(resourceId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9ResourceBaseList, Resource.class));
    }

    @Generated
    public ResourceApiImpl(CompositeResourceService compositeResourceService, Y9MenuService y9MenuService) {
        this.compositeResourceService = compositeResourceService;
        this.y9MenuService = y9MenuService;
    }
}

