/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.resource;

import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.resource.AppApi;
import net.risesoft.enums.platform.AppOpenTypeEnum;
import net.risesoft.enums.platform.AppTypeEnum;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.ManagerLevelEnum;
import net.risesoft.model.platform.App;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.identity.Y9PersonToResourceAndAuthorityService;
import net.risesoft.service.identity.Y9PositionToResourceAndAuthorityService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9App;
import net.risesoft.y9public.entity.resource.Y9System;
import net.risesoft.y9public.service.resource.Y9AppService;
import net.risesoft.y9public.service.resource.Y9SystemService;
import net.risesoft.y9public.service.tenant.Y9TenantAppService;
import net.risesoft.y9public.service.tenant.Y9TenantSystemService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/app"}, produces={"application/json"})
public class AppApiImpl
implements AppApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AppApiImpl.class);
    private final Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService;
    private final Y9PositionToResourceAndAuthorityService y9PositionToResourceAndAuthorityService;
    private final Y9AppService y9AppService;
    private final Y9SystemService y9SystemService;
    private final Y9TenantSystemService y9TenantSystemService;
    private final Y9TenantAppService y9TenantAppService;

    public Y9Result<App> findById(@RequestParam(value="appId") @NotBlank String appId) {
        Y9App y9App = this.y9AppService.findById(appId).orElse(null);
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)y9App, App.class)));
    }

    public Y9Result<App> findBySystemIdAndCustomId(@RequestParam(value="systemId") @NotBlank String systemId, @RequestParam(value="customId") @NotBlank String customId) {
        Y9App y9App = this.y9AppService.findBySystemIdAndCustomId(systemId, customId).orElse(null);
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)y9App, App.class)));
    }

    public Y9Result<App> findBySystemNameAndCustomId(@RequestParam(value="systemName") @NotBlank String systemName, @RequestParam(value="customId") @NotBlank String customId) {
        Y9App y9App = this.y9AppService.findBySystemNameAndCustomId(systemName, customId).orElse(null);
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)y9App, App.class)));
    }

    public Y9Result<List<App>> listAccessAppForPerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9App> appList = this.y9PersonToResourceAndAuthorityService.listAppsByAuthority(personId, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(appList, App.class));
    }

    public Y9Result<List<App>> listAccessAppForPosition(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9App> appList = this.y9PositionToResourceAndAuthorityService.listAppsByAuthority(positionId, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(appList, App.class));
    }

    public Y9Result<List<App>> listByCustomId(@RequestParam(value="customId") @NotBlank String customId) {
        List<Y9App> y9AppList = this.y9AppService.listByCustomId(customId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9AppList, App.class));
    }

    public Y9Result<List<App>> listBySystemId(@RequestParam(value="systemId") @NotBlank String systemId) {
        List<Y9App> y9AppList = this.y9AppService.listBySystemId(systemId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9AppList, App.class));
    }

    public Y9Result<List<App>> listBySystemName(@RequestParam(value="systemName") @NotBlank String systemName) {
        List<Y9App> y9AppList = this.y9AppService.listBySystemName(systemName);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9AppList, App.class));
    }

    public Y9Result<App> registerApp(@RequestParam(value="systemName") @NotBlank String systemName, @RequestParam(value="name") @NotBlank String name, @RequestParam(value="url") @NotBlank String url, @RequestParam(value="customId") String customId, @RequestParam(value="tenantGuid") String tenantGuid) {
        Optional<Y9System> y9SystemOptional = this.y9SystemService.findByName(systemName);
        if (y9SystemOptional.isEmpty()) {
            return Y9Result.failure((String)"\u8be5\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (StringUtils.isBlank((CharSequence)tenantGuid)) {
            tenantGuid = "11111111-1111-1111-1111-111111111113";
        }
        Y9LoginUserHolder.setTenantId((String)tenantGuid);
        String systemId = y9SystemOptional.get().getId();
        Y9App saveIsvApp = null;
        String appId = null;
        String msg = "\u6ce8\u518c\u5e94\u7528\u6210\u529f\uff01";
        try {
            LOGGER.info("\u521b\u5efa\u5e94\u7528");
            Y9App y9App = new Y9App();
            y9App.setName(name);
            y9App.setSystemId(systemId);
            y9App.setUrl(url);
            y9App.setEnabled(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((CharSequence)customId)) {
                y9App.setCustomId(customId);
            }
            y9App.setShowNumber(Boolean.valueOf(false));
            y9App.setOpentype(AppOpenTypeEnum.DESKTOP);
            y9App.setType(AppTypeEnum.BUSINESS_COLLABORATION);
            saveIsvApp = this.y9AppService.saveIsvApp(y9App);
            appId = saveIsvApp.getId();
            this.y9AppService.verifyApp(appId, true, ManagerLevelEnum.SYSTEM_MANAGER.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (appId != null) {
                this.y9AppService.delete(appId);
            }
            return Y9Result.failure((String)("\u521b\u5efa\u5931\u8d25\uff01\u539f\u56e0\u4e3a\uff1a" + e.getMessage()));
        }
        try {
            LOGGER.info("\u79df\u7528\u7cfb\u7edf");
            this.y9TenantSystemService.saveTenantSystem(systemId, tenantGuid);
            this.y9TenantAppService.save(appId, tenantGuid, "\u7cfb\u7edf\u9ed8\u8ba4\u79df\u7528");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("\u7cfb\u7edf\u3001\u5e94\u7528\u5df2\u521b\u5efa\u6210\u529f\uff01\u4f46\u81ea\u52a8\u5e94\u7528\u79df\u7528\u5931\u8d25\uff0c\u8bf7\u6536\u5230\u8fdb\u884c\u79df\u7528\uff01");
            msg = "\u7cfb\u7edf\u3001\u5e94\u7528\u5df2\u521b\u5efa\u6210\u529f\uff01\u4f46\u81ea\u52a8\u5e94\u7528\u79df\u7528\u5931\u8d25\uff0c\u8bf7\u6536\u5230\u8fdb\u884c\u79df\u7528\uff01";
        }
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)saveIsvApp, App.class)), (String)msg);
    }

    public Y9Result<App> registerSystemAndApp(@RequestParam(value="systemName") @NotBlank String systemName, @RequestParam(value="systemCnName") @NotBlank String systemCnName, @RequestParam(value="isvGuid") String isvGuid, @RequestParam(value="contextPath") String contextPath, @RequestParam(value="appName") @NotBlank String appName, @RequestParam(value="url") @NotBlank String url, @RequestParam(value="customId") String customId) {
        List<Y9System> y9Systems = this.y9SystemService.listByContextPath(contextPath);
        if (!y9Systems.isEmpty()) {
            return Y9Result.failure((String)"\u8be5\u7cfb\u7edf\u4e0a\u4e0b\u6587\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        Optional<Y9System> y9SystemOptional = this.y9SystemService.findByName(systemName);
        if (y9SystemOptional.isPresent()) {
            return Y9Result.failure((String)"\u8be5\u7cfb\u7edf\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (StringUtils.isBlank((CharSequence)isvGuid)) {
            isvGuid = "11111111-1111-1111-1111-111111111113";
        }
        Y9LoginUserHolder.setTenantId((String)isvGuid);
        String systemId = null;
        String msg = "\u521b\u5efa\u6210\u529f!";
        try {
            Y9System y9System = new Y9System();
            y9System.setIsvGuid(isvGuid);
            y9System.setName(systemName);
            y9System.setCnName(systemCnName);
            y9System.setContextPath(contextPath);
            Y9System system = this.y9SystemService.saveOrUpdate(y9System);
            systemId = system.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Y9Result.failure((String)"\u521b\u5efa\u7cfb\u7edf\u5931\u8d25\uff01");
        }
        try {
            this.y9TenantSystemService.saveTenantSystem(systemId, isvGuid);
        }
        catch (Exception e) {
            this.y9SystemService.delete(systemId);
            e.printStackTrace();
            return Y9Result.failure((String)"\u79df\u7528\u7cfb\u7edf\u5931\u8d25\uff01");
        }
        String appId = null;
        Y9App saveIsvApp = null;
        try {
            Y9App y9App = new Y9App();
            y9App.setName(appName);
            y9App.setSystemId(systemId);
            y9App.setUrl(url);
            y9App.setEnabled(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((CharSequence)customId)) {
                y9App.setCustomId(customId);
            }
            y9App.setShowNumber(Boolean.valueOf(false));
            y9App.setType(AppTypeEnum.BUSINESS_COLLABORATION);
            saveIsvApp = this.y9AppService.saveIsvApp(y9App);
            appId = saveIsvApp.getId();
            this.y9AppService.verifyApp(appId, true, ManagerLevelEnum.SYSTEM_MANAGER.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.y9TenantSystemService.deleteByTenantIdAndSystemId(isvGuid, systemId);
            this.y9SystemService.delete(systemId);
            if (appId != null) {
                this.y9AppService.delete(appId);
            }
            return Y9Result.failure((String)"\u7cfb\u7edf\u521b\u5efa\u6210\u529f\uff0c\u4f46\u5e94\u7528\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        try {
            this.y9TenantAppService.save(appId, isvGuid, "\u5f00\u53d1\u4f7f\u7528");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg = "\u7cfb\u7edf\u3001\u5e94\u7528\u5df2\u521b\u5efa\u6210\u529f\uff01\u4f46\u81ea\u52a8\u5e94\u7528\u79df\u7528\u5931\u8d25\uff0c\u8bf7\u6536\u5230\u8fdb\u884c\u79df\u7528";
        }
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)saveIsvApp, App.class)), (String)msg);
    }

    public Y9Result<App> saveIsvApp(@RequestBody App app) {
        Y9App y9App = new Y9App();
        Y9BeanUtil.copyProperties((Object)app, (Object)y9App);
        y9App = this.y9AppService.saveIsvApp(y9App);
        return Y9Result.success((Object)((App)Y9ModelConvertUtil.convert((Object)y9App, App.class)));
    }

    @Generated
    public AppApiImpl(Y9PersonToResourceAndAuthorityService y9PersonToResourceAndAuthorityService, Y9PositionToResourceAndAuthorityService y9PositionToResourceAndAuthorityService, Y9AppService y9AppService, Y9SystemService y9SystemService, Y9TenantSystemService y9TenantSystemService, Y9TenantAppService y9TenantAppService) {
        this.y9PersonToResourceAndAuthorityService = y9PersonToResourceAndAuthorityService;
        this.y9PositionToResourceAndAuthorityService = y9PositionToResourceAndAuthorityService;
        this.y9AppService = y9AppService;
        this.y9SystemService = y9SystemService;
        this.y9TenantSystemService = y9TenantSystemService;
        this.y9TenantAppService = y9TenantAppService;
    }
}

