/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.permission;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.permission.PositionResourceApi;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.ResourceTypeEnum;
import net.risesoft.model.platform.Resource;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.identity.Y9PositionToResourceAndAuthorityService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9Menu;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/positionResource"}, produces={"application/json"})
public class PositionResourceApiImpl
implements PositionResourceApi {
    private final Y9PositionToResourceAndAuthorityService y9PositionToResourceAndAuthorityService;

    public Y9Result<Boolean> hasPermission(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="resourceId") @NotBlank String resourceId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PositionToResourceAndAuthorityService.hasPermission(positionId, resourceId, authority));
    }

    public Y9Result<Boolean> hasPermissionByCustomId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="customId") @NotBlank String customId, @RequestParam(value="authority") AuthorityEnum authority) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PositionToResourceAndAuthorityService.hasPermissionByCustomId(positionId, customId, authority));
    }

    public Y9Result<List<Resource>> listSubMenus(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="authority") AuthorityEnum authority, @RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Menu> y9MenuList = this.y9PositionToResourceAndAuthorityService.listSubMenus(positionId, resourceId, ResourceTypeEnum.MENU, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9MenuList, Resource.class));
    }

    public Y9Result<List<Resource>> listSubResources(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="authority") AuthorityEnum authority, @RequestParam(name="resourceId", required=false) String resourceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9ResourceBase> returnResourceList = this.y9PositionToResourceAndAuthorityService.listSubResources(positionId, resourceId, authority);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(returnResourceList, Resource.class));
    }

    @Generated
    public PositionResourceApiImpl(Y9PositionToResourceAndAuthorityService y9PositionToResourceAndAuthorityService) {
        this.y9PositionToResourceAndAuthorityService = y9PositionToResourceAndAuthorityService;
    }
}

