/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.platform.org.dto.CreatePositionDTO;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.service.relation.Y9PersonsToPositionsService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/position"}, produces={"application/json"})
public class PositionApiImpl
implements PositionApi {
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9PersonsToPositionsService orgPositionsPersonsService;

    public Y9Result<Object> addPerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.orgPositionsPersonsService.addPersons(positionId, new String[]{personId});
        return Y9Result.success();
    }

    public Y9Result<Position> create(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestBody @Validated CreatePositionDTO position) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = (Y9Position)Y9ModelConvertUtil.convert((Object)position, Y9Position.class);
        y9Position = this.y9PositionService.saveOrUpdate(y9Position);
        return Y9Result.success((Object)((Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class)));
    }

    public Y9Result<Object> delete(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PositionService.deleteById(positionId);
        return Y9Result.success();
    }

    public Y9Result<Position> get(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = this.y9PositionService.findById(positionId).orElse(null);
        return Y9Result.success((Object)((Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class)));
    }

    public Y9Result<Boolean> hasPosition(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionName") @NotBlank String positionName, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.y9PositionService.hasPosition(positionName, personId));
    }

    public Y9Result<List<Position>> listByParentId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByParentId(parentId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PositionList, Position.class));
    }

    public Y9Result<List<Position>> listByPersonId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByPersonId(personId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PositionList, Position.class));
    }

    public Y9Result<List<Person>> listPersonsByPositionId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByPositionId(positionId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9PersonList, Person.class));
    }

    public Y9Result<Object> removePerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="positionId") @NotBlank String positionId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.orgPositionsPersonsService.deletePersons(positionId, new String[]{personId});
        return Y9Result.success();
    }

    public Y9Result<Position> updatePosition(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestBody @Validated CreatePositionDTO createPositionDTO) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = (Y9Position)Y9ModelConvertUtil.convert((Object)createPositionDTO, Y9Position.class);
        y9Position = this.y9PositionService.saveOrUpdate(y9Position);
        return Y9Result.success((Object)((Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class)));
    }

    @Generated
    public PositionApiImpl(Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9PersonsToPositionsService orgPositionsPersonsService) {
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.orgPositionsPersonsService = orgPositionsPersonsService;
    }
}

