/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Organization;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Organization;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/organization"}, produces={"application/json"})
public class OrganizationApiImpl
implements OrganizationApi {
    private final Y9DepartmentService y9DepartmentService;
    private final Y9OrganizationService orgOrganizationService;

    public Y9Result<Organization> get(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Organization y9Organization = this.orgOrganizationService.findById(organizationId).orElse(null);
        return Y9Result.success((Object)((Organization)Y9ModelConvertUtil.convert((Object)y9Organization, Organization.class)));
    }

    public Y9Result<List<Organization>> list(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Organization> y9OrganizationList = this.orgOrganizationService.list(Boolean.FALSE, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9OrganizationList, Organization.class));
    }

    public Y9Result<List<Department>> listAllBureaus(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listBureau(organizationId, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9DepartmentList, Department.class));
    }

    public Y9Result<List<Organization>> listByType(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="virtual") Boolean virtual) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Organization> y9OrganizationList = this.orgOrganizationService.list(virtual, Boolean.FALSE);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9OrganizationList, Organization.class));
    }

    @Generated
    public OrganizationApiImpl(Y9DepartmentService y9DepartmentService, Y9OrganizationService orgOrganizationService) {
        this.y9DepartmentService = y9DepartmentService;
        this.orgOrganizationService = orgOrganizationService;
    }
}

