/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.org;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgSyncApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.MessageOrg;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.SyncOrgUnits;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.event.Y9OrgSyncRole;
import net.risesoft.y9public.entity.event.Y9PublishedEvent;
import net.risesoft.y9public.entity.event.Y9PublishedEventSyncHistory;
import net.risesoft.y9public.repository.event.Y9OrgSyncRoleRepository;
import net.risesoft.y9public.service.event.Y9PublishedEventService;
import net.risesoft.y9public.service.event.Y9PublishedEventSyncHistoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/orgSync"}, produces={"application/json"})
public class OrgSyncApiImpl
implements OrgSyncApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9DepartmentService y9DepartmentService;
    private final Y9GroupService y9GroupService;
    private final Y9OrganizationService y9OrganizationService;
    private final Y9PersonService y9PersonService;
    private final Y9PositionService y9PositionService;
    private final Y9PublishedEventService y9PublishedEventService;
    private final Y9PublishedEventSyncHistoryService y9PublishedEventSyncHistoryService;
    private final Y9OrgSyncRoleRepository y9OrgSyncRoleRepository;

    public Y9Result<MessageOrg<SyncOrgUnits>> fullSync(@RequestParam(value="appName") @NotBlank String appName, @RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgSyncRole role = this.y9OrgSyncRoleRepository.findById((Object)appName).orElse(null);
        if (role == null) {
            return Y9Result.success(null, (String)"\u672a\u62e5\u6709\u83b7\u53d6\u7ec4\u7ec7\u8282\u70b9\u6570\u636e\u7684\u6743\u9650");
        }
        Date syncTime = new Date();
        SyncOrgUnits syncOrgUnits = this.compositeOrgBaseService.getSyncOrgUnits(organizationId, OrgTypeEnum.ORGANIZATION, Boolean.TRUE);
        MessageOrg event = new MessageOrg((Serializable)syncOrgUnits, "RISEORGEVENT_TYPE_SYNC", Y9LoginUserHolder.getTenantId());
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Result.success((Object)event, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }

    public Y9Page<Department> fullSyncDept(@RequestParam String appName, @RequestParam String tenantId, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgSyncRole role = this.y9OrgSyncRoleRepository.findById((Object)appName).orElse(null);
        if (role == null) {
            return Y9Page.success((int)0, (int)0, (long)0L, null, (String)"\u5e94\u7528\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        Date syncTime = new Date();
        Page<Y9Department> deptPage = this.compositeOrgBaseService.deptPage(role.getOrgIds(), page, rows);
        List list = Y9ModelConvertUtil.convert((List)deptPage.getContent(), Department.class);
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Page.success((int)deptPage.getNumber(), (int)deptPage.getTotalPages(), (long)deptPage.getTotalElements(), (List)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Page<Person> fullSyncUser(@RequestParam String appName, @RequestParam String tenantId, @RequestParam String type, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgSyncRole role = this.y9OrgSyncRoleRepository.findById((Object)appName).orElse(null);
        if (role == null) {
            return Y9Page.success((int)0, (int)0, (long)0L, null, (String)"\u5e94\u7528\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        Date syncTime = new Date();
        Page<Y9Person> personPage = this.compositeOrgBaseService.personPage(role.getOrgIds(), type, page, rows);
        List list = Y9ModelConvertUtil.convert((List)personPage.getContent(), Person.class);
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Page.success((int)personPage.getNumber(), (int)personPage.getTotalPages(), (long)personPage.getTotalElements(), (List)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<List<MessageOrg<OrgUnit>>> incrSync(@RequestParam(value="appName") @NotBlank String appName, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgSyncRole role = this.y9OrgSyncRoleRepository.findById((Object)appName).orElse(null);
        if (role == null) {
            return Y9Result.success(null, (String)"\u5e94\u7528\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        Date syncTime = new Date();
        Date startTime = null;
        Optional<Y9PublishedEventSyncHistory> y9PublishedEventSyncHistoryOptional = this.y9PublishedEventSyncHistoryService.findByTenantIdAndAppName(tenantId, appName);
        if (y9PublishedEventSyncHistoryOptional.isPresent()) {
            startTime = y9PublishedEventSyncHistoryOptional.get().getLastSyncTime();
        }
        List<Y9PublishedEvent> list = this.y9PublishedEventService.listByTenantId(tenantId, startTime);
        ArrayList<MessageOrg> eventList = new ArrayList<MessageOrg>();
        for (Y9PublishedEvent event : list) {
            if (StringUtils.isBlank((CharSequence)event.getEntityJson())) {
                OrgUnit org = this.getOrgBase(event.getEventType(), event.getObjId());
                MessageOrg riseEvent = new MessageOrg((Serializable)org, event.getEventType(), tenantId);
                eventList.add(riseEvent);
                continue;
            }
            boolean isAdd = false;
            OrgUnit orgUnit = (OrgUnit)Y9JsonUtil.readValue((String)event.getEntityJson(), OrgUnit.class);
            String guidPath = orgUnit.getGuidPath();
            if (StringUtils.isNotBlank((CharSequence)guidPath)) {
                String[] ids;
                for (String id : ids = role.getOrgIds().split(",")) {
                    if (!guidPath.contains(id)) continue;
                    isAdd = true;
                    break;
                }
            } else {
                isAdd = true;
            }
            if (!isAdd) continue;
            MessageOrg riseEvent = new MessageOrg((Serializable)orgUnit, event.getEventType(), tenantId);
            eventList.add(riseEvent);
        }
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 0);
        return Y9Result.success(eventList, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }

    public Y9Result<String> syncTime(@RequestParam String appName, @RequestParam String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Date syncTime = null;
        Optional<Y9PublishedEventSyncHistory> history = this.y9PublishedEventSyncHistoryService.findByTenantIdAndAppName(tenantId, appName);
        if (!history.isPresent()) {
            return Y9Result.failure((String)"\u83b7\u53d6\u4e0d\u5230\u8bb0\u5f55\uff01");
        }
        syncTime = history.get().getSinceSyncTime();
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Result.success((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private OrgUnit getOrgBase(String eventType, String objId) {
        if ("RISEORGEVENT_TYPE_ADD_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.y9OrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.y9DepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_PERSON".equals(eventType)) {
            Y9Person person = this.y9PersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.y9OrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.y9DepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_PERSON".equals(eventType)) {
            Y9Person person = this.y9PersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.y9OrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.y9DepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_PERSON".equals(eventType)) {
            Y9Person person = this.y9PersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_GROUP".equals(eventType)) {
            Y9Group group = this.y9GroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_POSITION".equals(eventType)) {
            Y9Position position = this.y9PositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_GROUP".equals(eventType)) {
            Y9Group group = this.y9GroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_POSITION".equals(eventType)) {
            Y9Position position = this.y9PositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_GROUP".equals(eventType)) {
            Y9Group group = this.y9GroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_POSITION".equals(eventType)) {
            Y9Position position = this.y9PositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        return null;
    }

    @Generated
    public OrgSyncApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9DepartmentService y9DepartmentService, Y9GroupService y9GroupService, Y9OrganizationService y9OrganizationService, Y9PersonService y9PersonService, Y9PositionService y9PositionService, Y9PublishedEventService y9PublishedEventService, Y9PublishedEventSyncHistoryService y9PublishedEventSyncHistoryService, Y9OrgSyncRoleRepository y9OrgSyncRoleRepository) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9DepartmentService = y9DepartmentService;
        this.y9GroupService = y9GroupService;
        this.y9OrganizationService = y9OrganizationService;
        this.y9PersonService = y9PersonService;
        this.y9PositionService = y9PositionService;
        this.y9PublishedEventService = y9PublishedEventService;
        this.y9PublishedEventSyncHistoryService = y9PublishedEventSyncHistoryService;
        this.y9OrgSyncRoleRepository = y9OrgSyncRoleRepository;
    }
}

