/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.log.LogLevelEnum;
import net.risesoft.log.OperationTypeEnum;
import net.risesoft.log.annotation.RiseLog;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9public.entity.Y9logMapping;
import net.risesoft.y9public.service.Y9logMappingService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/mapping"})
public class FieldMappingController {
    private final Y9logMappingService y9logMappingService;

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationType=OperationTypeEnum.DELETE, operationName="\u6279\u91cf\u79fb\u9664\u5b57\u6bb5\u6620\u5c04", logLevel=LogLevelEnum.RSLOG)
    @PostMapping(value={"/deleteByIds"})
    public Y9Result<String> deleteByIds(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            this.y9logMappingService.deleteFieldMapping(id[i]);
        }
        return Y9Result.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationType=OperationTypeEnum.DELETE, operationName="\u79fb\u9664\u5b57\u6bb5\u6620\u5c04", logLevel=LogLevelEnum.RSLOG)
    @PostMapping(value={"/deleteFieldMapping"})
    public Y9Result<String> deleteFieldMapping(@RequestParam String id) {
        this.y9logMappingService.deleteFieldMapping(id);
        return Y9Result.success((Object)"", (String)"\u5220\u9664\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636eid\uff0c\u83b7\u53d6\u5b57\u6bb5\u6620\u5c04", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/getFieldMappingById"})
    public Y9Result<Y9logMapping> getFieldMappingById(String id) {
        Y9logMapping y9logMapping = this.y9logMappingService.getFieldMappingEntity(id);
        return Y9Result.success((Object)y9logMapping);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u5b57\u6bb5\u6620\u5c04\u5206\u9875\u5217\u8868", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/page"})
    public Y9Page<Y9logMapping> page(Y9PageQuery pageQuery, String sort) {
        Page resultPage = this.y9logMappingService.page(pageQuery.getPage().intValue(), pageQuery.getSize().intValue(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)resultPage.getTotalPages(), (long)resultPage.getTotalElements(), (List)resultPage.getContent());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u641c\u7d22\u5b57\u6bb5\u6620\u5c04\u5206\u9875\u5217\u8868", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pageSearchList"})
    public Y9Page<Y9logMapping> pageSearchList(String modularName, String modularCnName, Y9PageQuery pageQuery) {
        Page resultPage = this.y9logMappingService.pageSearchList(pageQuery.getPage(), pageQuery.getSize(), modularName, modularCnName);
        return Y9Page.success((int)pageQuery.getPage(), (int)resultPage.getTotalPages(), (long)resultPage.getTotalElements(), (List)resultPage.getContent());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationType=OperationTypeEnum.ADD, operationName="\u4fdd\u5b58\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @PostMapping(value={"/saveMapping"})
    public Y9Result<String> saveMapping(Y9logMapping modularNameMapping) {
        if (StringUtils.isBlank((CharSequence)modularNameMapping.getId())) {
            modularNameMapping.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        }
        this.y9logMappingService.save(modularNameMapping);
        return Y9Result.success((Object)"", (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u9a8c\u8bc1\u5b57\u6bb5\u6620\u5c04\u662f\u5426\u5b58\u5728", logLevel=LogLevelEnum.RSLOG)
    @PostMapping(value={"/validate"})
    public Y9Result<Boolean> validateField(String name) {
        List list = this.y9logMappingService.validateName(name);
        if (list.isEmpty()) {
            return Y9Result.success((Object)true);
        }
        return Y9Result.success((Object)false);
    }

    @Generated
    public FieldMappingController(Y9logMappingService y9logMappingService) {
        this.y9logMappingService = y9logMappingService;
    }
}

