/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.LoginInformation;
import net.risesoft.pojo.PersonInformation;
import net.risesoft.util.JxlsUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.mime.ContentDispositionUtil;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import net.risesoft.y9public.service.Y9logUserLoginInfoService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import y9.client.rest.platform.org.PersonApiClient;

@Controller
@RequestMapping(value={"/admin/download"})
public class DownloadController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadController.class);
    private final Y9logUserLoginInfoService userLoginInfoService;
    private final PersonApiClient personManager;

    @ResponseBody
    @RequestMapping(value={"/exportNotLoginXLS"}, method={RequestMethod.GET})
    public void exportNotLoginXLS(String tenantId, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            Y9LoginUserHolder.setTenantId((String)tenantId);
        }
        try (ServletOutputStream outStream = response.getOutputStream();
             InputStream in = new ClassPathResource("/template/exportSimpleTemplate.xlsx").getInputStream();){
            Map<String, Object> map = this.xlsLoginData2(tenantId);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", ContentDispositionUtil.standardizeAttachment((String)("\u6709\u751f\u4e91\u672a\u767b\u5f55\u4fe1\u606f-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx")));
            JxlsUtil jxlsUtil = new JxlsUtil();
            jxlsUtil.exportExcel(in, (OutputStream)outStream, map);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/exportLoginXLS"}, method={RequestMethod.GET})
    public void exportPersonXLS(String tenantId, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            Y9LoginUserHolder.setTenantId((String)tenantId);
        }
        try (ServletOutputStream outStream = response.getOutputStream();
             InputStream in = new ClassPathResource("/template/exportSimpleTemplate.xlsx").getInputStream();){
            Map<String, Object> map = this.xlsLoginData(tenantId);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", ContentDispositionUtil.standardizeAttachment((String)("\u6709\u751f\u4e91\u767b\u5f55\u4fe1\u606f-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx")));
            JxlsUtil jxlsUtil = new JxlsUtil();
            jxlsUtil.exportExcel(in, (OutputStream)outStream, map);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String reverseSplit(String path) {
        if (!path.contains(",")) {
            return path;
        }
        String[] oldString = path.split(",");
        StringBuffer strBuffer = new StringBuffer();
        for (int lenth = oldString.length; lenth > 0; --lenth) {
            strBuffer.append(oldString[lenth - 1]);
            strBuffer.append(",");
        }
        String newString = strBuffer.toString();
        return newString.substring(0, newString.lastIndexOf(","));
    }

    public Map<String, Object> xlsLoginData(String tenantID) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterable userLoginInfoList = this.userLoginInfoService.listAll();
        Iterator iterator = userLoginInfoList.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Y9logUserLoginInfo info = (Y9logUserLoginInfo)iterator.next();
            String userId = info.getUserId();
            if (userIDList.contains(userId)) continue;
            userIDList.add(userId);
        }
        List persons = (List)this.personManager.list(tenantID).getData();
        ArrayList<PersonInformation> personInformationList = new ArrayList<PersonInformation>();
        for (Person person : persons) {
            String personId;
            if (person.getDisabled().booleanValue() || !userIDList.contains(personId = person.getId())) continue;
            PersonInformation pf = new PersonInformation();
            String fullPath = person.getDn().replaceAll("cn=", "").replaceAll(",ou=", ",").replaceAll(",o=", ",");
            String path = fullPath.substring(0, fullPath.lastIndexOf(","));
            if (path.contains(",") && fullPath.lastIndexOf(",") == fullPath.lastIndexOf(",")) {
                path = path.substring(fullPath.indexOf(",") + 1);
                pf.setFullPath(this.reverseSplit(path));
            } else if (!path.contains(",")) {
                pf.setFullPath(null);
            } else {
                path = path.substring(fullPath.indexOf(",") + 1, fullPath.lastIndexOf(","));
                pf.setFullPath(this.reverseSplit(path));
            }
            pf.setName(fullPath.substring(0, fullPath.indexOf(",")));
            pf.setEmail(person.getEmail());
            pf.setLoginName(person.getLoginName());
            pf.setMobile(person.getMobile());
            pf.setSex(person.getSex().getDescription());
            personInformationList.add(pf);
        }
        map.put("personList", personInformationList);
        return map;
    }

    public Map<String, Object> xlsLoginData2(String tenantID) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterable userLoginInfoList = this.userLoginInfoService.listAll();
        Iterator iterator = userLoginInfoList.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Y9logUserLoginInfo info = (Y9logUserLoginInfo)iterator.next();
            String userId = info.getUserId();
            if (userIDList.contains(userId)) continue;
            userIDList.add(userId);
        }
        List persons = (List)this.personManager.list(tenantID).getData();
        ArrayList<PersonInformation> personInformationList = new ArrayList<PersonInformation>();
        for (Person person : persons) {
            String personId;
            if (person.getDisabled().booleanValue() || userIDList.contains(personId = person.getId())) continue;
            PersonInformation pf = new PersonInformation();
            String fullPath = person.getDn().replaceAll("cn=", "").replaceAll(",ou=", ",").replaceAll(",o=", ",");
            String path = fullPath.substring(0, fullPath.lastIndexOf(","));
            if (path.contains(",") && fullPath.lastIndexOf(",") == fullPath.lastIndexOf(",")) {
                path = path.substring(fullPath.indexOf(",") + 1);
                pf.setFullPath(this.reverseSplit(path));
            } else if (!path.contains(",")) {
                pf.setFullPath(null);
            } else {
                path = path.substring(fullPath.indexOf(",") + 1, fullPath.lastIndexOf(","));
                pf.setFullPath(this.reverseSplit(path));
            }
            pf.setName(fullPath.substring(0, fullPath.indexOf(",")));
            pf.setEmail(person.getEmail());
            pf.setLoginName(person.getLoginName());
            pf.setMobile(person.getMobile());
            pf.setSex(person.getSex().getDescription());
            personInformationList.add(pf);
        }
        map.put("personList", personInformationList);
        return map;
    }

    public Map<String, Object> xlsLoginDataLogin() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterable userLoginInfoList = this.userLoginInfoService.listAll();
        Iterator iterator = userLoginInfoList.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        ArrayList<LoginInformation> personInformationList = new ArrayList<LoginInformation>();
        while (iterator.hasNext()) {
            Y9logUserLoginInfo info = (Y9logUserLoginInfo)iterator.next();
            String userId = info.getUserId();
            LoginInformation login = new LoginInformation();
            login.setTenantId(info.getTenantId());
            login.setUserId(userId);
            login.setUserName(info.getUserName());
            if (userIDList.contains(userId)) continue;
            userIDList.add(userId);
            personInformationList.add(login);
        }
        map.put("personList", personInformationList);
        return map;
    }

    @Generated
    public DownloadController(Y9logUserLoginInfoService userLoginInfoService, PersonApiClient personManager) {
        this.userLoginInfoService = userLoginInfoService;
        this.personManager = personManager;
    }
}

