/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.enums.platform.ManagerLevelEnum;
import net.risesoft.log.LogLevelEnum;
import net.risesoft.log.annotation.RiseLog;
import net.risesoft.model.log.LogInfoModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9public.entity.Y9logAccessLog;
import net.risesoft.y9public.service.Y9logAccessLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/accessLog"})
public class AccessLogController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessLogController.class);
    private final Y9logAccessLogService logService;

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u7edf\u8ba1APP\u88ab\u70b9\u51fb\u7684\u6392\u884c\u60c5\u51b5", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getAppClickCount"})
    public Y9Result<Map<String, Object>> getAppClickCount(String orgId, String orgType, String startDay, String endDay) {
        Map map = new HashMap();
        String tenantId = Y9LoginUserHolder.getTenantId();
        try {
            map = this.logService.getAppClickCount(orgId, orgType, tenantId, startDay, endDay);
        }
        catch (UnknownHostException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return Y9Result.success(map);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u7edf\u8ba1\u6a21\u5757\u8bbf\u95ee\u60c5\u51b5", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getModuleAccessData"})
    public Y9Result<Map<String, Object>> getModuleAccessData(String orgId, String orgType, String startDay, String endDay) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Map map = this.logService.getModuleNameCount(orgId, orgType, tenantId, startDay, endDay);
        return Y9Result.success((Object)map);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u64cd\u4f5c\u72b6\u6001\u7684\u7edf\u8ba1\u6570\u636e", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getOperateStatusData"})
    public Y9Result<Map<String, Object>> getOperateStatusData(@RequestParam(required=false) String selectedDate) {
        Map map = this.logService.getOperateStatusCount(selectedDate);
        return Y9Result.success((Object)map);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u64cd\u4f5c\u7528\u65f6\u7684\u67f1\u72b6\u56fe\u6570\u636e", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/listEplasedTimeData"})
    public Y9Result<List<Long>> listEplasedTimeData(String startDay, String endDay) {
        List list = this.logService.listOperateTimeCount(startDay, endDay);
        return Y9Result.success((Object)list);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u770b\u5b89\u5168\u5ba1\u8ba1\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/pageByAuditManagers"})
    public Y9Page<Y9logAccessLog> pageByAuditManagers(String userId, Y9PageQuery pageQuery, String sort) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.AUDIT_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_AUDIT_MANAGER.getValue();
        }
        Page pageList = this.logService.pageByTenantIdAndManagerLevelAndUserId(tenantId, String.valueOf(managerLevel), userId, pageQuery.getPage(), pageQuery.getSize(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u5b89\u5168\u5ba1\u8ba1\u5458\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u641c\u7d22\u64cd\u4f5c\u7528\u65f6\u5217\u8868", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/pageByElapsedTime"})
    public Y9Page<Y9logAccessLog> pageByElapsedTime(LogInfoModel searchDto, String startDay, String endDay, String sTime, String lTime, Y9PageQuery pageQuery) {
        try {
            Page pageResult = this.logService.pageElapsedTimeByCondition(searchDto, startDay, endDay, sTime, lTime, pageQuery.getPage(), pageQuery.getSize());
            return Y9Page.success((int)pageQuery.getPage(), (int)pageResult.getTotalPages(), (long)pageResult.getTotalElements(), (List)pageResult.getContent());
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u64cd\u4f5c\u72b6\u6001\u5217\u8868\u6570\u636e", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/pageByOperateStatus"})
    public Y9Page<Y9logAccessLog> pageByOperateStatus(LogInfoModel searchDto, String date, String hour, String operateStatus, Y9PageQuery pageQuery) throws ParseException {
        Page pageResult = this.logService.pageOperateStatusByOperateStatus(searchDto, operateStatus, date, hour, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)pageResult.getTotalPages(), (long)pageResult.getTotalElements(), (List)pageResult.getContent());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u770b\u5b89\u5168\u4fdd\u5bc6\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/pageBySecurityManagers"})
    public Y9Page<Y9logAccessLog> pageBySecurityManagers(String userId, Y9PageQuery pageQuery, String sort) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.SECURITY_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_SECURITY_MANAGER.getValue();
        }
        Page pageList = this.logService.pageByTenantIdAndManagerLevelAndUserId(tenantId, String.valueOf(managerLevel), userId, pageQuery.getPage(), pageQuery.getSize(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u5b89\u5168\u4fdd\u5bc6\u5458\u65e5\u5fd7\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u770b\u7cfb\u7edf\u7ba1\u7406\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/pageBySystemManagers"})
    public Y9Page<Y9logAccessLog> pageBySystemManagers(String userId, Y9PageQuery pageQuery, String sort) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.SYSTEM_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_SYSTEM_MANAGER.getValue();
        }
        Page pageList = this.logService.pageByTenantIdAndManagerLevelAndUserId(tenantId, String.valueOf(managerLevel), userId, pageQuery.getPage(), pageQuery.getSize(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u7cfb\u7edf\u7ba1\u7406\u5458\u65e5\u5fd7\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u770b\u7528\u6237\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/pageByUsers"})
    public Y9Page<Y9logAccessLog> pageByUsers(String userId, Y9PageQuery pageQuery, String sort) {
        Page pageList = this.logService.pageByTenantIdAndManagerLevelAndUserId(Y9LoginUserHolder.getTenantId(), String.valueOf(ManagerLevelEnum.GENERAL_USER.getValue()), userId, pageQuery.getPage(), pageQuery.getSize(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u7528\u6237\u65e5\u5fd7\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u65e5\u5fd7\u5206\u9875\u5217\u8868", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/pageLogInfo"})
    public Y9Page<Y9logAccessLog> pageLogInfo(Y9PageQuery pageQuery, String sort) {
        Page pageList = this.logService.page(pageQuery.getPage().intValue(), pageQuery.getSize().intValue(), sort);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u641c\u7d22\u65e5\u5fd7\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/pageSreachList"})
    public Y9Page<Y9logAccessLog> pageSreachList(LogInfoModel searchDto, Y9PageQuery pageQuery, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) {
        Page resultPage = this.logService.pageSearchByCondition(searchDto, startTime, endTime, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)resultPage.getTotalPages(), (long)resultPage.getTotalElements(), (List)resultPage.getContent());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u8be2\u5b89\u5168\u5ba1\u8ba1\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/searchAuditManagers"})
    public Y9Page<Y9logAccessLog> searchAuditManagers(LogInfoModel loginInfoModel, Y9PageQuery pageQuery) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.AUDIT_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_AUDIT_MANAGER.getValue();
        }
        Page pageList = this.logService.searchQuery(tenantId, String.valueOf(managerLevel), loginInfoModel, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u5b89\u5168\u5ba1\u8ba1\u5458\u641c\u7d22\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u8be2\u5b89\u5168\u4fdd\u5bc6\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/searchSecurityManagers"})
    public Y9Page<Y9logAccessLog> searchSecurityManagers(LogInfoModel loginInfoModel, Y9PageQuery pageQuery) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.SECURITY_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_SECURITY_MANAGER.getValue();
        }
        Page pageList = this.logService.searchQuery(tenantId, String.valueOf(managerLevel), loginInfoModel, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u5b89\u5168\u4fdd\u5bc6\u5458\u65e5\u5fd7\u641c\u7d22\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u8be2\u7cfb\u7edf\u7ba1\u7406\u5458\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/searchSystemManagers"})
    public Y9Page<Y9logAccessLog> searchSystemManagers(LogInfoModel loginInfoModel, Y9PageQuery pageQuery) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Integer managerLevel = ManagerLevelEnum.SYSTEM_MANAGER.getValue();
        if ("11111111-1111-1111-1111-111111111120".equals(Y9LoginUserHolder.getTenantId())) {
            managerLevel = ManagerLevelEnum.OPERATION_SYSTEM_MANAGER.getValue();
        }
        Page pageList = this.logService.searchQuery(tenantId, String.valueOf(managerLevel), loginInfoModel, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u7cfb\u7edf\u7ba1\u7406\u5458\u65e5\u5fd7\u641c\u7d22\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u8be2\u7528\u6237\u65e5\u5fd7", logLevel=LogLevelEnum.MANAGERLOG)
    @RequestMapping(value={"/searchUsers"})
    public Y9Page<Y9logAccessLog> searchUsers(LogInfoModel loginInfoModel, Y9PageQuery pageQuery) {
        Page pageList = this.logService.searchQuery(Y9LoginUserHolder.getTenantId(), String.valueOf(ManagerLevelEnum.GENERAL_USER.getValue()), loginInfoModel, pageQuery.getPage(), pageQuery.getSize());
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u7528\u6237\u65e5\u5fd7\u641c\u7d22\u5206\u9875\u5217\u8868\u6210\u529f");
    }

    @Generated
    public AccessLogController(Y9logAccessLogService logService) {
        this.logService = logService;
    }
}

