/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import jxl.write.WriteException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.transform.Transformer;
import org.jxls.transform.jexcel.JexcelTransformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiTransformer;

public class MergeCommand
extends AbstractCommand {
    private String cols;
    private String rows;
    private CellStyle cellStyle;
    private Area area;

    private static void setRegionStyle(CellStyle cs, CellRangeAddress region, Sheet sheet) {
        for (int i = region.getFirstRow(); i <= region.getLastRow(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                row = sheet.createRow(i);
            }
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle(cs);
            }
        }
    }

    public Command addArea(Area area) {
        if (super.getAreaList().size() >= 1) {
            throw new IllegalArgumentException("You can add only a single area to 'merge' command");
        }
        this.area = area;
        return super.addArea(area);
    }

    public Size applyAt(CellRef cellRef, Context context) {
        Object colsObj;
        Object rowsObj;
        int rows = 1;
        int cols = 1;
        if (StringUtils.isNotBlank((CharSequence)this.rows) && (rowsObj = this.getTransformationConfig().getExpressionEvaluator().evaluate(this.rows, context.toMap())) != null && NumberUtils.isDigits((String)rowsObj.toString())) {
            rows = NumberUtils.toInt((String)rowsObj.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.cols) && (colsObj = this.getTransformationConfig().getExpressionEvaluator().evaluate(this.cols, context.toMap())) != null && NumberUtils.isDigits((String)colsObj.toString())) {
            cols = NumberUtils.toInt((String)colsObj.toString());
        }
        if (rows > 1 || cols > 1) {
            Transformer transformer = this.getTransformer();
            if (transformer instanceof PoiTransformer) {
                return this.poiMerge(cellRef, context, (PoiTransformer)transformer, rows, cols);
            }
            if (transformer instanceof JexcelTransformer) {
                return this.jexcelMerge(cellRef, context, (JexcelTransformer)transformer, rows, cols);
            }
        }
        this.area.applyAt(cellRef, context);
        return new Size(cols, rows);
    }

    public Area getArea() {
        return this.area;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public String getCols() {
        return this.cols;
    }

    public String getName() {
        return "merge";
    }

    public String getRows() {
        return this.rows;
    }

    protected Size jexcelMerge(CellRef cellRef, Context context, JexcelTransformer transformer, int rows, int cols) {
        try {
            transformer.getWritableWorkbook().getSheet(cellRef.getSheetName()).mergeCells(cellRef.getRow(), cellRef.getCol(), cellRef.getRow() + rows - 1, cellRef.getCol() + cols - 1);
            this.area.applyAt(cellRef, context);
        }
        catch (WriteException e) {
            throw new IllegalArgumentException("\u5408\u5e76\u5355\u5143\u683c\u5931\u8d25");
        }
        return new Size(cols, rows);
    }

    protected Size poiMerge(CellRef cellRef, Context context, PoiTransformer transformer, int rows, int cols) {
        PoiCellData cellData;
        Sheet sheet = transformer.getWorkbook().getSheet(cellRef.getSheetName());
        CellRangeAddress region = new CellRangeAddress(cellRef.getRow(), cellRef.getRow() + rows - 1, cellRef.getCol(), cellRef.getCol() + cols - 1);
        sheet.addMergedRegion(region);
        this.area.applyAt(cellRef, context);
        if (this.cellStyle == null && (cellData = (PoiCellData)transformer.getCellData(cellRef)) != null) {
            this.cellStyle = cellData.getCellStyle();
        }
        MergeCommand.setRegionStyle(this.cellStyle, region, sheet);
        return new Size(cols, rows);
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }
}

