/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.kafka;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9public.entity.Y9logIpDeptMapping;
import net.risesoft.y9public.entity.Y9logUserHostIpInfo;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import net.risesoft.y9public.service.Y9logIpDeptMappingService;
import net.risesoft.y9public.service.Y9logUserHostIpInfoService;
import net.risesoft.y9public.service.Y9logUserLoginInfoService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;

public class Y9UserLoginInfoListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9UserLoginInfoListener.class);
    private final Y9logUserLoginInfoService y9logUserLoginInfoService;
    private final Y9logUserHostIpInfoService y9logUserHostIpInfoService;
    private final Y9logIpDeptMappingService y9logIpDeptMappingService;

    @KafkaListener(topics={"y9_userLoginInfo_message"})
    public void listener(ConsumerRecord<String, String> data) {
        try {
            List list;
            String msg = (String)data.value();
            HashMap map = Y9JsonUtil.readHashMap((String)msg);
            String userHostIp = String.valueOf(map.get("userHostIp"));
            if (userHostIp.contains(":")) {
                userHostIp = "127.0.0.1";
            }
            String clientIpSection = userHostIp.substring(0, userHostIp.lastIndexOf("."));
            if (this.y9logUserLoginInfoService != null) {
                Y9logUserLoginInfo userLoginInfo = new Y9logUserLoginInfo();
                userLoginInfo.setId(String.valueOf(map.get("id")));
                userLoginInfo.setLoginTime(new Date());
                userLoginInfo.setLoginType(String.valueOf(map.get("loginType")));
                userLoginInfo.setUserId(String.valueOf(map.get("userId")));
                userLoginInfo.setUserLoginName(String.valueOf(map.get("userLoginName")));
                userLoginInfo.setUserName(String.valueOf(map.get("userName")));
                userLoginInfo.setUserHostIp(userHostIp);
                userLoginInfo.setUserHostMac(String.valueOf(map.get("userHostMac")));
                userLoginInfo.setUserHostName(String.valueOf(map.get("userHostName")));
                userLoginInfo.setUserHostDiskId(String.valueOf(map.get("userHostDiskId")));
                userLoginInfo.setTenantId(String.valueOf(map.get("tenantId")));
                userLoginInfo.setTenantName(String.valueOf(map.get("tenantName")));
                userLoginInfo.setServerIp(String.valueOf(map.get("serverIp")));
                userLoginInfo.setSuccess(String.valueOf(map.get("success")));
                userLoginInfo.setLogMessage(String.valueOf(map.get("logMessage")));
                userLoginInfo.setBrowserName(String.valueOf(map.get("browserName")));
                userLoginInfo.setBrowserVersion(String.valueOf(map.get("browserVersion")));
                userLoginInfo.setScreenResolution(String.valueOf(map.get("screenResolution")));
                userLoginInfo.setOsName(String.valueOf(map.get("osName")));
                userLoginInfo.setClientIpSection(clientIpSection);
                userLoginInfo.setManagerLevel(String.valueOf(map.get("managerLevel")));
                this.y9logUserLoginInfoService.save(userLoginInfo);
            }
            if (this.y9logUserHostIpInfoService != null && ((list = this.y9logUserHostIpInfoService.listByUserHostIp(userHostIp)) == null || list.size() == 0)) {
                Y9logUserHostIpInfo entity = new Y9logUserHostIpInfo();
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setClientIpSection(clientIpSection);
                entity.setUserHostIp(userHostIp);
                this.y9logUserHostIpInfoService.save(entity);
            }
            if (this.y9logIpDeptMappingService != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List list2 = this.y9logIpDeptMappingService.listByClientIpSection(clientIpSection);
                if (list2 == null || list2.size() == 0) {
                    Y9logIpDeptMapping entity = new Y9logIpDeptMapping();
                    entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    entity.setClientIpSection(clientIpSection);
                    entity.setDeptName("\u6b64IP\u672a\u6307\u5b9a\u90e8\u95e8");
                    entity.setOperator(String.valueOf(map.get("userName")));
                    entity.setSaveTime(sdf.format(new Date()));
                    entity.setStatus(Integer.valueOf(1));
                    entity.setTabIndex(Integer.valueOf(666));
                    entity.setUpdateTime(sdf.format(new Date()));
                    this.y9logIpDeptMappingService.save(entity);
                } else {
                    for (Y9logIpDeptMapping entity : list2) {
                        if (entity.getStatus() != null && entity.getStatus() == 1) continue;
                        entity.setStatus(Integer.valueOf(1));
                        this.y9logIpDeptMappingService.save(entity);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Generated
    public Y9UserLoginInfoListener(Y9logUserLoginInfoService y9logUserLoginInfoService, Y9logUserHostIpInfoService y9logUserHostIpInfoService, Y9logIpDeptMappingService y9logIpDeptMappingService) {
        this.y9logUserLoginInfoService = y9logUserLoginInfoService;
        this.y9logUserHostIpInfoService = y9logUserHostIpInfoService;
        this.y9logIpDeptMappingService = y9logIpDeptMappingService;
    }
}

