/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.log.LogLevelEnum;
import net.risesoft.log.annotation.RiseLog;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Day;
import net.risesoft.y9public.entity.Y9logIpDeptMapping;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import net.risesoft.y9public.service.Y9logIpDeptMappingService;
import net.risesoft.y9public.service.Y9logUserHostIpInfoService;
import net.risesoft.y9public.service.Y9logUserLoginInfoService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import y9.client.rest.platform.org.PersonApiClient;

@RestController
@RequestMapping(value={"/admin/terminal"})
public class TerminalController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalController.class);
    private final PersonApiClient personManager;
    private final Y9logIpDeptMappingService y9logIpDeptMappingService;
    private final Y9logUserLoginInfoService y9logUserLoginInfoService;
    private final Y9logUserHostIpInfoService y9logUserHostIpInfoService;

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u4e00\u5b9a\u65f6\u95f4\u6bb5\u5185\u7684\u5404\u4e2aIP\u6bb5\u767b\u5f55\u4eba\u6570\u6570\u636e", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/getUserLoginDataByIpSection"})
    public Y9Result<Map<String, Object>> getUserLoginDataByIpSection(String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List clientIpList = this.y9logIpDeptMappingService.listClientIpSections();
        ArrayList<Long> countList = new ArrayList<Long>();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!clientIpList.isEmpty()) {
                for (String clientIp : clientIpList) {
                    long count = this.y9logUserLoginInfoService.countByUserHostIpLikeAndLoginTimeBetweenAndSuccess(clientIp, formater.parse(startTime), formater.parse(endTime), "true");
                    countList.add(count);
                }
            }
            long personCount = this.y9logUserLoginInfoService.countByLoginTimeBetweenAndSuccess(formater.parse(startTime), formater.parse(endTime), "true");
            map.put("personCount", personCount);
        }
        catch (ParseException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        map.put("clientIpList", clientIpList);
        map.put("countList", countList);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u6240\u6709\u767b\u5f55\u7684\u7ec8\u7aefIP", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/listAllUserHostIPs"})
    public Y9Result<List<Map<String, Object>>> listAllUserHostIPs() {
        ArrayList cIPlist = new ArrayList();
        List ipDeptMappingList = this.y9logIpDeptMappingService.listAllOrderByClientIpSection();
        for (Y9logIpDeptMapping ipDeptMapping : ipDeptMappingList) {
            String cip = ipDeptMapping.getClientIpSection();
            HashMap<String, Object> cIPMap = new HashMap<String, Object>();
            cIPMap.put("pid", 0);
            cIPMap.put("name", cip + "(" + ipDeptMapping.getDeptName() + ")");
            cIPMap.put("CIP", cip);
            cIPlist.add(cIPMap);
        }
        return Y9Result.success(cIPlist, (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636eC\u7c7bIP\u6bb5\uff0c\u83b7\u53d6\u5c5e\u4e8e\u8be5IP\u6bb5\u7684IP\u5730\u5740\u548c\u6b21\u6570", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/listTerminalIpByCip"})
    public Y9Result<List<Map<String, Object>>> listTerminalIpByCip(String cip) {
        List list = this.y9logUserLoginInfoService.listUserHostIpByCip(cip);
        return Y9Result.success((Object)list);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u67e5\u8be2\u51fa\u8be5\u65f6\u95f4\u6bb5\u7ec8\u7aefIP\u7684\u767b\u5f55\u8be6\u60c5\u9875\u9762", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/listTerminator"})
    public Y9Result<List<String>> listTerminator(String startTime, String endTime, String userHostIp) {
        List userHostIpList = null;
        userHostIpList = StringUtils.isNotBlank((CharSequence)userHostIp) ? this.y9logUserHostIpInfoService.listUserHostIpByUserHostIpLike(userHostIp) : this.y9logUserHostIpInfoService.listAllUserHostIps();
        return Y9Result.success((Object)userHostIpList);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u4eba\u5458id\uff0c\u83b7\u53d6\u6240\u6709\u767b\u9646\u6210\u529f\u7684\u7ec8\u7aefip", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/listUserHostIpByUserId"})
    public Y9Result<List<Map<String, Object>>> listUserHostIpByUserId(@RequestParam String userId) {
        ArrayList list = new ArrayList();
        List userHostIPList = this.y9logUserLoginInfoService.listUserHostIpByUserId(userId, "true");
        for (String userHostIP : userHostIPList) {
            long counter = this.y9logUserLoginInfoService.countBySuccessAndUserHostIpAndUserId("true", userHostIP, userId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userHostIp", userHostIP);
            map.put("name", userHostIP + "(" + counter + ")");
            list.add(map);
        }
        return Y9Result.success(list);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u90e8\u95e8\u83b7\u53d6\u90e8\u95e8\u4e0b\u7684\u6240\u6709\u4eba\u5458", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pagePersonByDeptId"})
    public Y9Page<Map<String, Object>> pagePersonByDeptId(String parentId, Y9PageQuery pageQuery) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList list = new ArrayList();
        Y9Page personPage = this.personManager.pageByParentId(tenantId, parentId, false, pageQuery);
        List personList = personPage.getRows();
        if (!personList.isEmpty()) {
            personList.forEach(person -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Integer countNum = this.y9logUserLoginInfoService.countByPersonId(person.getId());
                if (countNum != null && countNum > 0) {
                    map.put("id", person.getId());
                    map.put("loginName", person.getName());
                    map.put("dn", person.getDn());
                    map.put("loginNum", countNum);
                    list.add(map);
                }
            });
        }
        return Y9Page.success((int)pageQuery.getPage(), (int)0, (long)list.size(), list);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u90e8\u95e8id\u4ee5\u53ca\u4eba\u5458\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u8be5\u90e8\u95e8\u4e0b\u7684\u4eba\u5458", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pagePersonByDeptIdAndUserName"})
    public Y9Page<Map<String, Object>> pagePersonByDeptIdAndUserName(String parentId, String userName, Y9PageQuery pageQuery) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList list = new ArrayList();
        Y9Page personPage = this.personManager.pageByParentIdAndName(tenantId, parentId, false, userName, pageQuery);
        List personList = personPage.getRows();
        if (!personList.isEmpty()) {
            for (Person orgPerson : personList) {
                Integer countNum = this.y9logUserLoginInfoService.countByPersonId(orgPerson.getId());
                if (countNum <= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", orgPerson.getId());
                map.put("loginName", orgPerson.getName());
                map.put("dn", orgPerson.getDn());
                map.put("loginNum", countNum.toString());
                list.add(map);
            }
        }
        return Y9Page.success((int)pageQuery.getPage(), (int)personPage.getTotalPages(), (long)personPage.getTotal(), list);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u7ec8\u7aefC\u6bb5IP\u548c\u65f6\u95f4\u6bb5\u67e5\u8be2\u51fa\u8be5\u65f6\u95f4\u6bb5\u7ec8\u7aefIP\u7684\u767b\u5f55\u8be6\u60c5", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pageSearchByLoginTime"})
    public Y9Page<Y9logUserLoginInfo> pageSearchByLoginTime(String startTime, String endTime, String userHostIp, Y9PageQuery pageQuery) {
        Date start = null;
        Date end = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            start = StringUtils.isNotBlank((CharSequence)startTime) ? formater.parse(startTime) : Y9Day.getStartOfDay((Date)new Date());
            end = StringUtils.isNotBlank((CharSequence)endTime) ? formater.parse(endTime) : Y9Day.getEndOfDay((Date)new Date());
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        Y9Page userLoginInfoList = null;
        userLoginInfoList = StringUtils.isNotBlank((CharSequence)userHostIp) ? this.y9logUserLoginInfoService.pageByUserHostIpLikeAndLoginTimeBetweenAndSuccess(userHostIp, start, end, "true", pageQuery.getPage().intValue(), pageQuery.getSize().intValue()) : this.y9logUserLoginInfoService.pageByLoginTimeBetweenAndSuccess(start, end, "true", pageQuery.getPage().intValue(), pageQuery.getSize().intValue());
        return userLoginInfoList;
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u7ec8\u7aefIP\u548c\u4eba\u5458\u4ee5\u53ca\u65f6\u95f4\u6bb5\u6a21\u7cca\u641c\u7d22\u6539\u4eba\u5458\u7684\u8be6\u7ec6\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pageSearchList"})
    public Y9Page<Y9logUserLoginInfo> pageSearchList(String userHostIp, String userId, String startTime, String endTime, Y9PageQuery pageQuery) {
        return this.y9logUserLoginInfoService.page(null, userHostIp, userId, "true", startTime, endTime, pageQuery);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u4e0d\u540c\u7684\u7ec8\u7aefIP\uff0c\u67e5\u8be2\u76f8\u5173\u4eba\u5458\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pageUserLoginListData"})
    public Y9Page<Map<String, Object>> pageUserLoginListData(String userHostIp, String userName, Y9PageQuery pageQuery) {
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            return this.y9logUserLoginInfoService.pageByUserHostIpAndSuccessAndUserNameLike(userHostIp, "true", userName, pageQuery.getPage().intValue(), pageQuery.getSize().intValue());
        }
        return this.y9logUserLoginInfoService.pageByUserHostIpAndSuccess(userHostIp, "true", pageQuery.getPage().intValue(), pageQuery.getSize().intValue());
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u7ec8\u7aefIP\u548c\u4eba\u5458\u83b7\u53d6\u4eba\u5458\u7684\u8be6\u7ec6\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @GetMapping(value={"/pageUserTerminalDetail"})
    public Y9Page<Y9logUserLoginInfo> pageUserTerminalDetail(String userId, String userHostIp, Y9PageQuery pageQuery) {
        Page userLoginInfoList = this.y9logUserLoginInfoService.pageBySuccessAndUserHostIpAndUserId("true", userHostIp, userId, pageQuery.getPage().intValue(), pageQuery.getSize().intValue());
        return Y9Page.success((int)pageQuery.getPage(), (int)userLoginInfoList.getTotalPages(), (long)userLoginInfoList.getTotalElements(), (List)userLoginInfoList.getContent());
    }

    @Generated
    public TerminalController(PersonApiClient personManager, Y9logIpDeptMappingService y9logIpDeptMappingService, Y9logUserLoginInfoService y9logUserLoginInfoService, Y9logUserHostIpInfoService y9logUserHostIpInfoService) {
        this.personManager = personManager;
        this.y9logIpDeptMappingService = y9logIpDeptMappingService;
        this.y9logUserLoginInfoService = y9logUserLoginInfoService;
        this.y9logUserHostIpInfoService = y9logUserHostIpInfoService;
    }
}

