/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.TenantTypeEnum;
import net.risesoft.log.LogLevelEnum;
import net.risesoft.log.annotation.RiseLog;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Tenant;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9EnumUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import y9.client.rest.platform.org.OrgUnitApiClient;
import y9.client.rest.platform.org.OrganizationApiClient;
import y9.client.rest.platform.tenant.TenantApiClient;

@RestController
@RequestMapping(value={"/admin/orgUnit"})
public class OrgUnitController {
    private final OrganizationApiClient organizationManager;
    private final OrgUnitApiClient orgUnitManager;
    private final TenantApiClient tenantApiClient;

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u79df\u6237\u7ec4\u7ec7\u673a\u6784\u5217\u8868", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getTenantOrganization"})
    public Y9Result<List<Organization>> getTenantORGOrganization(String tenantId) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = Y9LoginUserHolder.getTenantId();
        }
        List org = (List)this.organizationManager.list(tenantId).getData();
        return Y9Result.success((Object)org);
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u6839\u636e\u79df\u6237\u7c7b\u578b\u83b7\u53d6\u6240\u6709\u79df\u6237\u4fe1\u606f", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getTenantTreeByTenantType"})
    public List<Organization> getTenantTreeByTenantType(@RequestParam Integer tenantType) {
        List tenants = (List)this.tenantApiClient.listByTenantType((TenantTypeEnum)Y9EnumUtil.valueOf(TenantTypeEnum.class, (Object)tenantType)).getData();
        ArrayList<Organization> organizationList = new ArrayList<Organization>();
        if (!tenants.isEmpty()) {
            for (Tenant tenant : tenants) {
                if (!tenant.getTenantType().equals((Object)tenantType)) continue;
                Y9LoginUserHolder.setTenantId((String)tenant.getId());
                List list = (List)this.organizationManager.list(tenant.getId()).getData();
                organizationList.addAll(list);
            }
        }
        return organizationList;
    }

    @RiseLog(moduleName="\u65e5\u5fd7\u7cfb\u7edf", operationName="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u6811", logLevel=LogLevelEnum.RSLOG)
    @RequestMapping(value={"/getTree"})
    public Y9Result<List<OrgUnit>> getTree(String tenantId, @RequestParam String id, @RequestParam OrgTreeTypeEnum treeType) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = Y9LoginUserHolder.getTenantId();
        }
        List orgUnitList = (List)this.orgUnitManager.getSubTree(tenantId, id, treeType).getData();
        return Y9Result.success((Object)orgUnitList);
    }

    @Generated
    public OrgUnitController(OrganizationApiClient organizationManager, OrgUnitApiClient orgUnitManager, TenantApiClient tenantApiClient) {
        this.organizationManager = organizationManager;
        this.orgUnitManager = orgUnitManager;
        this.tenantApiClient = tenantApiClient;
    }
}

