/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.impl;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.log.UserLoginInfoApi;
import net.risesoft.model.userlogininfo.LoginInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.Y9logIpDeptMapping;
import net.risesoft.y9public.entity.Y9logUserHostIpInfo;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import net.risesoft.y9public.service.Y9logIpDeptMappingService;
import net.risesoft.y9public.service.Y9logUserHostIpInfoService;
import net.risesoft.y9public.service.Y9logUserLoginInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/v1/userLoginInfo"}, produces={"application/json"})
public class UserLoginInfoApiController
implements UserLoginInfoApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UserLoginInfoApiController.class);
    private final Y9logIpDeptMappingService ipDeptMappingService;
    private final Y9logUserHostIpInfoService userHostIpInfoService;
    private final Y9logUserLoginInfoService userLoginInfoService;

    public LoginInfo getTopByTenantIdAndUserId(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9logUserLoginInfo login = this.userLoginInfoService.getTopByTenantIdAndUserId(tenantId, personId);
        return (LoginInfo)Y9ModelConvertUtil.convert((Object)login, LoginInfo.class);
    }

    @GetMapping(value={"/pageSearch"})
    public Y9Page<LoginInfo> pageSearch(@RequestParam(value="userHostIp", required=false) String userHostIp, @RequestParam(value="personId") String personId, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="success", required=false) String success, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @Validated Y9PageQuery pageQuery) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Page loginList = this.userLoginInfoService.page(tenantId, userHostIp, userHostIp, success, startTime, endTime, pageQuery);
        List list = loginList.getRows();
        List infoList = Y9ModelConvertUtil.convert((List)list, LoginInfo.class);
        return Y9Page.success((int)loginList.getCurrPage(), (int)loginList.getTotalPages(), (long)loginList.getTotal(), (List)infoList);
    }

    @PostMapping(value={"/saveLoginInfo"})
    public Y9Result<Object> saveLoginInfo(@RequestBody LoginInfo info) {
        List list;
        String userHostIp = info.getUserHostIp();
        if (this.userLoginInfoService != null) {
            Y9logUserLoginInfo userLoginInfo = new Y9logUserLoginInfo();
            userLoginInfo.setId(info.getId());
            userLoginInfo.setLoginTime(info.getLoginTime());
            userLoginInfo.setLoginType(info.getLoginType());
            userLoginInfo.setUserId(info.getUserId());
            userLoginInfo.setUserName(info.getUserName());
            userLoginInfo.setUserHostIp(info.getUserHostIp());
            userLoginInfo.setUserHostMac(info.getUserHostMac());
            userLoginInfo.setUserHostName(info.getUserHostName());
            userLoginInfo.setUserHostDiskId(info.getUserHostDiskId());
            userLoginInfo.setTenantId(info.getTenantId());
            userLoginInfo.setTenantName(info.getTenantName());
            userLoginInfo.setServerIp(info.getServerIp());
            userLoginInfo.setSuccess(info.getSuccess());
            userLoginInfo.setLogMessage(info.getLogMessage());
            userLoginInfo.setBrowserName(info.getBrowserName());
            userLoginInfo.setBrowserVersion(info.getBrowserVersion());
            userLoginInfo.setScreenResolution(info.getScreenResolution());
            userLoginInfo.setOsName(info.getOsName());
            this.userLoginInfoService.save(userLoginInfo);
        }
        String clientIpSection = userHostIp.substring(0, userHostIp.indexOf("."));
        if (this.userHostIpInfoService != null && (list = this.userHostIpInfoService.listByUserHostIp(userHostIp)).size() <= 0) {
            Y9logUserHostIpInfo userHostIpInfo = new Y9logUserHostIpInfo();
            userHostIpInfo.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            userHostIpInfo.setClientIpSection(clientIpSection);
            userHostIpInfo.setUserHostIp(userHostIp);
            this.userHostIpInfoService.save(userHostIpInfo);
        }
        if (this.ipDeptMappingService != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List list2 = this.ipDeptMappingService.listByClientIpSection(clientIpSection);
            if (list2.size() <= 0) {
                Y9logIpDeptMapping ipDeptMapping = new Y9logIpDeptMapping();
                ipDeptMapping.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                ipDeptMapping.setClientIpSection(clientIpSection);
                ipDeptMapping.setDeptName("\u6b64IP\u672a\u6307\u5b9a\u90e8\u95e8");
                ipDeptMapping.setOperator(info.getUserName());
                ipDeptMapping.setSaveTime(sdf.format(new Date()));
                ipDeptMapping.setStatus(Integer.valueOf(1));
                ipDeptMapping.setTabIndex(Integer.valueOf(666));
                ipDeptMapping.setUpdateTime(sdf.format(new Date()));
                this.ipDeptMappingService.save(ipDeptMapping);
            } else {
                for (Y9logIpDeptMapping ipDeptMapping : list2) {
                    if (ipDeptMapping.getStatus() != null && ipDeptMapping.getStatus() == 1) continue;
                    ipDeptMapping.setStatus(Integer.valueOf(1));
                    this.ipDeptMappingService.save(ipDeptMapping);
                }
            }
        }
        return Y9Result.success();
    }

    @PostMapping(value={"/saveLoginInfoAsync"})
    public Y9Result<Object> saveLoginInfoAsync(@RequestBody LoginInfo info) {
        ThreadFactory myThread = new ThreadFactoryBuilder().setNamePrefix("y9-saveLoginInfoAsync").build();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(2, 2, 100L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(5), myThread);
        threadPool.execute(() -> this.saveLoginInfo(info));
        threadPool.shutdown();
        return Y9Result.success();
    }

    @Generated
    public UserLoginInfoApiController(Y9logIpDeptMappingService ipDeptMappingService, Y9logUserHostIpInfoService userHostIpInfoService, Y9logUserLoginInfoService userLoginInfoService) {
        this.ipDeptMappingService = ipDeptMappingService;
        this.userHostIpInfoService = userHostIpInfoService;
        this.userLoginInfoService = userLoginInfoService;
    }
}

