/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.impl;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.log.AccessLogApi;
import net.risesoft.model.log.AccessLog;
import net.risesoft.model.log.LogInfoModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9public.entity.Y9logAccessLog;
import net.risesoft.y9public.service.Y9logAccessLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/v1/accessLog"}, produces={"application/json"})
public class AccessLogApiController
implements AccessLogApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessLogApiController.class);
    private final Y9logAccessLogService accessLogService;

    @PostMapping(value={"/asyncSaveLog"})
    public Y9Result<Object> asyncSaveLog(@RequestBody AccessLog accessLog) {
        ThreadFactory myThread = new ThreadFactoryBuilder().setNamePrefix("y9-asyncSaveLog").build();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(2, 2, 100L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(5), myThread);
        threadPool.execute(() -> this.saveLog(accessLog));
        threadPool.shutdown();
        return Y9Result.success();
    }

    @GetMapping(value={"/pageByOperateType"})
    public Y9Page<AccessLog> pageByOperateType(@RequestParam(value="operateType") @NotBlank String operateType, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        return this.accessLogService.pageByOperateType(operateType, page, rows);
    }

    @GetMapping(value={"/pageByOrgType"})
    public Y9Page<AccessLog> pageByOrgType(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgId") @NotBlank String orgId, @RequestParam(value="orgType") @NotBlank String orgType, @RequestParam(value="operateType") @NotBlank String operateType, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.accessLogService.pageByOrgType(tenantId, orgId, orgType, operateType, page, rows);
    }

    @PostMapping(value={"/saveLog"})
    public Y9Result<Object> saveLog(@RequestBody AccessLog accessLog) {
        String accessLogJson = Y9JsonUtil.writeValueAsString((Object)accessLog);
        Y9logAccessLog y9AccessLog = (Y9logAccessLog)Y9JsonUtil.readValue((String)accessLogJson, Y9logAccessLog.class);
        accessLog.setLogTime(new Date());
        this.accessLogService.save(y9AccessLog);
        return Y9Result.success();
    }

    @GetMapping(value={"/search"})
    public Y9Page<AccessLog> search(@RequestParam(value="logLevel", required=false) String logLevel, @RequestParam(value="success", required=false) String success, @RequestParam(value="operateType", required=false) String operateType, @RequestParam(value="operateName", required=false) String operateName, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="userHostIp", required=false) String userHostIp, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        LogInfoModel search = new LogInfoModel();
        search.setLogLevel(logLevel);
        search.setOperateName(operateName);
        search.setSuccess(success);
        search.setOperateType(operateType);
        search.setUserName(userName);
        search.setUserHostIp(userHostIp);
        return this.accessLogService.pageByCondition(search, startTime, endTime, page, rows);
    }

    @Generated
    public AccessLogApiController(Y9logAccessLogService accessLogService) {
        this.accessLogService = accessLogService;
    }
}

