/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository.custom.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import net.risesoft.model.log.FlowableAccessLog;
import net.risesoft.model.log.LogInfoModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.util.AccessLogModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Day;
import net.risesoft.y9public.entity.Y9logFlowableAccessLog;
import net.risesoft.y9public.repository.Y9logFlowableAccessLogRepository;
import net.risesoft.y9public.repository.custom.Y9logFlowableAccessLogCustomRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(value="rsPublicTransactionManager", readOnly=true)
public class Y9logFlowableAccessLogCustomRepositoryImpl
implements Y9logFlowableAccessLogCustomRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9logFlowableAccessLogCustomRepositoryImpl.class);
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private final Y9logFlowableAccessLogRepository y9logFlowableAccessLogRepository;

    public Y9logFlowableAccessLogCustomRepositoryImpl(Y9logFlowableAccessLogRepository y9logFlowableAccessLogRepository) {
        this.y9logFlowableAccessLogRepository = y9logFlowableAccessLogRepository;
    }

    public long getOperateTimeCount(final Date startDay, final Date endDay, final boolean betweenAble, final long elapsedTimeStart, final Long elapsedTimeEnd) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        return this.y9logFlowableAccessLogRepository.count((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)Y9LoginUserHolder.getTenantId()));
                }
                list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDay, (Comparable)endDay));
                if (betweenAble) {
                    list.add(criteriaBuilder.between(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(elapsedTimeStart), (Comparable)elapsedTimeEnd));
                } else {
                    list.add(criteriaBuilder.greaterThanOrEqualTo(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(elapsedTimeStart)));
                }
                return predicate;
            }
        });
    }

    @Override
    public List<Long> listOperateTimeCount(String startDay, String endDay) {
        Date day;
        Date sDay = null;
        Date eDay = null;
        ArrayList<Long> list = new ArrayList<Long>();
        long[] longArray = new long[]{1L, 1000000L, 10000000L, 100000000L, 1000000000L, 5000000000L, 10000000000L};
        if (StringUtils.isNotBlank((CharSequence)startDay)) {
            try {
                day = DATE_FORMAT.parse(startDay);
                sDay = Y9Day.getStartOfDay((Date)day);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endDay)) {
            try {
                day = DATE_FORMAT.parse(endDay);
                eDay = Y9Day.getEndOfDay((Date)day);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        for (int i = 0; i < longArray.length; ++i) {
            if (i < longArray.length - 1) {
                list.add(this.getOperateTimeCount(sDay, eDay, true, longArray[i], longArray[i + 1]));
                continue;
            }
            list.add(this.getOperateTimeCount(sDay, eDay, false, longArray[i], null));
        }
        return list;
    }

    @Override
    public Page<Y9logFlowableAccessLog> page(int page, int rows, String sort) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sort}) ? PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sort}) : PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logFlowableAccessLogRepository.findAll((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Y9Page<FlowableAccessLog> pageByCondition(final LogInfoModel searchDto, final String startTime, final String endTime, Integer page, Integer rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        Page pageInfo = this.y9logFlowableAccessLogRepository.findAll((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)searchDto.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserName())) {
                    list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)searchDto.getUserName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserHostIp())) {
                    list.add(criteriaBuilder.equal(root.get("userHostIp").as(String.class), (Object)searchDto.getUserHostIp()));
                }
                if (StringUtils.isNotEmpty((CharSequence)searchDto.getOperateName())) {
                    list.add(criteriaBuilder.equal(root.get("operateName").as(String.class), (Object)searchDto.getOperateName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getTitle())) {
                    list.add(criteriaBuilder.like(root.get("title").as(String.class), "%" + searchDto.getTitle() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getArguments())) {
                    list.add(criteriaBuilder.like(root.get("arguments").as(String.class), "%" + searchDto.getArguments() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
                    String sTime = startTime + " 00:00:00";
                    String eTime = endTime + " 23:59:59";
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDate, (Comparable)endDate));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), AccessLogModelConvertUtil.flowableLogEsListToModels(pageInfo.getContent()));
    }

    @Override
    public Page<Y9logFlowableAccessLog> pageElapsedTimeByCondition(final LogInfoModel searchDto, final String startDay, final String endDay, final String sTime, final String lTime, Integer page, Integer rows) throws ParseException {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logFlowableAccessLogRepository.findAll((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)searchDto.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getTitle())) {
                    list.add(criteriaBuilder.like(root.get("title").as(String.class), "%" + searchDto.getTitle() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getArguments())) {
                    list.add(criteriaBuilder.like(root.get("arguments").as(String.class), "%" + searchDto.getArguments() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)startDay) && StringUtils.isNotBlank((CharSequence)endDay)) {
                    try {
                        Date sDay = Y9Day.getStartOfDay((Date)DATE_FORMAT.parse(startDay));
                        Date eDay = Y9Day.getEndOfDay((Date)DATE_FORMAT.parse(endDay));
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)sDay, (Comparable)eDay));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sTime)) {
                    long smallTime = Long.parseLong(sTime);
                    if (StringUtils.isNotBlank((CharSequence)lTime)) {
                        long largeTime = Long.parseLong(lTime);
                        list.add(criteriaBuilder.between(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(smallTime), (Comparable)Long.valueOf(largeTime)));
                    } else {
                        list.add(criteriaBuilder.greaterThan(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(smallTime)));
                    }
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Page<Y9logFlowableAccessLog> pageOperateStatusByOperateStatus(final LogInfoModel searchDto, final String operateStatus, final String date, final String hour, Integer page, Integer rows) throws ParseException {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logFlowableAccessLogRepository.findAll((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                if (StringUtils.isNotBlank((CharSequence)operateStatus)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)operateStatus));
                }
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserName())) {
                    list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)searchDto.getUserName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getTenantName())) {
                    list.add(criteriaBuilder.equal(root.get("tenantName").as(String.class), (Object)searchDto.getTenantName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getTitle())) {
                    list.add(criteriaBuilder.like(root.get("title").as(String.class), "%" + searchDto.getTitle() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getArguments())) {
                    list.add(criteriaBuilder.like(root.get("arguments").as(String.class), "%" + searchDto.getArguments() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)date) && StringUtils.isNotBlank((CharSequence)hour)) {
                    int h = Integer.parseInt(hour);
                    Calendar cal = Calendar.getInstance();
                    try {
                        Date day = DATE_FORMAT.parse(date);
                        Date dat = Y9Day.getStartOfDay((Date)day);
                        cal.setTime(dat);
                        cal.add(11, h);
                        Date startOfTime = cal.getTime();
                        cal.add(12, 59);
                        cal.add(13, 59);
                        Date endOfTime = cal.getTime();
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startOfTime, (Comparable)endOfTime));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Page<Y9logFlowableAccessLog> pageSearchByCondition(final LogInfoModel loginInfoModel, final String startTime, final String endTime, Integer page, Integer rows) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logFlowableAccessLogRepository.findAll((Specification)new Specification<Y9logFlowableAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logFlowableAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)loginInfoModel.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)loginInfoModel.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)loginInfoModel.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOperateName())) {
                    list.add(criteriaBuilder.like(root.get("operateName").as(String.class), "%" + loginInfoModel.getOperateName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserName())) {
                    list.add(criteriaBuilder.like(root.get("userName").as(String.class), "%" + loginInfoModel.getUserName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserHostIp())) {
                    list.add(criteriaBuilder.equal(root.get("userHostIp").as(String.class), (Object)loginInfoModel.getUserHostIp()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getTenantName())) {
                    list.add(criteriaBuilder.equal(root.get("tenantName").as(String.class), (Object)loginInfoModel.getTenantName()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getModularName())) {
                    list.add(criteriaBuilder.like(root.get("modularName").as(String.class), "%" + loginInfoModel.getModularName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getTitle())) {
                    list.add(criteriaBuilder.like(root.get("title").as(String.class), "%" + loginInfoModel.getTitle() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getArguments())) {
                    list.add(criteriaBuilder.like(root.get("arguments").as(String.class), "%" + loginInfoModel.getArguments() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getStartTime()) && StringUtils.isNotBlank((CharSequence)loginInfoModel.getEndTime())) {
                    String sTime = startTime + " 00:00:00";
                    String eTime = endTime + " 23:59:59";
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDate, (Comparable)endDate));
                    }
                    catch (ParseException e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Y9logFlowableAccessLog y9logAccessLog) {
        this.y9logFlowableAccessLogRepository.save(y9logAccessLog);
    }
}

