/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository.custom.impl;

import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import net.risesoft.model.log.AccessLog;
import net.risesoft.model.log.LogInfoModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.util.AccessLogModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9Day;
import net.risesoft.y9public.entity.Y9logAccessLog;
import net.risesoft.y9public.repository.Y9logAccessLogRepository;
import net.risesoft.y9public.repository.custom.Y9logAccessLogCustomRepository;
import net.risesoft.y9public.repository.custom.Y9logMappingCustomRepository;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(value="rsPublicTransactionManager", readOnly=true)
public class Y9logAccessLogCustomRepositoryImpl
implements Y9logAccessLogCustomRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9logAccessLogCustomRepositoryImpl.class);
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private final Y9logMappingCustomRepository y9logMappingCustomRepository;
    private final Y9logAccessLogRepository y9logAccessLogRepository;
    private final JdbcTemplate jdbcTemplate4Public;

    public Y9logAccessLogCustomRepositoryImpl(Y9logMappingCustomRepository y9logMappingCustomRepository, Y9logAccessLogRepository y9logAccessLogRepository, @Qualifier(value="jdbcTemplate4Public") JdbcTemplate jdbcTemplate4Public) {
        this.y9logMappingCustomRepository = y9logMappingCustomRepository;
        this.y9logAccessLogRepository = y9logAccessLogRepository;
        this.jdbcTemplate4Public = jdbcTemplate4Public;
    }

    @Override
    public Map<String, Object> getAppClickCount(String tenantId, String guidPath, String startDay, String endDay) throws UnknownHostException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<String> longList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT(l.MODULAR_NAME) as appName,count(l.MODULAR_NAME) as count FROM  Y9_LOG_ACCESS_LOG l WHERE ");
        sql.append("l.METHOD_NAME ='net.risesoft.controller.AppRestController.saveAppCheckCount' ");
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            sql.append("AND l.TENANT_ID ='" + tenantId + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)guidPath)) {
            sql.append("AND l.GUID_PATH LIKE '" + guidPath + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)startDay) && StringUtils.isNotBlank((CharSequence)endDay)) {
            Date sDay = new Date();
            Date eDay = new Date();
            try {
                sDay = Y9Day.getStartOfDay((Date)DATE_FORMAT.parse(startDay));
                eDay = Y9Day.getEndOfDay((Date)DATE_FORMAT.parse(endDay));
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            sql.append("AND l.LOG_TIME >= '" + sDay.getTime() + "' ");
            sql.append("AND l.LOG_TIME <= '" + eDay.getTime() + "' ");
        }
        sql.append("GROUP BY l.MODULAR_NAME");
        List countAppNames = this.jdbcTemplate4Public.queryForList(sql.toString());
        int length = countAppNames.size();
        for (int i = length - 1; i >= 0; --i) {
            String appName = ((Map)countAppNames.get(i)).get("appName").toString();
            strList.add(appName);
            longList.add(((Map)countAppNames.get(i)).get("count").toString());
        }
        returnMap.put("number", length);
        returnMap.put("name", strList);
        returnMap.put("value", longList);
        return returnMap;
    }

    @Override
    public Map<String, Object> getModuleNameCount(String tenantId, String guidPath, String startDay, String endDay) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<String> longList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT(log.MODULAR_NAME) as modularname,count(log.MODULAR_NAME) as count FROM  Y9_LOG_ACCESS_LOG log WHERE ");
        sql.append("log.USER_NAME IS NOT NULL ");
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            sql.append("AND log.TENANT_ID ='" + tenantId + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)guidPath)) {
            sql.append("AND log.GUID_PATH LIKE '" + guidPath + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)startDay) && StringUtils.isNotBlank((CharSequence)endDay)) {
            Date sDay = new Date();
            Date eDay = new Date();
            try {
                sDay = Y9Day.getStartOfDay((Date)DATE_FORMAT.parse(startDay));
                eDay = Y9Day.getEndOfDay((Date)DATE_FORMAT.parse(endDay));
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            sql.append("AND log.LOG_TIME > '" + sDay.getTime() + "' ");
            sql.append("AND log.LOG_TIME < '" + eDay.getTime() + "' ");
        }
        sql.append("GROUP BY log.MODULAR_NAME");
        List countModularNames = this.jdbcTemplate4Public.queryForList(sql.toString());
        int length = countModularNames.size();
        for (int i = length - 1; i >= 0; --i) {
            String modularName = ((Map)countModularNames.get(i)).get("modularName").toString();
            String modularCnName = this.y9logMappingCustomRepository.getCnModularName(modularName);
            if (StringUtils.isNotBlank((CharSequence)modularCnName)) {
                modularName = modularCnName;
            }
            strList.add(modularName);
            longList.add(((Map)countModularNames.get(i)).get("count").toString());
        }
        int num = strList.size();
        map.put("name", strList);
        map.put("value", longList);
        map.put("number", num);
        return map;
    }

    @Override
    public Map<String, Object> getOperateStatusCount(String selectedDate, Integer tenantType) {
        ArrayList<Integer> time = new ArrayList<Integer>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Long> countOfSuccess = new ArrayList<Long>();
        ArrayList<Long> countOfError = new ArrayList<Long>();
        String success = "\u6210\u529f";
        String error = "\u51fa\u9519";
        Date day = new Date();
        if (StringUtils.isNotBlank((CharSequence)selectedDate)) {
            try {
                day = DATE_FORMAT.parse(selectedDate);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            Date startOfTime = Y9Day.getStartOfDay((Date)day);
            Date endOfTime = null;
            for (int i = 0; i < 24; ++i) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(day);
                cal.set(11, i);
                startOfTime = cal.getTime();
                cal.add(12, 59);
                cal.add(13, 59);
                endOfTime = cal.getTime();
                String tenantId = Y9LoginUserHolder.getTenantId();
                long countSuccess = 0L;
                long countError = 0L;
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    countSuccess = this.y9logAccessLogRepository.countByTenantIdAndSuccessAndLogTimeBetweenAndUserNameNotNull(tenantId, success, startOfTime, endOfTime);
                    countError = this.y9logAccessLogRepository.countByTenantIdAndSuccessAndLogTimeBetweenAndUserNameNotNull(tenantId, error, startOfTime, endOfTime);
                } else {
                    countSuccess = this.y9logAccessLogRepository.countBySuccessAndLogTimeBetweenAndUserNameNotNull(success, startOfTime, endOfTime);
                    countError = this.y9logAccessLogRepository.countBySuccessAndLogTimeBetweenAndUserNameNotNull(error, startOfTime, endOfTime);
                }
                countOfSuccess.add(countSuccess);
                countOfError.add(countError);
                time.add(startOfTime.getHours());
            }
        }
        map.put("time", time);
        map.put("totalOfSuccess", countOfSuccess);
        map.put("totalOfError", countOfError);
        return map;
    }

    public long getOperateTimeCount(final Date startDay, final Date endDay, Integer tenantType, final boolean betweenAble, final long elapsedTimeStart, final Long elapsedTimeEnd) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        return this.y9logAccessLogRepository.count((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)Y9LoginUserHolder.getTenantId()));
                }
                list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDay, (Comparable)endDay));
                if (betweenAble) {
                    list.add(criteriaBuilder.between(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(elapsedTimeStart), (Comparable)elapsedTimeEnd));
                } else {
                    list.add(criteriaBuilder.greaterThanOrEqualTo(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(elapsedTimeStart)));
                }
                return predicate;
            }
        });
    }

    @Override
    public List<String> listAccessLog(final String tenantId, final String loginName, final String startTime, final String endTime) {
        ArrayList<String> strList = new ArrayList<String>();
        List searchList = this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)loginName));
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                Date startDate = null;
                Date endDate = null;
                try {
                    startDate = DATE_TIME_FORMAT.parse(startTime);
                    endDate = DATE_TIME_FORMAT.parse(endTime);
                    list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDate, (Comparable)endDate));
                }
                catch (ParseException e1) {
                    LOGGER.warn(e1.getMessage(), (Throwable)e1);
                }
                return predicate;
            }
        });
        searchList.stream().forEach(team -> strList.add(Y9JsonUtil.writeValueAsString((Object)team)));
        return strList;
    }

    @Override
    public List<Long> listOperateTimeCount(String startDay, String endDay, Integer tenantType) {
        Date day;
        Date sDay = null;
        Date eDay = null;
        ArrayList<Long> list = new ArrayList<Long>();
        long[] longArray = new long[]{1L, 1000000L, 10000000L, 100000000L, 1000000000L, 5000000000L, 10000000000L};
        if (StringUtils.isNotBlank((CharSequence)startDay)) {
            try {
                day = DATE_FORMAT.parse(startDay);
                sDay = Y9Day.getStartOfDay((Date)day);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endDay)) {
            try {
                day = DATE_FORMAT.parse(endDay);
                eDay = Y9Day.getEndOfDay((Date)day);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        for (int i = 0; i < longArray.length; ++i) {
            if (i < longArray.length - 1) {
                list.add(this.getOperateTimeCount(sDay, eDay, tenantType, true, longArray[i], longArray[i + 1]));
                continue;
            }
            list.add(this.getOperateTimeCount(sDay, eDay, tenantType, false, longArray[i], null));
        }
        return list;
    }

    @Override
    public Page<Y9logAccessLog> page(int page, int rows, String sort) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sort}) ? PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sort}) : PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Y9Page<AccessLog> pageByCondition(final LogInfoModel searchDto, final String startTime, final String endTime, Integer page, Integer rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        Page pageInfo = this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)searchDto.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserName())) {
                    list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)searchDto.getUserName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserHostIp())) {
                    list.add(criteriaBuilder.equal(root.get("userHostIp").as(String.class), (Object)searchDto.getUserHostIp()));
                }
                if (StringUtils.isNotEmpty((CharSequence)searchDto.getOperateName())) {
                    list.add(criteriaBuilder.equal(root.get("operateName").as(String.class), (Object)searchDto.getOperateName()));
                }
                if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
                    String sTime = startTime + " 00:00:00";
                    String eTime = endTime + " 23:59:59";
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDate, (Comparable)endDate));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), AccessLogModelConvertUtil.logEsListToModels(pageInfo.getContent()));
    }

    @Override
    public Y9Page<AccessLog> pageByOperateType(String operateType, Integer page, Integer rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        Page<Y9logAccessLog> pageInfo = this.y9logAccessLogRepository.findByOperateType(operateType, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), AccessLogModelConvertUtil.logEsListToModels(pageInfo.getContent()));
    }

    @Override
    public Y9Page<AccessLog> pageByOrgType(String tenantId, final List<String> personIds, final String operateType, Integer page, Integer rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        Page pageInfo = this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)operateType)) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)operateType));
                }
                if (CollectionUtils.isNotEmpty((Collection)personIds)) {
                    CriteriaBuilder.In in = criteriaBuilder.in(root.get("userId").as(String.class));
                    for (String id : personIds) {
                        in.value((Object)id);
                    }
                    list.add(in);
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), AccessLogModelConvertUtil.logEsListToModels(pageInfo.getContent()));
    }

    @Override
    public Page<Y9logAccessLog> pageByTenantIdAndManagerLevelAndUserId(final String tenantId, final String managerLevel, final String userId, Integer page, Integer rows, String sort) {
        PageRequest pageable = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sort}) ? PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sort}) : PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (tenantId != null) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    list.add(criteriaBuilder.equal(root.get("userId").as(String.class), (Object)userId));
                }
                if (StringUtils.isNotBlank((CharSequence)managerLevel)) {
                    list.add(criteriaBuilder.equal(root.get("managerLevel").as(String.class), (Object)managerLevel));
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Page<Y9logAccessLog> pageElapsedTimeByCondition(final LogInfoModel searchDto, final String startDay, final String endDay, final String sTime, final String lTime, Integer tenantType, Integer page, Integer rows) throws ParseException {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)searchDto.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)startDay) && StringUtils.isNotBlank((CharSequence)endDay)) {
                    try {
                        Date sDay = Y9Day.getStartOfDay((Date)DATE_FORMAT.parse(startDay));
                        Date eDay = Y9Day.getEndOfDay((Date)DATE_FORMAT.parse(endDay));
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)sDay, (Comparable)eDay));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sTime)) {
                    long smallTime = Long.parseLong(sTime);
                    if (StringUtils.isNotBlank((CharSequence)lTime)) {
                        long largeTime = Long.parseLong(lTime);
                        list.add(criteriaBuilder.between(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(smallTime), (Comparable)Long.valueOf(largeTime)));
                    } else {
                        list.add(criteriaBuilder.greaterThan(root.get("elapsedTime").as(Long.class), (Comparable)Long.valueOf(smallTime)));
                    }
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Page<Y9logAccessLog> pageOperateStatusByOperateStatus(final LogInfoModel searchDto, final String operateStatus, final String date, final String hour, Integer tenantType, Integer page, Integer rows) throws ParseException {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                if (StringUtils.isNotBlank((CharSequence)operateStatus)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)operateStatus));
                }
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getUserName())) {
                    list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)searchDto.getUserName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getTenantName())) {
                    list.add(criteriaBuilder.equal(root.get("tenantName").as(String.class), (Object)searchDto.getTenantName()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)searchDto.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)searchDto.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)searchDto.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)date) && StringUtils.isNotBlank((CharSequence)hour)) {
                    int h = Integer.parseInt(hour);
                    Calendar cal = Calendar.getInstance();
                    try {
                        Date day = DATE_FORMAT.parse(date);
                        Date dat = Y9Day.getStartOfDay((Date)day);
                        cal.setTime(dat);
                        cal.add(11, h);
                        Date startOfTime = cal.getTime();
                        cal.add(12, 59);
                        cal.add(13, 59);
                        Date endOfTime = cal.getTime();
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startOfTime, (Comparable)endOfTime));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    public Page<Y9logAccessLog> pageSearchByCondition(final LogInfoModel loginInfoModel, final String startTime, final String endTime, Integer tenantType, Integer page, Integer rows) {
        final String tenantId = Y9LoginUserHolder.getTenantId();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)loginInfoModel.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)loginInfoModel.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)loginInfoModel.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserName())) {
                    list.add(criteriaBuilder.equal(root.get("userName").as(String.class), (Object)loginInfoModel.getUserName()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserHostIp())) {
                    list.add(criteriaBuilder.equal(root.get("userHostIp").as(String.class), (Object)loginInfoModel.getUserHostIp()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getTenantName())) {
                    list.add(criteriaBuilder.equal(root.get("tenantName").as(String.class), (Object)loginInfoModel.getTenantName()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getModularName())) {
                    list.add(criteriaBuilder.like(root.get("modularName").as(String.class), "%" + loginInfoModel.getModularName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getStartTime()) && StringUtils.isNotBlank((CharSequence)loginInfoModel.getEndTime())) {
                    String sTime = startTime + " 00:00:00";
                    String eTime = endTime + " 23:59:59";
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)startDate, (Comparable)endDate));
                    }
                    catch (ParseException e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
                list.add(criteriaBuilder.isNotNull(root.get("userName").as(String.class)));
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Y9logAccessLog y9logAccessLog) {
        this.y9logAccessLogRepository.save(y9logAccessLog);
    }

    @Override
    public Page<Y9logAccessLog> searchQuery(final String tenantId, final String managerLevel, final LogInfoModel loginInfoModel, Integer page, Integer rows) {
        PageRequest pageable = null;
        pageable = StringUtils.isNotBlank((CharSequence)loginInfoModel.getSortName()) ? PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{loginInfoModel.getSortName()}) : PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"logTime"});
        return this.y9logAccessLogRepository.findAll((Specification)new Specification<Y9logAccessLog>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logAccessLog> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotEmpty((CharSequence)managerLevel)) {
                    list.add(criteriaBuilder.equal(root.get("managerLevel").as(String.class), (Object)managerLevel));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserName())) {
                    list.add(criteriaBuilder.like(root.get("userName").as(String.class), "%" + loginInfoModel.getUserName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserHostIp())) {
                    list.add(criteriaBuilder.like(root.get("userHostIp").as(String.class), "%" + loginInfoModel.getUserHostIp() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getModularName())) {
                    list.add(criteriaBuilder.like(root.get("modularName").as(String.class), "%" + loginInfoModel.getModularName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOperateName())) {
                    list.add(criteriaBuilder.like(root.get("operateName").as(String.class), "%" + loginInfoModel.getOperateName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOperateType())) {
                    list.add(criteriaBuilder.equal(root.get("operateType").as(String.class), (Object)loginInfoModel.getOperateType()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)loginInfoModel.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getLogLevel())) {
                    list.add(criteriaBuilder.equal(root.get("logLevel").as(String.class), (Object)loginInfoModel.getLogLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getStartTime()) && StringUtils.isNotBlank((CharSequence)loginInfoModel.getEndTime())) {
                    String sTime = loginInfoModel.getStartTime() + " 00:00:00";
                    String eTime = loginInfoModel.getEndTime() + " 23:59:59";
                    SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        Date start = sdfUtc.parse(sdfUtc.format(startDate));
                        Date end = sdfUtc.parse(sdfUtc.format(endDate));
                        list.add(criteriaBuilder.between(root.get("logTime").as(Date.class), (Comparable)start, (Comparable)end));
                    }
                    catch (ParseException e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
    }
}

