/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="rsPublicTransactionManager", readOnly=true)
public interface Y9logUserLoginInfoRepository
extends JpaRepository<Y9logUserLoginInfo, String>,
JpaSpecificationExecutor<Y9logUserLoginInfo> {
    public long countByUserHostIpAndSuccess(String var1, String var2);

    public long countByUserHostIpAndSuccessAndUserNameContaining(String var1, String var2, String var3);

    public Page<Y9logUserLoginInfo> findBySuccessAndUserHostIpAndUserId(String var1, String var2, String var3, Pageable var4);

    public Page<Y9logUserLoginInfo> findByTenantIdAndManagerLevel(String var1, String var2, Pageable var3);

    public Page<Y9logUserLoginInfo> findByTenantIdAndSuccessAndUserHostIpAndUserId(String var1, String var2, String var3, String var4, Pageable var5);

    public Page<Y9logUserLoginInfo> findByUserHostIpAndSuccess(String var1, String var2, Pageable var3);

    @Query(value="select u.userId,u.userName,u.userHostIp,COUNT(*) from Y9logUserLoginInfo u where u.userHostIp = ?1 and u.success = ?2 and u.userName like %?3% group by u.userId,u.userName,u.userHostIp")
    public Page<Object[]> findByUserHostIpAndSuccessAndUserNameLike(String var1, String var2, String var3, Pageable var4);

    @Query(value="select u.userId,u.userName,u.userHostIp,COUNT(*) from Y9logUserLoginInfo u where u.userHostIp = ?1 and u.success = ?2 and u.userName like %?3% AND tenantId =?4 group by u.userId,u.userName,u.userHostIp")
    public Page<Object[]> findByUserHostIpAndSuccessAndUserNameLikeAndTenantId(String var1, String var2, String var3, String var4, Pageable var5);

    public List<Y9logUserLoginInfo> findByUserId(String var1);

    public Set<Y9logUserLoginInfo> findByUserIdAndSuccess(String var1, String var2);

    @Query(value="select u.userId,u.userName,u.userHostIp,COUNT(u) from Y9logUserLoginInfo u where u.userHostIp = ?1 and u.success = ?2 group by u.userId,u.userName,u.userHostIp")
    public Page<Object[]> findDistinctByUserHostIpAndSuccess(String var1, String var2, Pageable var3);

    @Query(value="select u.userId,u.userName,u.userHostIp,COUNT(u) from Y9logUserLoginInfo u where u.userHostIp = ?1 and u.success = ?2 AND tenantId =?3 group by u.userId,u.userName,u.userHostIp")
    public Page<Object[]> findDistinctByUserHostIpAndSuccessAndTenantId(String var1, String var2, String var3, Pageable var4);

    @Query(value="select DISTINCT(u.userHostIp) as userHostIp ,count(*) as count from Y9logUserLoginInfo u where u.userHostIp LIKE ?1% group by u.userHostIp")
    public List<Map<String, Object>> findDistinctByUserHostIpLike(String var1);

    @Query(value="select DISTINCT(u.userHostIp) as userHostIp ,count(*) as count from Y9logUserLoginInfo u where u.userHostIp LIKE ?1% AND tenantId =?2 group by u.userHostIp")
    public List<Map<String, Object>> findDistinctByUserHostIpLikeAndTenantId(String var1, String var2);

    @Query(value="select DISTINCT(u.userHostIp) as userHostIp ,count(*) as count from Y9logUserLoginInfo u where u.userId=?1 and u.loginTime>=?2 and u.loginTime<=?3 group by u.userHostIp")
    public List<Map<String, Object>> findDistinctUserHostIpByUserIdAndLoginTime(String var1, Date var2, Date var3);

    @Query(value="select userHostIp as userHostIp , count(userHostIp) as count from Y9logUserLoginInfo where userHostIp LIKE ?1% group by userHostIp")
    public List<Map<String, Object>> findDistinctUserHostIpCountByUserHostIpLike(String var1);

    @Query(value="select userHostIp as userHostIp , count(userHostIp) as count from Y9logUserLoginInfo where userHostIp LIKE ?1% AND tenantId =?2 group by userHostIp")
    public List<Map<String, Object>> findDistinctUserHostIpCountByUserHostIpLikeAndTenantId(String var1, String var2);

    public Y9logUserLoginInfo findTopByTenantIdAndUserIdOrderByLoginTimeDesc(String var1, String var2);
}

