/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util.form;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import javax.sql.DataSource;
import net.risesoft.repository.form.Y9TableFieldRepository;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DdlOracle {
    @Autowired
    private Y9TableFieldRepository y9TableFieldRepository = (Y9TableFieldRepository)Y9Context.getBean(Y9TableFieldRepository.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableColumn(DataSource dataSource, String tableName, List<DbColumn> dbcs) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Y9FormDbMetaDataUtil.checkTableExist((DataSource)dataSource, (String)tableName)) {
            for (DbColumn dbc : dbcs) {
                String columnName = dbc.getColumnName();
                if ("GUID".equalsIgnoreCase(columnName) || "PROCESSINSTANCEID".equalsIgnoreCase(columnName)) continue;
                sb = new StringBuilder();
                sb.append("ALTER TABLE \"" + tableName + "\"");
                String nullable = "";
                String dbColumnName = "";
                try (ResultSet rs = null;
                     Connection connection = dataSource.getConnection();){
                    DatabaseMetaData dbmd = connection.getMetaData();
                    String tableSchema = dbmd.getUserName().toUpperCase();
                    rs = dbmd.getColumns(null, tableSchema, tableName, dbc.getColumnName().toUpperCase());
                    while (rs.next()) {
                        nullable = rs.getString("is_nullable");
                        dbColumnName = rs.getString("column_name".toLowerCase());
                    }
                }
                boolean add = false;
                if ("".equals(dbColumnName) && StringUtils.isBlank((CharSequence)dbc.getColumnNameOld())) {
                    sb.append(" ADD " + dbc.getColumnName() + " ");
                    add = true;
                } else if (columnName.equalsIgnoreCase(dbc.getColumnNameOld()) || StringUtils.isBlank((CharSequence)dbc.getColumnNameOld())) {
                    sb.append(" MODIFY " + dbc.getColumnName() + " ");
                } else {
                    try {
                        StringBuilder sb1 = new StringBuilder();
                        sb1.append("ALTER TABLE \"" + tableName + "\"");
                        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb1.append(" RENAME COLUMN " + dbc.getColumnNameOld() + " TO " + dbc.getColumnName()).toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    sb.append(" MODIFY " + dbc.getColumnName() + " ");
                }
                String sType = dbc.getTypeName().toUpperCase();
                if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                    if (dbc.getDataScale() == null) {
                        sb.append(sType + "(" + dbc.getDataLength() + ")");
                    } else {
                        sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                    }
                } else {
                    sb.append(sType);
                }
                if ("".equals(nullable) && add) {
                    if (dbc.getNullable().booleanValue()) {
                        sb.append(" NULL");
                    } else {
                        sb.append(" NOT NULL");
                    }
                } else {
                    if (dbc.getNullable().booleanValue() && "NO".equals(nullable)) {
                        sb.append(" NULL");
                    }
                    if (!dbc.getNullable().booleanValue() && "YES".equals(nullable)) {
                        sb.append(" NOT NULL");
                    }
                }
                Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb.toString());
                if (org.springframework.util.StringUtils.hasText((String)dbc.getComment())) {
                    Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'"));
                }
                this.y9TableFieldRepository.updateOldFieldName(dbc.getTableName(), dbc.getColumnName());
            }
        }
    }

    public void alterTableColumn(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        DbColumn[] dbcs;
        if (!Y9FormDbMetaDataUtil.checkTableExist((DataSource)dataSource, (String)tableName)) {
            throw new Exception("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8fd9\u4e2a\u8868\uff1a" + tableName);
        }
        for (DbColumn dbc : dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class))) {
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getColumnNameOld())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE \"" + tableName + "\"");
            if (!dbc.getColumnName().equalsIgnoreCase(dbc.getColumnNameOld())) {
                try {
                    Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb.append(" RENAME COLUMN " + dbc.getColumnNameOld() + " TO " + dbc.getColumnName()).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sb.append(" MODIFY " + dbc.getColumnName() + " ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + ")");
            } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            List list = Y9FormDbMetaDataUtil.listAllColumns((DataSource)dataSource, (String)tableName, (String)dbc.getColumnNameOld());
            if (dbc.getNullable().booleanValue()) {
                if (!((DbColumn)list.get(0)).getNullable().booleanValue()) {
                    sb.append(" NULL");
                }
            } else if (((DbColumn)list.get(0)).getNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb.toString());
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getComment()) || ((DbColumn)list.get(0)).getComment().equals(dbc.getComment())) continue;
            Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'"));
        }
    }

    public void createTable(DataSource dataSource, String tableName, String jsonDbColumns) throws Exception {
        StringBuilder sb = new StringBuilder();
        DbColumn[] dbcs = (DbColumn[])Y9JsonUtil.objectMapper.readValue(jsonDbColumns, (JavaType)TypeFactory.defaultInstance().constructArrayType(DbColumn.class));
        sb.append("CREATE TABLE \"" + tableName + "\" (\r\n").append("GUID varchar2(38) NOT NULL, \r\n");
        for (DbColumn dbc : dbcs) {
            String columnName = dbc.getColumnName();
            if ("GUID".equalsIgnoreCase(columnName) || "PROCESSINSTANCEID".equalsIgnoreCase(columnName)) continue;
            sb.append(columnName).append(" ");
            String sType = dbc.getTypeName().toUpperCase();
            if ("CHAR".equals(sType) || "NCHAR".equals(sType) || "VARCHAR2".equals(sType) || "NVARCHAR2".equals(sType) || "RAW".equals(sType)) {
                sb.append(sType + "(" + dbc.getDataLength() + ")");
            } else if ("DECIMAL".equalsIgnoreCase(sType) || "NUMERIC".equalsIgnoreCase(sType) || "NUMBER".equalsIgnoreCase(sType)) {
                if (dbc.getDataScale() == null) {
                    sb.append(sType + "(" + dbc.getDataLength() + ")");
                } else {
                    sb.append(sType + "(" + dbc.getDataLength() + "," + dbc.getDataScale() + ")");
                }
            } else {
                sb.append(sType);
            }
            if (!dbc.getNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            sb.append(",\r\n");
        }
        sb.append("PRIMARY KEY (GUID) \r\n").append(")");
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)sb.toString());
        for (DbColumn dbc : dbcs) {
            if (!org.springframework.util.StringUtils.hasText((String)dbc.getComment())) continue;
            Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("COMMENT ON COLUMN \"" + tableName + "\"." + dbc.getColumnName().trim().toUpperCase() + " IS '" + dbc.getComment() + "'"));
        }
    }

    public void dropTable(DataSource dataSource, String tableName) throws Exception {
        if (Y9FormDbMetaDataUtil.checkTableExist((DataSource)dataSource, (String)tableName)) {
            Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("DROP TABLE \"" + tableName + "\""));
        }
    }

    public void dropTableColumn(DataSource dataSource, String tableName, String columnName) throws Exception {
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("ALTER TABLE \"" + tableName + "\" DROP COLUMN " + columnName));
    }

    public void renameTable(DataSource dataSource, String tableNameOld, String tableNameNew) throws Exception {
        Y9FormDbMetaDataUtil.executeDdl((DataSource)dataSource, (String)("RENAME \"" + tableNameOld + "\" TO \"" + tableNameNew + "\""));
    }
}

