/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageClassFinder {
    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            if ("file".equals(protocol)) {
                File directory = new File(resource.getFile());
                classes.addAll(PackageClassFinder.findClasses(directory, packageName));
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            String jarPath = resource.getPath().substring(5, resource.getPath().indexOf("!"));
            JarFile jar = new JarFile(jarPath);
            classes.addAll(PackageClassFinder.findClassesInJar(jar, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(PackageClassFinder.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    private static List<Class<?>> findClassesInJar(JarFile jar, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packageName.replace('.', '/')) || !name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            classes.add(Class.forName(className));
        }
        return classes;
    }

    public static void main(String[] args) {
        try {
            List<Class<?>> classes = PackageClassFinder.getClasses("com.example.package");
            for (Class<?> clazz : classes) {
                System.out.println(clazz.getName());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

