/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risesoft.y9.Y9Context;
import org.hibernate.annotations.Comment;

public class CommentUtil {
    private static final Pattern pattern = Pattern.compile("\r\n|\r|\n|\n\r");
    private static String comment;

    public static String[] getComment() {
        comment = Y9Context.getProperty((String)"y9.app.itemAdmin.comment");
        comment = CommentUtil.unicodeToCn(comment);
        return comment.split(",");
    }

    public static String replaceEnter2Br(String oldStr) {
        Matcher matcher = pattern.matcher(oldStr);
        String newstr = matcher.replaceAll("<br>");
        return newstr;
    }

    public static String unicodeToCn(String unicodeStr) {
        if (unicodeStr == null) {
            return null;
        }
        StringBuffer retBuf = new StringBuffer();
        int maxLoop = unicodeStr.length();
        for (int i = 0; i < maxLoop; ++i) {
            if (unicodeStr.charAt(i) == '\\') {
                boolean b;
                boolean bl = b = i < maxLoop - 5 && (unicodeStr.charAt(i + 1) == 'u' || unicodeStr.charAt(i + 1) == 'U');
                if (b) {
                    try {
                        retBuf.append((char)Integer.parseInt(unicodeStr.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException localNumberFormatException) {
                        retBuf.append(unicodeStr.charAt(i));
                    }
                    continue;
                }
                retBuf.append(unicodeStr.charAt(i));
                continue;
            }
            retBuf.append(unicodeStr.charAt(i));
        }
        return retBuf.toString();
    }

    public static List<Map<String, Object>> getEntityFieldList(Class<?> entityClass) {
        Field[] fields;
        ArrayList<Map<String, Object>> list_map = new ArrayList<Map<String, Object>>();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            System.out.println("\u5b57\u6bb5\u540d\u79f0: " + field.getName());
            Comment comment = field.getAnnotation(Comment.class);
            String fieldType = field.getType().getSimpleName();
            if (comment != null) {
                System.out.println("\u6ce8\u89e3\u503c: " + comment.value());
                map.put("fieldName", field.getName());
                map.put("fieldType", fieldType);
                map.put("comment", comment.value());
                list_map.add(map);
            } else {
                System.out.println("\u6ca1\u6709\u6ce8\u89e3");
            }
            field.setAccessible(true);
        }
        return list_map;
    }
}

