/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.listener;

import lombok.Generated;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.entity.DocumentCopy;
import net.risesoft.service.event.Y9TodoCreatedEvent;
import net.risesoft.service.event.Y9TodoDeletedEvent;
import net.risesoft.service.gfg.Todo3rdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ActRuDetailListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ActRuDetailListener.class);
    private final Todo3rdService todo3rdService;

    @TransactionalEventListener
    public void onTodoCreated(Y9TodoCreatedEvent<? extends ActRuDetail> event) {
        ActRuDetail actRuDetail = event.getEntity();
        this.todo3rdService.addTodo3rd(actRuDetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(actRuDetail.getAssigneeName() + "--\u65b0\u589e\u5f85\u529e");
        }
    }

    @TransactionalEventListener
    public void onTodoDeleted(Y9TodoDeletedEvent<? extends ActRuDetail> event) {
        ActRuDetail actRuDetail = event.getEntity();
        this.todo3rdService.deleteTodo3rd(actRuDetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(actRuDetail.getAssigneeName() + "--\u5220\u9664\u5f85\u529e");
        }
    }

    @TransactionalEventListener
    public void onTodoCreated4DocumentCopy(Y9TodoCreatedEvent<? extends DocumentCopy> event) {
        DocumentCopy documentCopy = event.getEntity();
        this.todo3rdService.addTodo3rd(documentCopy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(documentCopy.getUserName() + "--\u65b0\u589e\u4f1a\u7b7e\u5f85\u529e");
        }
    }

    @TransactionalEventListener
    public void onTodoDeleted4DocumentCopy(Y9TodoDeletedEvent<? extends DocumentCopy> event) {
        DocumentCopy documentCopy = event.getEntity();
        this.todo3rdService.deleteTodo3rd(documentCopy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(documentCopy.getUserName() + "--\u5220\u9664\u4f1a\u7b7e\u5f85\u529e");
        }
    }

    @Generated
    public ActRuDetailListener(Todo3rdService todo3rdService) {
        this.todo3rdService = todo3rdService;
    }
}

