/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.entity.DynamicRole;
import net.risesoft.entity.ItemPermission;
import net.risesoft.entity.ReceiveDepartment;
import net.risesoft.enums.DynamicRoleKindsEnum;
import net.risesoft.enums.ItemPermissionEnum;
import net.risesoft.enums.ItemPrincipalTypeEnum;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ItemRoleOrgUnitModel;
import net.risesoft.model.platform.CustomGroup;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Position;
import net.risesoft.repository.jpa.ReceiveDepartmentRepository;
import net.risesoft.service.DynamicRoleMemberService;
import net.risesoft.service.DynamicRoleService;
import net.risesoft.service.RoleService;
import net.risesoft.service.config.ItemPermissionService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    private final ItemPermissionService itemPermissionService;
    private final DynamicRoleMemberService dynamicRoleMemberService;
    private final DepartmentApi departmentApi;
    private final PositionRoleApi positionRoleApi;
    private final OrgUnitApi orgUnitApi;
    private final ReceiveDepartmentRepository receiveDepartmentRepository;
    private final CustomGroupApi customGroupApi;
    private final DynamicRoleService dynamicRoleService;

    @Override
    public List<ItemRoleOrgUnitModel> findByRoleId(String roleId, Integer principalType, String id) {
        List<ItemRoleOrgUnitModel> allItemList = new ArrayList<ItemRoleOrgUnitModel>();
        List<Object> itemList = new ArrayList();
        String tenantId = Y9LoginUserHolder.getTenantId();
        try {
            List orgList = (List)this.positionRoleApi.listPositionsByRoleId(tenantId, roleId).getData();
            for (Position position : orgList) {
                ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                itemRoleOrgUnitModel.setId(position.getId());
                itemRoleOrgUnitModel.setParentId(position.getParentId());
                itemRoleOrgUnitModel.setName(position.getName());
                itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(false));
                itemRoleOrgUnitModel.setOrgType(position.getOrgType().getValue());
                itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                itemRoleOrgUnitModel.setPerson("6:" + position.getId());
                itemRoleOrgUnitModel.setOrderedPath(position.getOrderedPath());
                itemRoleOrgUnitModel.setGuidPath(position.getGuidPath());
                if (itemList.contains(itemRoleOrgUnitModel)) continue;
                itemList.add(itemRoleOrgUnitModel);
            }
            itemList = itemList.stream().sorted().collect(Collectors.toList());
            ArrayList<String> parentIdList = new ArrayList<String>();
            for (ItemRoleOrgUnitModel itemRoleOrgUnitModel : itemList) {
                allItemList.add(itemRoleOrgUnitModel);
                if (parentIdList.contains(itemRoleOrgUnitModel.getParentId())) continue;
                allItemList = this.getParent(allItemList, itemRoleOrgUnitModel);
                parentIdList.add(itemRoleOrgUnitModel.getParentId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allItemList;
    }

    public List<ItemRoleOrgUnitModel> getParent(List<ItemRoleOrgUnitModel> itemList, ItemRoleOrgUnitModel model) {
        OrgUnit parent = (OrgUnit)this.orgUnitApi.getOrgUnit(Y9LoginUserHolder.getTenantId(), model.getParentId()).getData();
        if (parent.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
            Department department = (Department)parent;
            ItemRoleOrgUnitModel parentModel = new ItemRoleOrgUnitModel();
            parentModel.setId(parent.getId());
            parentModel.setParentId(parent.getParentId());
            parentModel.setName(StringUtils.isNotBlank((CharSequence)department.getAliasName()) ? department.getAliasName() : department.getName());
            parentModel.setIsParent(Boolean.valueOf(true));
            parentModel.setOrgType(parent.getOrgType().getValue());
            parentModel.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
            parentModel.setGuidPath(department.getGuidPath());
            if (!itemList.contains(parentModel)) {
                itemList.add(parentModel);
            }
            this.getParent(itemList, parentModel);
        }
        return itemList;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listAllPermUser(String itemId, String processDefinitionId, String taskDefKey, Integer principalType, String id, String processInstanceId, String taskId) {
        List<ItemRoleOrgUnitModel> allItemList;
        block26: {
            allItemList = new ArrayList<ItemRoleOrgUnitModel>();
            List<Object> itemList = new ArrayList();
            String tenantId = Y9LoginUserHolder.getTenantId();
            try {
                List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
                boolean p = ItemPrincipalTypeEnum.POSITION.getValue().equals(principalType);
                boolean d = ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType);
                if (StringUtils.isBlank((CharSequence)id)) {
                    ArrayList<OrgUnit> deptList = new ArrayList<OrgUnit>();
                    ArrayList<Position> positionList = new ArrayList<Position>();
                    for (ItemPermission itemPermission : list) {
                        if (itemPermission.getRoleType().equals(ItemPermissionEnum.DEPARTMENT.getValue()) && d) {
                            deptList.add((OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, itemPermission.getRoleId()).getData());
                        }
                        if (itemPermission.getRoleType().equals(ItemPermissionEnum.ROLE.getValue()) && p) {
                            positionList.addAll((Collection)this.positionRoleApi.listPositionsByRoleId(tenantId, itemPermission.getRoleId()).getData());
                        }
                        if (itemPermission.getRoleType().equals(ItemPermissionEnum.POSITION.getValue()) && p) {
                            positionList.add((Position)this.orgUnitApi.getOrgUnit(tenantId, itemPermission.getRoleId()).getData());
                        }
                        if (!itemPermission.getRoleType().equals(ItemPermissionEnum.DYNAMICROLE.getValue())) continue;
                        DynamicRole dynamicRole = this.dynamicRoleService.getById(itemPermission.getRoleId());
                        List<Object> pList = new ArrayList();
                        if (dynamicRole.getClassPath().contains("4SubProcess")) {
                            pList = this.dynamicRoleMemberService.listByDynamicRoleIdAndTaskId(dynamicRole, taskId);
                        } else if (null == dynamicRole.getKinds() || dynamicRole.getKinds().equals(DynamicRoleKindsEnum.NONE.getValue())) {
                            List<OrgUnit> orgUnitList1 = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                            for (OrgUnit orgUnit : orgUnitList1) {
                                if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                    pList.add((Position)orgUnit);
                                    continue;
                                }
                                if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) && !orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) continue;
                                deptList.add(orgUnit);
                            }
                        } else {
                            pList = this.dynamicRoleMemberService.listPositionByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                        }
                        for (Position position : pList) {
                            positionList.add(position);
                        }
                    }
                    for (Position position : positionList) {
                        ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                        itemRoleOrgUnitModel.setId(position.getId());
                        itemRoleOrgUnitModel.setParentId(position.getParentId());
                        itemRoleOrgUnitModel.setName(position.getName());
                        itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(false));
                        itemRoleOrgUnitModel.setOrgType(position.getOrgType().getValue());
                        itemRoleOrgUnitModel.setOrderedPath(position.getOrderedPath());
                        itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        itemRoleOrgUnitModel.setPerson("6:" + position.getId());
                        itemRoleOrgUnitModel.setGuidPath(position.getGuidPath());
                        if (itemList.contains(itemRoleOrgUnitModel)) continue;
                        itemList.add(itemRoleOrgUnitModel);
                    }
                    itemList = itemList.stream().sorted().collect(Collectors.toList());
                    ArrayList<String> parentIdList = new ArrayList<String>();
                    for (ItemRoleOrgUnitModel itemRoleOrgUnitModel : itemList) {
                        allItemList.add(itemRoleOrgUnitModel);
                        if (parentIdList.contains(itemRoleOrgUnitModel.getParentId())) continue;
                        allItemList = this.getParent(allItemList, itemRoleOrgUnitModel);
                        parentIdList.add(itemRoleOrgUnitModel.getParentId());
                    }
                    for (OrgUnit orgUnit : deptList) {
                        if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) {
                            List orgList = (List)this.orgUnitApi.getSubTree(tenantId, orgUnit.getId(), OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                            for (OrgUnit orgUnit2 : orgList) {
                                ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                                model.setId(orgUnit2.getId());
                                model.setParentId(orgUnit.getId());
                                if (orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                                    model.setName(StringUtils.isNotBlank((CharSequence)((Department)orgUnit2).getAliasName()) ? ((Department)orgUnit2).getAliasName() : orgUnit2.getName());
                                } else {
                                    model.setName(orgUnit2.getName());
                                }
                                model.setGuidPath(orgUnit2.getGuidPath());
                                model.setIsParent(Boolean.valueOf(orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                                model.setOrgType(orgUnit2.getOrgType().getValue());
                                model.setPrincipalType(orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                                if (orgUnit2.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                    model.setPerson("6:" + orgUnit2.getId());
                                }
                                if (allItemList.contains(model)) continue;
                                allItemList.add(model);
                            }
                            continue;
                        }
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(orgUnit.getId());
                        model.setParentId(orgUnit.getParentId());
                        model.setName(StringUtils.isNotBlank((CharSequence)((Department)orgUnit).getAliasName()) ? ((Department)orgUnit).getAliasName() : orgUnit.getName());
                        model.setIsParent(Boolean.valueOf(true));
                        model.setGuidPath(orgUnit.getGuidPath());
                        model.setOrgType(orgUnit.getOrgType().getValue());
                        model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                        if (allItemList.contains(model)) continue;
                        allItemList.add(model);
                    }
                    break block26;
                }
                List orgList = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                for (OrgUnit orgunit : orgList) {
                    ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                    String string = orgunit.getId();
                    itemRoleOrgUnitModel.setId(string);
                    itemRoleOrgUnitModel.setParentId(id);
                    itemRoleOrgUnitModel.setName(orgunit.getName());
                    itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(orgunit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                    itemRoleOrgUnitModel.setOrgType(orgunit.getOrgType().getValue());
                    itemRoleOrgUnitModel.setGuidPath(orgunit.getGuidPath());
                    if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                        itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                        itemRoleOrgUnitModel.setName(StringUtils.isNotBlank((CharSequence)((Department)orgunit).getAliasName()) ? ((Department)orgunit).getAliasName() : orgunit.getName());
                    } else if (OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) {
                        itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        itemRoleOrgUnitModel.setPerson("6:" + orgunit.getId());
                    }
                    if (itemList.contains(itemRoleOrgUnitModel)) continue;
                    itemList.add(itemRoleOrgUnitModel);
                }
                allItemList.addAll(itemList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allItemList;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listCsUser(String id, Integer principalType, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getPersonId();
        try {
            if (StringUtils.isBlank((CharSequence)id) || "null".equals(id)) {
                if (ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) {
                    Organization organization = (Organization)this.orgUnitApi.getOrganization(tenantId, userId).getData();
                    List orgUnitList = (List)this.orgUnitApi.getSubTree(tenantId, organization.getId(), OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                    for (OrgUnit orgUnit : orgUnitList) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(orgUnit.getId());
                        model.setParentId(id);
                        model.setName(orgUnit.getName());
                        model.setIsParent(Boolean.valueOf(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                        model.setOrgType(orgUnit.getOrgType().getValue());
                        model.setPrincipalType(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                        if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                            model.setPerson("6:" + orgUnit.getId());
                        }
                        item.add(model);
                    }
                } else {
                    List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, userId).getData();
                    for (CustomGroup customGroup : grouplist) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(customGroup.getId());
                        model.setParentId("");
                        model.setName(customGroup.getGroupName());
                        model.setIsParent(Boolean.valueOf(true));
                        model.setOrgType("customGroup");
                        model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                }
            } else if (ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) {
                List orgList = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                for (OrgUnit orgunit : orgList) {
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    String orgunitId = orgunit.getId();
                    model.setId(orgunitId);
                    model.setParentId(id);
                    model.setName(orgunit.getName());
                    model.setOrgType(orgunit.getOrgType().getValue());
                    model.setIsParent(Boolean.valueOf(orgunit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                    if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                        model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    } else if (OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) {
                        model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model.setPerson("6:" + orgunit.getId());
                    }
                    if (item.contains(model)) continue;
                    item.add(model);
                }
            } else {
                List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, userId, id, OrgTypeEnum.POSITION).getData();
                if (null != customGroupMemberList && !customGroupMemberList.isEmpty()) {
                    for (CustomGroupMember customGroupMember : customGroupMemberList) {
                        OrgUnit user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        if (user == null || user.getDisabled().booleanValue()) continue;
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(customGroupMember.getMemberId());
                        model.setParentId(id);
                        model.setName(user.getName());
                        model.setIsParent(Boolean.valueOf(false));
                        model.setOrgType(user.getOrgType().getValue());
                        model.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listCsUser4Bureau(String id) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        try {
            if (StringUtils.isBlank((CharSequence)id) || "null".equals(id)) {
                id = ((OrgUnit)this.orgUnitApi.getBureau(tenantId, Y9LoginUserHolder.getOrgUnit().getId()).getData()).getId();
            }
            List orgUnitList = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
            String finalId = id;
            orgUnitList.forEach(orgUnit -> {
                ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                model.setId(orgUnit.getId());
                model.setParentId(finalId);
                model.setName(orgUnit.getName());
                model.setIsParent(Boolean.valueOf(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                model.setOrgType(orgUnit.getOrgType().getValue());
                model.setPrincipalType(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                    model.setPerson("6:" + orgUnit.getId());
                }
                item.add(model);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listCsUserSearch(String name, Integer principalType, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item;
        block12: {
            String userId;
            String tenantId;
            block11: {
                tenantId = Y9LoginUserHolder.getTenantId();
                userId = Y9LoginUserHolder.getPersonId();
                item = new ArrayList<ItemRoleOrgUnitModel>();
                if (!ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) break block11;
                Organization organization = (Organization)this.orgUnitApi.getOrganization(tenantId, userId).getData();
                List deptList = (List)this.departmentApi.listByParentId(tenantId, organization.getId()).getData();
                ArrayList orgUnitListTemp = new ArrayList();
                for (OrgUnit orgUnitTemp : deptList) {
                    orgUnitListTemp.addAll((Collection)this.orgUnitApi.treeSearchByDn(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION, orgUnitTemp.getDn()).getData());
                }
                for (OrgUnit orgUnitTemp : orgUnitListTemp) {
                    boolean b;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(orgUnitTemp.getId());
                    model.setParentId(orgUnitTemp.getParentId());
                    model.setName(orgUnitTemp.getName());
                    model.setOrgType(orgUnitTemp.getOrgType().getValue());
                    if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                        model.setIsParent(Boolean.valueOf(true));
                    } else {
                        if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) {
                            model.setIsParent(Boolean.valueOf(true));
                            continue;
                        }
                        if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                            model.setPerson("6:" + orgUnitTemp.getId());
                            model.setIsParent(Boolean.valueOf(true));
                        } else if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.PERSON) || orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.GROUP)) continue;
                    }
                    if (b = item.contains(model)) continue;
                    item.add(model);
                }
                break block12;
            }
            if (!ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) break block12;
            try {
                List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, userId).getData();
                for (CustomGroup customGroup : grouplist) {
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(customGroup.getId());
                    model.setParentId("");
                    model.setName(customGroup.getGroupName());
                    model.setOrgType("customGroup");
                    model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                    model.setIsParent(Boolean.valueOf(true));
                    if (item.contains(model)) continue;
                    boolean b = false;
                    List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, userId, customGroup.getId(), OrgTypeEnum.POSITION).getData();
                    if (null == customGroupMemberList || customGroupMemberList.isEmpty()) continue;
                    for (CustomGroupMember customGroupMember : customGroupMemberList) {
                        OrgUnit user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        if (user == null || !user.getName().contains(name) || user.getDisabled().booleanValue()) continue;
                        ItemRoleOrgUnitModel model0 = new ItemRoleOrgUnitModel();
                        model0.setIsParent(Boolean.valueOf(false));
                        model0.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model0.setId(customGroupMember.getMemberId());
                        model0.setOrgType(user.getOrgType().getValue());
                        model0.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model0.setName(user.getName());
                        model0.setParentId(customGroup.getId());
                        if (item.contains(model0)) continue;
                        item.add(model0);
                        b = true;
                    }
                    if (!b || item.contains(model)) continue;
                    item.add(model);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUser(String itemId, String processDefinitionId, String taskDefKey, Integer principalType, String id, String processInstanceId) {
        List<ItemRoleOrgUnitModel> allItemList;
        block31: {
            allItemList = new ArrayList<ItemRoleOrgUnitModel>();
            List<Object> itemList = new ArrayList();
            String tenantId = Y9LoginUserHolder.getTenantId();
            try {
                List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
                boolean p = ItemPrincipalTypeEnum.POSITION.getValue().equals(principalType);
                boolean d = ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType);
                if (p || d) {
                    if (StringUtils.isBlank((CharSequence)id)) {
                        ArrayList<OrgUnit> deptList = new ArrayList<OrgUnit>();
                        ArrayList<Position> positionList = new ArrayList<Position>();
                        for (ItemPermission itemPermission : list) {
                            if (Objects.equals(itemPermission.getRoleType(), ItemPermissionEnum.DEPARTMENT.getValue()) && d) {
                                deptList.add((OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, itemPermission.getRoleId()).getData());
                            }
                            if (Objects.equals(itemPermission.getRoleType(), ItemPermissionEnum.ROLE.getValue()) && p) {
                                positionList.addAll((Collection)this.positionRoleApi.listPositionsByRoleId(tenantId, itemPermission.getRoleId()).getData());
                            }
                            if (itemPermission.getRoleType().equals(ItemPermissionEnum.POSITION.getValue()) && p) {
                                positionList.add((Position)this.orgUnitApi.getOrgUnit(tenantId, itemPermission.getRoleId()).getData());
                            }
                            if (!Objects.equals(itemPermission.getRoleType(), ItemPermissionEnum.DYNAMICROLE.getValue())) continue;
                            DynamicRole dynamicRole = this.dynamicRoleService.getById(itemPermission.getRoleId());
                            List<Object> pList = new ArrayList();
                            if (null == dynamicRole.getKinds() || dynamicRole.getKinds().equals(DynamicRoleKindsEnum.NONE.getValue())) {
                                List<OrgUnit> orgUnitList1 = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                                for (OrgUnit orgUnit : orgUnitList1) {
                                    if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                        pList.add((Position)orgUnit);
                                        continue;
                                    }
                                    if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) && !orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) continue;
                                    deptList.add(orgUnit);
                                }
                            } else {
                                pList = this.dynamicRoleMemberService.listPositionByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                            }
                            for (Position position : pList) {
                                positionList.add(position);
                            }
                        }
                        for (Position position : positionList) {
                            ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                            itemRoleOrgUnitModel.setId(position.getId());
                            itemRoleOrgUnitModel.setParentId(position.getParentId());
                            itemRoleOrgUnitModel.setName(position.getName());
                            itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(false));
                            itemRoleOrgUnitModel.setOrgType(position.getOrgType().getValue());
                            itemRoleOrgUnitModel.setOrderedPath(position.getOrderedPath());
                            itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                            itemRoleOrgUnitModel.setPerson("6:" + position.getId());
                            itemRoleOrgUnitModel.setGuidPath(position.getGuidPath());
                            if (itemList.contains(itemRoleOrgUnitModel)) continue;
                            itemList.add(itemRoleOrgUnitModel);
                        }
                        itemList = itemList.stream().sorted().collect(Collectors.toList());
                        ArrayList<String> parentIdList = new ArrayList<String>();
                        for (ItemRoleOrgUnitModel itemRoleOrgUnitModel : itemList) {
                            allItemList.add(itemRoleOrgUnitModel);
                            if (parentIdList.contains(itemRoleOrgUnitModel.getParentId())) continue;
                            allItemList = this.getParent(allItemList, itemRoleOrgUnitModel);
                            parentIdList.add(itemRoleOrgUnitModel.getParentId());
                        }
                        for (OrgUnit orgUnit : deptList) {
                            if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) {
                                List orgList = (List)this.orgUnitApi.getSubTree(tenantId, orgUnit.getId(), OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                                for (OrgUnit orgUnit2 : orgList) {
                                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                                    model.setId(orgUnit2.getId());
                                    model.setParentId(orgUnit.getId());
                                    if (orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                                        model.setName(StringUtils.isNotBlank((CharSequence)((Department)orgUnit2).getAliasName()) ? ((Department)orgUnit2).getAliasName() : orgUnit2.getName());
                                    } else {
                                        model.setName(orgUnit2.getName());
                                    }
                                    model.setGuidPath(orgUnit2.getGuidPath());
                                    model.setIsParent(Boolean.valueOf(orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                                    model.setOrgType(orgUnit2.getOrgType().getValue());
                                    model.setPrincipalType(orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                                    if (orgUnit2.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                        model.setPerson("6:" + orgUnit2.getId());
                                    }
                                    if (allItemList.contains(model)) continue;
                                    allItemList.add(model);
                                }
                                continue;
                            }
                            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                            model.setId(orgUnit.getId());
                            model.setParentId(orgUnit.getParentId());
                            model.setName(StringUtils.isNotBlank((CharSequence)((Department)orgUnit).getAliasName()) ? ((Department)orgUnit).getAliasName() : orgUnit.getName());
                            model.setIsParent(Boolean.valueOf(true));
                            model.setOrgType(orgUnit.getOrgType().getValue());
                            model.setGuidPath(orgUnit.getGuidPath());
                            model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                            if (allItemList.contains(model)) continue;
                            allItemList.add(model);
                        }
                        break block31;
                    }
                    List orgList = (List)this.orgUnitApi.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                    for (OrgUnit orgunit : orgList) {
                        ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                        String string = orgunit.getId();
                        itemRoleOrgUnitModel.setId(string);
                        itemRoleOrgUnitModel.setParentId(id);
                        itemRoleOrgUnitModel.setName(orgunit.getName());
                        itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(orgunit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                        itemRoleOrgUnitModel.setOrgType(orgunit.getOrgType().getValue());
                        itemRoleOrgUnitModel.setGuidPath(orgunit.getGuidPath());
                        if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                            itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                        } else if (OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) {
                            itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                            itemRoleOrgUnitModel.setPerson("6:" + orgunit.getId());
                        }
                        if (allItemList.contains(itemRoleOrgUnitModel)) continue;
                        allItemList.add(itemRoleOrgUnitModel);
                    }
                    break block31;
                }
                if (ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) {
                    List customGrouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId()).getData();
                    if (StringUtils.isBlank((CharSequence)id)) {
                        for (CustomGroup customGroup : customGrouplist) {
                            ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                            itemRoleOrgUnitModel.setId(customGroup.getId());
                            itemRoleOrgUnitModel.setParentId("");
                            itemRoleOrgUnitModel.setName(customGroup.getGroupName());
                            itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(true));
                            itemRoleOrgUnitModel.setOrgType("customGroup");
                            itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                            if (allItemList.contains(itemRoleOrgUnitModel)) continue;
                            allItemList.add(itemRoleOrgUnitModel);
                        }
                    } else {
                        List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), id, OrgTypeEnum.POSITION).getData();
                        if (null != customGroupMemberList && !customGroupMemberList.isEmpty()) {
                            for (CustomGroupMember customGroupMember : customGroupMemberList) {
                                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                                if (orgUnit == null || orgUnit.getDisabled().booleanValue()) continue;
                                ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                                model.setId(customGroupMember.getMemberId());
                                model.setParentId(id);
                                model.setName(orgUnit.getName());
                                model.setIsParent(Boolean.valueOf(false));
                                model.setOrgType(orgUnit.getOrgType().getValue());
                                model.setPerson("6:" + orgUnit.getId());
                                model.setGuidPath(orgUnit.getGuidPath());
                                model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                                if (allItemList.contains(model)) continue;
                                allItemList.add(model);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allItemList;
    }

    @Override
    public List<OrgUnit> listPermUser4SUbmitTo(String itemId, String processDefinitionId, String taskDefKey, String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<OrgUnit> orgList = new ArrayList<OrgUnit>();
        try {
            ArrayList<OrgUnit> orgListTemp = new ArrayList<OrgUnit>();
            List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
            for (ItemPermission o : list) {
                if (o.getRoleType() == 1) {
                    orgListTemp.addAll((Collection)this.positionRoleApi.listPositionsByRoleId(tenantId, o.getRoleId()).getData());
                }
                if (o.getRoleType() == 4) {
                    DynamicRole dynamicRole = this.dynamicRoleService.getById(o.getRoleId());
                    List<Object> pList = new ArrayList();
                    if (null == dynamicRole.getKinds() || dynamicRole.getKinds().equals(DynamicRoleKindsEnum.NONE.getValue())) {
                        List<OrgUnit> orgUnitList1 = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                        for (OrgUnit orgUnit : orgUnitList1) {
                            if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                pList.add((Position)orgUnit);
                                continue;
                            }
                            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
                        }
                    } else {
                        pList = this.dynamicRoleMemberService.listPositionByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                    }
                    for (OrgUnit orgUnit : pList) {
                        if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                        orgListTemp.add(orgUnit);
                    }
                }
                if (o.getRoleType() != 6) continue;
                orgListTemp.add((OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, o.getRoleId()).getData());
            }
            for (OrgUnit orgUnit : orgListTemp) {
                if (orgList.contains(orgUnit)) continue;
                orgList.add(orgUnit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgList;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUserByName(String name, String itemId, String processDefinitionId, String taskDefKey, Integer principalType, String processInstanceId) {
        List<ItemRoleOrgUnitModel> allItemList;
        block19: {
            String tenantId;
            block18: {
                tenantId = Y9LoginUserHolder.getTenantId();
                List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
                allItemList = new ArrayList<ItemRoleOrgUnitModel>();
                List<Object> itemList = new ArrayList();
                boolean p = ItemPrincipalTypeEnum.POSITION.getValue().equals(principalType);
                boolean d = ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType);
                if (!p && !d) break block18;
                ArrayList<Object> deptList = new ArrayList<Object>();
                ArrayList<Position> positionList = new ArrayList<Position>();
                for (ItemPermission itemPermission : list) {
                    Department department;
                    if (itemPermission.getRoleType() == 1 && p) {
                        positionList.addAll((Collection)this.positionRoleApi.listPositionsByRoleId(tenantId, itemPermission.getRoleId()).getData());
                    }
                    if (itemPermission.getRoleType().equals(ItemPermissionEnum.POSITION.getValue()) && p) {
                        positionList.add((Position)this.orgUnitApi.getOrgUnit(tenantId, itemPermission.getRoleId()).getData());
                    }
                    if (itemPermission.getRoleType() == 2 && d && (department = (Department)this.departmentApi.get(tenantId, itemPermission.getRoleId()).getData()) != null) {
                        deptList.add(department);
                    }
                    if (itemPermission.getRoleType() != 4) continue;
                    DynamicRole dynamicRole = this.dynamicRoleService.getById(itemPermission.getRoleId());
                    List<Object> pList = new ArrayList();
                    if (null == dynamicRole.getKinds() || dynamicRole.getKinds().equals(DynamicRoleKindsEnum.NONE.getValue())) {
                        List<OrgUnit> orgUnitList1 = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                        for (OrgUnit orgUnit : orgUnitList1) {
                            if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                pList.add((Position)orgUnit);
                                continue;
                            }
                            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) && !orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) continue;
                            deptList.add(orgUnit);
                        }
                    } else {
                        pList = this.dynamicRoleMemberService.listPositionByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                    }
                    for (Position position : pList) {
                        positionList.add(position);
                    }
                }
                for (Position position : positionList) {
                    ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                    itemRoleOrgUnitModel.setId(position.getId());
                    itemRoleOrgUnitModel.setParentId(position.getParentId());
                    itemRoleOrgUnitModel.setName(position.getName());
                    itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(false));
                    itemRoleOrgUnitModel.setOrgType(position.getOrgType().getValue());
                    itemRoleOrgUnitModel.setOrderedPath(position.getOrderedPath());
                    itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                    itemRoleOrgUnitModel.setPerson("6:" + position.getId());
                    itemRoleOrgUnitModel.setGuidPath(position.getGuidPath());
                    if (!position.getName().contains(name) || itemList.contains(itemRoleOrgUnitModel)) continue;
                    itemList.add(itemRoleOrgUnitModel);
                }
                itemList = itemList.stream().sorted().collect(Collectors.toList());
                ArrayList<String> parentIdList = new ArrayList<String>();
                for (ItemRoleOrgUnitModel itemRoleOrgUnitModel : itemList) {
                    allItemList.add(itemRoleOrgUnitModel);
                    if (parentIdList.contains(itemRoleOrgUnitModel.getParentId())) continue;
                    allItemList = this.getParent(allItemList, itemRoleOrgUnitModel);
                    parentIdList.add(itemRoleOrgUnitModel.getParentId());
                }
                for (OrgUnit orgUnit : deptList) {
                    ArrayList orgUnitList = new ArrayList();
                    orgUnitList.addAll((Collection)this.orgUnitApi.treeSearchByDn(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION, orgUnit.getDn()).getData());
                    for (OrgUnit orgUnit2 : orgUnitList) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(orgUnit2.getId());
                        model.setName(orgUnit2.getName());
                        model.setOrgType(orgUnit2.getOrgType().getValue());
                        model.setParentId(orgUnit2.getParentId());
                        model.setGuidPath(orgUnit2.getGuidPath());
                        if (orgUnit2.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                            model.setIsParent(Boolean.valueOf(true));
                            if (allItemList.contains(model)) continue;
                            allItemList.add(model);
                            continue;
                        }
                        if (!orgUnit2.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                        model.setIsParent(Boolean.valueOf(false));
                        model.setPerson("6:" + orgUnit2.getId());
                        if (allItemList.contains(model)) continue;
                        allItemList.add(model);
                    }
                }
                break block19;
            }
            if (!ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) break block19;
            try {
                List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId()).getData();
                for (CustomGroup customGroup : grouplist) {
                    ItemRoleOrgUnitModel itemRoleOrgUnitModel = new ItemRoleOrgUnitModel();
                    itemRoleOrgUnitModel.setId(customGroup.getId());
                    itemRoleOrgUnitModel.setName(customGroup.getGroupName());
                    itemRoleOrgUnitModel.setOrgType("customGroup");
                    itemRoleOrgUnitModel.setParentId("");
                    itemRoleOrgUnitModel.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                    itemRoleOrgUnitModel.setIsParent(Boolean.valueOf(true));
                    if (allItemList.contains(itemRoleOrgUnitModel)) continue;
                    boolean bl = false;
                    List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), customGroup.getId(), OrgTypeEnum.POSITION).getData();
                    if (null == customGroupMemberList || customGroupMemberList.isEmpty()) continue;
                    for (CustomGroupMember customGroupMember : customGroupMemberList) {
                        OrgUnit user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        if (user == null || !user.getName().contains(name) || user.getDisabled().booleanValue()) continue;
                        ItemRoleOrgUnitModel model1 = new ItemRoleOrgUnitModel();
                        model1.setId(customGroupMember.getMemberId());
                        model1.setName(user.getName());
                        model1.setOrgType(user.getOrgType().getValue());
                        model1.setParentId(customGroup.getId());
                        model1.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model1.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model1.setIsParent(Boolean.valueOf(false));
                        itemRoleOrgUnitModel.setGuidPath(user.getGuidPath());
                        if (allItemList.contains(model1)) continue;
                        allItemList.add(model1);
                        bl = true;
                    }
                    if (!bl || allItemList.contains(itemRoleOrgUnitModel)) continue;
                    allItemList.add(itemRoleOrgUnitModel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allItemList;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUserSendReceive(String id) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                List list = this.receiveDepartmentRepository.findAll();
                for (ReceiveDepartment receiveDepartment : list) {
                    Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                    if (department == null || department.getId() == null) continue;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(receiveDepartment.getDeptId());
                    model.setName(department.getName());
                    model.setOrgType(OrgTypeEnum.DEPARTMENT.getEnName());
                    model.setParentId(receiveDepartment.getParentId());
                    model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                    model.setIsParent(Boolean.valueOf(count > 0));
                    item.add(model);
                }
            } else {
                List list = this.receiveDepartmentRepository.findByParentIdOrderByTabIndex(id);
                for (ReceiveDepartment receiveDepartment : list) {
                    Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                    if (department == null || department.getId() == null) continue;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(receiveDepartment.getDeptId());
                    model.setName(department.getName());
                    model.setOrgType(OrgTypeEnum.DEPARTMENT.getEnName());
                    model.setParentId(receiveDepartment.getParentId());
                    model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                    model.setIsParent(Boolean.valueOf(count > 0));
                    item.add(model);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    @Generated
    public RoleServiceImpl(ItemPermissionService itemPermissionService, DynamicRoleMemberService dynamicRoleMemberService, DepartmentApi departmentApi, PositionRoleApi positionRoleApi, OrgUnitApi orgUnitApi, ReceiveDepartmentRepository receiveDepartmentRepository, CustomGroupApi customGroupApi, DynamicRoleService dynamicRoleService) {
        this.itemPermissionService = itemPermissionService;
        this.dynamicRoleMemberService = dynamicRoleMemberService;
        this.departmentApi = departmentApi;
        this.positionRoleApi = positionRoleApi;
        this.orgUnitApi = orgUnitApi;
        this.receiveDepartmentRepository = receiveDepartmentRepository;
        this.customGroupApi = customGroupApi;
        this.dynamicRoleService = dynamicRoleService;
    }
}

