/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.CalendarConfigApi;
import net.risesoft.model.itemadmin.CalendarConfigModel;
import net.risesoft.service.ItemWorkDayService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemWorkDayServiceImpl
implements ItemWorkDayService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemWorkDayServiceImpl.class);
    private final CalendarConfigApi calendarConfigApi;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy");

    public int daysBetween(Date startDate, Date endDate) {
        long days = 0L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date startDateTemp = sdf.parse(sdf.format(startDate));
            Date endDateTemp = sdf.parse(sdf.format(endDate));
            long difference = (endDateTemp.getTime() - startDateTemp.getTime()) / 86400000L;
            days = Math.abs(difference) + 1L;
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        return (int)days;
    }

    public int daysBetween(Date startDate, Date endDate, String everyYearHoliday) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int days = 0;
        Calendar cal = Calendar.getInstance();
        Date startDateTemp = sdf.parse(sdf.format(startDate));
        Date endDateTemp = sdf.parse(sdf.format(endDate));
        while (startDateTemp.compareTo(endDateTemp) != 1) {
            cal.setTime(startDateTemp);
            String time1 = sdf.format(startDateTemp);
            if (everyYearHoliday.contains(time1)) {
                cal.add(5, 1);
                startDateTemp = sdf.parse(sdf.format(cal.getTime()));
                continue;
            }
            ++days;
            cal.add(5, 1);
            startDateTemp = sdf.parse(sdf.format(cal.getTime()));
        }
        return days;
    }

    @Override
    public int getDay(Date startDate, Date endDate) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        int days = -1;
        try {
            if (null != startDate && null != endDate) {
                CalendarConfigModel calendarConfigModel = (CalendarConfigModel)this.calendarConfigApi.findByYear(tenantId, this.sdf.format(startDate)).getData();
                String everyYearHoliday = calendarConfigModel.getEveryYearHoliday();
                days = StringUtils.isNotBlank((CharSequence)everyYearHoliday) ? this.daysBetween(startDate, endDate, everyYearHoliday) : this.daysBetween(startDate, endDate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return days;
    }

    @Override
    public String getDate(Date date, int days) throws ParseException {
        SimpleDateFormat sdfMmd = new SimpleDateFormat("yyyy-MM-dd");
        if (days <= 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            date = sdfMmd.parse(sdfMmd.format(cal.getTime()));
            return sdfMmd.format(date);
        }
        Calendar cal = Calendar.getInstance();
        CalendarConfigModel calendarConfigModel = (CalendarConfigModel)this.calendarConfigApi.findByYear(Y9LoginUserHolder.getTenantId(), this.sdf.format(date)).getData();
        String everyYearHoliday = calendarConfigModel.getEveryYearHoliday();
        String endDate = "";
        if (StringUtils.isNotBlank((CharSequence)everyYearHoliday)) {
            int i = 1;
            while (i < days) {
                String startDateString = sdfMmd.format(date);
                if (!everyYearHoliday.contains(startDateString)) {
                    ++i;
                }
                cal.setTime(date);
                cal.add(5, 1);
                date = sdfMmd.parse(sdfMmd.format(cal.getTime()));
            }
            endDate = sdfMmd.format(date);
        }
        return endDate;
    }

    @Override
    public List<String> getDb(int days) {
        Date currentDate = new Date();
        String endDate = "";
        String startDate = "";
        try {
            endDate = this.getDate(currentDate, days);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            switch (days) {
                case 3: {
                    startDate = sdf.format(currentDate);
                    break;
                }
                case 5: {
                    startDate = this.getDate(currentDate, 4);
                    break;
                }
                case 7: {
                    startDate = this.getDate(currentDate, 6);
                    break;
                }
                case 10: {
                    startDate = this.getDate(currentDate, 8);
                    break;
                }
                default: {
                    startDate = "2025-01-01";
                    break;
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        return List.of(startDate, endDate);
    }

    @Generated
    public ItemWorkDayServiceImpl(CalendarConfigApi calendarConfigApi) {
        this.calendarConfigApi = calendarConfigApi;
    }
}

