/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import net.risesoft.api.itemadmin.extend.ItemTodoTaskApi;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.platform.permission.PositionResourceApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.platform.resource.AppApi;
import net.risesoft.api.processadmin.ConditionParserApi;
import net.risesoft.api.processadmin.HistoricActivityApi;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.api.processadmin.IdentityApi;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.api.processadmin.ProcessTodoApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.api.processadmin.VariableApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.entity.DynamicRole;
import net.risesoft.entity.ErrorLog;
import net.risesoft.entity.ItemButtonBind;
import net.risesoft.entity.ItemPermission;
import net.risesoft.entity.ItemPrintTemplateBind;
import net.risesoft.entity.ItemTaskConf;
import net.risesoft.entity.ProcessParam;
import net.risesoft.entity.SignDeptDetail;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.TaskVariable;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.Y9FormItemMobileBind;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.enums.DynamicRoleKindsEnum;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.enums.ItemButtonTypeEnum;
import net.risesoft.enums.ItemPermissionEnum;
import net.risesoft.enums.SignDeptDetailStatusEnum;
import net.risesoft.enums.SignStatusEnum;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.DocUserChoiseModel;
import net.risesoft.model.itemadmin.DocumentDetailModel;
import net.risesoft.model.itemadmin.ItemButtonModel;
import net.risesoft.model.itemadmin.ItemFormModel;
import net.risesoft.model.itemadmin.ItemListModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.itemadmin.SignDeptDetailModel;
import net.risesoft.model.itemadmin.SignTaskConfigModel;
import net.risesoft.model.itemadmin.StartProcessResultModel;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Resource;
import net.risesoft.model.processadmin.FlowElementModel;
import net.risesoft.model.processadmin.HistoricActivityInstanceModel;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.nosql.elastic.entity.OfficeDoneInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.repository.jpa.ItemTaskConfRepository;
import net.risesoft.repository.jpa.PrintTemplateItemBindRepository;
import net.risesoft.repository.jpa.SpmApproveItemRepository;
import net.risesoft.repository.jpa.TaskVariableRepository;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.service.AsyncHandleService;
import net.risesoft.service.DocumentService;
import net.risesoft.service.DynamicRoleMemberService;
import net.risesoft.service.DynamicRoleService;
import net.risesoft.service.ErrorLogService;
import net.risesoft.service.OfficeDoneInfoService;
import net.risesoft.service.Process4SearchService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.service.RoleService;
import net.risesoft.service.SignDeptDetailService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemButtonBindService;
import net.risesoft.service.config.ItemPermissionService;
import net.risesoft.service.config.ItemStartNodeRoleService;
import net.risesoft.service.config.ItemTaskConfService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.service.form.Y9FormService;
import net.risesoft.service.impl.ActivitiOptServiceImpl;
import net.risesoft.util.ButtonUtil;
import net.risesoft.util.CommonOpt;
import net.risesoft.util.ItemButton;
import net.risesoft.util.ListUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private final ActivitiOptServiceImpl activitiOptService;
    private final SpmApproveItemService spmApproveitemService;
    private final SpmApproveItemRepository spmApproveitemRepository;
    private final ItemTaskConfService taskConfService;
    private final ItemPermissionService itemPermissionService;
    private final Y9FormItemBindService y9FormItemBindService;
    private final ItemButtonBindService buttonItemBindService;
    private final ItemTodoTaskApi todoTaskApi;
    private final TaskApi taskApi;
    private final CustomGroupApi customGroupApi;
    private final ProcessDefinitionApi processDefinitionApi;
    private final VariableApi variableApi;
    private final OrgUnitApi orgUnitApi;
    private final RepositoryApi repositoryApi;
    private final PositionApi positionApi;
    private final RoleApi roleApi;
    private final PositionRoleApi positionRoleApi;
    private final DepartmentApi departmentApi;
    private final PositionResourceApi positionResourceApi;
    private final HistoricProcessApi historicProcessApi;
    private final HistoricTaskApi historictaskApi;
    private final RuntimeApi runtimeApi;
    private final ProcessParamService processParamService;
    private final ProcessTodoApi processTodoApi;
    private final PrintTemplateItemBindRepository printTemplateItemBindRepository;
    private final OfficeDoneInfoService officeDoneInfoService;
    private final TaskVariableRepository taskVariableRepository;
    private final AsyncHandleService asyncHandleService;
    private final Y9FormRepository y9FormRepository;
    private final Process4SearchService process4SearchService;
    private final ErrorLogService errorLogService;
    private final ItemStartNodeRoleService itemStartNodeRoleService;
    private final ItemTaskConfRepository taskConfRepository;
    private final DynamicRoleMemberService dynamicRoleMemberService;
    private final DynamicRoleService dynamicRoleService;
    private final ConditionParserApi conditionParserApi;
    private final Y9FormService y9FormService;
    private final RoleService roleService;
    private final HistoricActivityApi historicActivityApi;
    private final ActRuDetailService actRuDetailService;
    private final SignDeptDetailService signDeptDetailService;
    private final IdentityApi identityApi;
    private final AppApi appApi;

    @Override
    public OpenDataModel add(String itemId, boolean mobile) {
        String userId = Y9LoginUserHolder.getOrgUnitId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        OpenDataModel model = new OpenDataModel();
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            SpmApproveItem item = this.spmApproveitemService.findById(itemId);
            model.setItemId(itemId);
            model.setProcessDefinitionKey(item.getWorkflowGuid());
            String processDefinitionKey = item.getWorkflowGuid();
            ProcessDefinitionModel pdModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
            String processDefinitionId = pdModel.getId();
            String taskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            model = this.genDocumentModel(itemId, processDefinitionKey, "", taskDefKey, mobile, model);
            model = this.menuControl(itemId, processDefinitionId, taskDefKey, "", model, ItemBoxTypeEnum.ADD.getValue());
            model.setProcessDefinitionId(processDefinitionId);
            model.setTaskDefKey(taskDefKey);
            model.setActivitiUser(userId);
            model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
            model.setItembox(ItemBoxTypeEnum.ADD.getValue());
            model.setProcessSerialNumber(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            model.setProcessInstanceId("");
        }
        return model;
    }

    private String addUserId(String userIds, String userId) {
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            if (!((String)userIds).contains(userId)) {
                userIds = (String)userIds + ";" + userId;
            }
        } else {
            userIds = userId;
        }
        return userIds;
    }

    @Override
    public DocumentDetailModel addWithStartTaskDefKey(String itemId, String startTaskDefKey, boolean mobile) {
        String userId = Y9LoginUserHolder.getOrgUnitId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        DocumentDetailModel model = new DocumentDetailModel();
        SpmApproveItem item = this.spmApproveitemService.findById(itemId);
        model.setItemId(itemId);
        model.setProcessDefinitionKey(item.getWorkflowGuid());
        String processDefinitionKey = item.getWorkflowGuid();
        ProcessDefinitionModel pdModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
        String processDefinitionId = pdModel.getId();
        model.setItembox(ItemBoxTypeEnum.ADD.getValue());
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, startTaskDefKey, false, model);
        model = this.menuControl4Add(itemId, processDefinitionId, startTaskDefKey, model);
        model.setProcessDefinitionId(processDefinitionId);
        model.setTaskDefKey(startTaskDefKey);
        model.setActivitiUser(userId);
        model.setStartor(userId);
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        model.setProcessInstanceId("");
        return model;
    }

    @Override
    public void complete(String taskId) throws Exception {
        String tenantId = Y9LoginUserHolder.getTenantId();
        TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
        String processInstanceId = task.getProcessInstanceId();
        this.runtimeApi.complete(tenantId, Y9LoginUserHolder.getOrgUnitId(), processInstanceId, taskId);
    }

    @Override
    public void completeSub(String taskId, List<String> userList) throws Exception {
        String tenantId = Y9LoginUserHolder.getTenantId();
        this.runtimeApi.completeSub(tenantId, Y9LoginUserHolder.getOrgUnitId(), taskId, userList);
    }

    @Override
    public DocUserChoiseModel docUserChoise(String itemId, String processDefinitionKey, String processDefinitionId, String taskId, String taskDefKey, String processInstanceId) {
        Y9Page pageList;
        ItemTaskConf itemTaskConf;
        DocUserChoiseModel model = new DocUserChoiseModel();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String multiInstance = (String)this.processDefinitionApi.getNodeType(tenantId, processDefinitionId, taskDefKey).getData();
        Map<String, Object> tabMap = this.itemPermissionService.getTabMap(itemId, processDefinitionId, taskDefKey, processInstanceId, taskId);
        model.setExistDepartment(((Boolean)tabMap.get("existDepartment")).booleanValue());
        model.setExistPosition(((Boolean)tabMap.get("existPosition")).booleanValue());
        model.setSignTask(false);
        if ("common".equals(multiInstance) && (itemTaskConf = this.taskConfRepository.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey)) != null && itemTaskConf.getSignTask().booleanValue()) {
            model.setSignTask(true);
        }
        model.setExistCustomGroup((pageList = this.customGroupApi.pageCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId(), new Y9PageQuery(Integer.valueOf(1), Integer.valueOf(1)))) != null && pageList.getTotal() > 0L);
        model.setMultiInstance(multiInstance);
        model.setProcessDefinitionId(processDefinitionId);
        model.setTenantId(tenantId);
        model.setItemId(itemId);
        model.setRouteToTask(taskDefKey);
        boolean isSubProcess = (Boolean)this.processDefinitionApi.isSubProcess(tenantId, processDefinitionId, taskDefKey).getData();
        model.setType(isSubProcess ? "SubProcess" : "UserTask");
        model.setSponsorStatus(false);
        if ("parallel".equals(multiInstance)) {
            boolean sponsorStatus = this.taskConfService.getSponserStatus(itemId, processDefinitionId, taskDefKey);
            model.setSponsorStatus(sponsorStatus);
        }
        return model;
    }

    @Override
    public OpenDataModel edit(String itembox, String taskId, String processInstanceId, String itemId, boolean mobile) {
        OpenDataModel model = new OpenDataModel();
        String processSerialNumber = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activitiUser = "";
        String itemboxStr = itembox;
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (ItemBoxTypeEnum.MONITOR_DOING.getValue().equals(itembox)) {
            itembox = ItemBoxTypeEnum.DOING.getValue();
        }
        model.setMeeting(false);
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String startor = processParam.getStartor();
        if (itembox.equalsIgnoreCase(ItemBoxTypeEnum.TODO.getValue())) {
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            processSerialNumber = processParam.getProcessSerialNumber();
            processDefinitionId = task.getProcessDefinitionId();
            taskDefinitionKey = task.getTaskDefinitionKey();
            processDefinitionKey = processDefinitionId.split(":")[0];
            activitiUser = task.getAssignee();
            if (StringUtils.isBlank((CharSequence)itemId)) {
                itemId = processParam.getItemId();
            }
            if (StringUtils.isBlank((CharSequence)task.getFormKey())) {
                task.setFormKey("0");
                this.taskApi.saveTask(tenantId, task);
                try {
                    this.todoTaskApi.setIsNewTodo(tenantId, taskId, "0");
                }
                catch (Exception e) {
                    LOGGER.error("setIsNewTodo error", (Throwable)e);
                }
            }
            String startTaskDefKey = "";
            String startNode = (String)this.processDefinitionApi.getStartNodeKeyByProcessDefinitionId(tenantId, processDefinitionId).getData();
            List nodeList = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, startNode).getData();
            for (TargetModel map : nodeList) {
                startTaskDefKey = Y9Util.genCustomStr((String)startTaskDefKey, (String)map.getTaskDefKey());
            }
            model.setStartTaskDefKey(startTaskDefKey);
            OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
            model.setMeeting(officeDoneInfo.getMeeting() != null && officeDoneInfo.getMeeting().equals("1"));
        } else if (itembox.equalsIgnoreCase(ItemBoxTypeEnum.DOING.getValue()) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.DONE.getValue())) {
            HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getById(tenantId, processInstanceId).getData();
            OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
            if (hpi == null) {
                if (officeDoneInfo == null) {
                    String year = processParam.getCreateTime().substring(0, 4);
                    hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getByIdAndYear(tenantId, processInstanceId, year).getData();
                    processDefinitionId = hpi.getProcessDefinitionId();
                    processDefinitionKey = processDefinitionId.split(":")[0];
                } else {
                    processDefinitionId = officeDoneInfo.getProcessDefinitionId();
                    processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
                }
            } else {
                processDefinitionId = hpi.getProcessDefinitionId();
                processDefinitionKey = processDefinitionId.split(":")[0];
            }
            assert (officeDoneInfo != null);
            model.setMeeting(officeDoneInfo.getMeeting() != null && officeDoneInfo.getMeeting().equals("1"));
            processSerialNumber = processParam.getProcessSerialNumber();
            if (StringUtils.isNotEmpty((CharSequence)taskId)) {
                if (taskId.contains(",")) {
                    taskId = taskId.split(",")[0];
                }
                TaskModel taskTemp = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
                taskDefinitionKey = taskTemp.getTaskDefinitionKey();
            }
        }
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(itembox);
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setTaskDefKey(taskDefinitionKey);
        model.setTaskId(taskId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model = this.genDocumentModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, mobile, model);
        model = this.menuControl(itemId, processDefinitionId, taskDefinitionKey, taskId, model, itemboxStr);
        return model;
    }

    @Override
    public DocumentDetailModel editCopy(String processSerialNumber, boolean mobile) {
        DocumentDetailModel model = new DocumentDetailModel();
        String processInstanceId = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activitiUser = "";
        String itemId = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
        processInstanceId = processParam.getProcessInstanceId();
        String startor = processParam.getStartor();
        OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
        if (officeDoneInfo == null) {
            String year = processParam.getCreateTime().substring(0, 4);
            HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getByIdAndYear(tenantId, processInstanceId, year).getData();
            processDefinitionId = hpi.getProcessDefinitionId();
            processDefinitionKey = processDefinitionId.split(":")[0];
        } else {
            processDefinitionId = officeDoneInfo.getProcessDefinitionId();
            processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
        }
        processSerialNumber = processParam.getProcessSerialNumber();
        itemId = processParam.getItemId();
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(ItemBoxTypeEnum.COPY.getValue());
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, mobile, model);
        model = this.menuControl4Copy(itemId, processDefinitionId, taskDefinitionKey, model);
        return model;
    }

    @Override
    public DocumentDetailModel editDoing(String processInstanceId, String documentId, boolean isAdmin, ItemBoxTypeEnum itemBox) {
        DocumentDetailModel model = new DocumentDetailModel();
        String processSerialNumber = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activitiUser = "";
        String itemId = "";
        String taskId = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        model.setMeeting(false);
        model.setDocumentId(documentId);
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String startor = processParam.getStartor();
        HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getById(tenantId, processInstanceId).getData();
        OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
        processDefinitionId = hpi.getProcessDefinitionId();
        processDefinitionKey = processDefinitionId.split(":")[0];
        assert (officeDoneInfo != null);
        processSerialNumber = processParam.getProcessSerialNumber();
        itemId = processParam.getItemId();
        List taskList = (List)this.taskApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
        if (!taskList.isEmpty()) {
            if (processSerialNumber.equals(documentId)) {
                taskId = ((TaskModel)taskList.get(0)).getId();
            } else {
                SignDeptDetail signDeptDetail = this.signDeptDetailService.findById(documentId);
                Optional<TaskModel> taskModel = taskList.stream().filter(task -> task.getExecutionId().equals(signDeptDetail.getExecutionId())).findFirst();
                if (taskModel.isPresent()) {
                    taskId = taskModel.get().getId();
                }
            }
        } else {
            List haiList = (List)this.historicActivityApi.getByProcessInstanceId(tenantId, processInstanceId).getData();
            HistoricActivityInstanceModel last = haiList.stream().reduce((first, second) -> second).orElse(null);
            taskDefinitionKey = last.getActivityId();
        }
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(itemBox.getValue());
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setTaskDefKey(taskDefinitionKey);
        model.setTaskId(taskId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, isAdmin, model);
        model = this.menuControl4Doing(itemId, taskId, model);
        return model;
    }

    @Override
    public DocumentDetailModel editDone(String processInstanceId, String documentId, boolean isAdmin, ItemBoxTypeEnum itemBox) {
        DocumentDetailModel model = new DocumentDetailModel();
        String processSerialNumber = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activityUser = "";
        String itemId = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String starter = processParam.getStartor();
        OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
        if (officeDoneInfo == null) {
            String year = processParam.getCreateTime().substring(0, 4);
            HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getByIdAndYear(tenantId, processInstanceId, year).getData();
            processDefinitionId = hpi.getProcessDefinitionId();
            processDefinitionKey = processDefinitionId.split(":")[0];
        } else {
            processDefinitionId = officeDoneInfo.getProcessDefinitionId();
            processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
        }
        processSerialNumber = processParam.getProcessSerialNumber();
        itemId = processParam.getItemId();
        model.setDocumentId(documentId);
        model.setTitle(processParam.getTitle());
        model.setStartor(starter);
        model.setItembox(itemBox.getValue());
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setActivitiUser(activityUser);
        model.setItemId(itemId);
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, isAdmin, model);
        model = this.menuControl4Done(itemId, processDefinitionId, taskDefinitionKey, model);
        return model;
    }

    @Override
    public DocumentDetailModel editRecycle(String processInstanceId, boolean mobile) {
        DocumentDetailModel model = new DocumentDetailModel();
        String processSerialNumber = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activitiUser = "";
        String itemId = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String startor = processParam.getStartor();
        OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
        if (officeDoneInfo == null) {
            String year = processParam.getCreateTime().substring(0, 4);
            HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessApi.getByIdAndYear(tenantId, processInstanceId, year).getData();
            processDefinitionId = hpi.getProcessDefinitionId();
            processDefinitionKey = processDefinitionId.split(":")[0];
        } else {
            processDefinitionId = officeDoneInfo.getProcessDefinitionId();
            processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
        }
        processSerialNumber = processParam.getProcessSerialNumber();
        itemId = processParam.getItemId();
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(ItemBoxTypeEnum.RECYCLE.getValue());
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, mobile, model);
        model = this.menuControl4Recycle(itemId, processDefinitionId, taskDefinitionKey, model);
        return model;
    }

    @Override
    public DocumentDetailModel editTodo(String taskId, boolean mobile) {
        DocumentDetailModel model = new DocumentDetailModel();
        String tenantId = Y9LoginUserHolder.getTenantId();
        model.setMeeting(false);
        TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
        String processInstanceId = task.getProcessInstanceId();
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String starter = processParam.getStartor();
        String itemId = processParam.getItemId();
        String processSerialNumber = processParam.getProcessSerialNumber();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String activitiUser = task.getAssignee();
        if (StringUtils.isBlank((CharSequence)task.getFormKey())) {
            task.setFormKey("0");
            this.taskApi.saveTask(tenantId, task);
        }
        String startTaskDefKey = "";
        String startNode = (String)this.processDefinitionApi.getStartNodeKeyByProcessDefinitionId(tenantId, processDefinitionId).getData();
        List nodeList = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, startNode).getData();
        for (TargetModel map : nodeList) {
            startTaskDefKey = Y9Util.genCustomStr((String)startTaskDefKey, (String)map.getTaskDefKey());
        }
        model.setStartTaskDefKey(startTaskDefKey);
        model.setTitle(processParam.getTitle());
        model.setStartor(starter);
        model.setCurrentUser(Y9LoginUserHolder.getOrgUnit().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setTaskDefKey(taskDefinitionKey);
        model.setTaskId(taskId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model.setItembox(ItemBoxTypeEnum.TODO.getValue());
        model = this.genTabModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, false, model);
        model = this.menuControl4Todo(itemId, processDefinitionId, taskDefinitionKey, taskId, model);
        return model;
    }

    @Override
    public Y9Result<String> forwarding(String taskId, String sponsorHandle, String userChoice, String routeToTaskId, String sponsorGuid) {
        String processInstanceId = "";
        try {
            boolean tooMuch;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
            int num = userList.size();
            boolean bl = tooMuch = num > 100;
            if (tooMuch) {
                return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a!");
            }
            if (userList.isEmpty()) {
                return Y9Result.failure((String)"\u672a\u5339\u914d\u5230\u53d1\u9001\u4eba!");
            }
            OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
            FlowElementModel flowElementModel = (FlowElementModel)this.processDefinitionApi.getNode(tenantId, task.getProcessDefinitionId(), routeToTaskId).getData();
            Map<String, Object> variables = CommonOpt.setVariables(orgUnitId, orgUnit.getName(), routeToTaskId, userList, flowElementModel);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            boolean bl2 = tooMuch = num > 20;
            if ("parallel".equals(flowElementModel.getMultiInstance()) && tooMuch) {
                TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                Date date = new Date();
                if (taskVariable == null) {
                    taskVariable = new TaskVariable();
                    taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    taskVariable.setProcessInstanceId(processInstanceId);
                    taskVariable.setTaskId(taskId);
                    taskVariable.setKeyName("isForwarding");
                    taskVariable.setCreateTime(sdf.format(date));
                }
                taskVariable.setUpdateTime(sdf.format(date));
                taskVariable.setText("true:" + num);
                this.taskVariableRepository.save((Object)taskVariable);
                this.asyncHandleService.forwarding(tenantId, orgUnit, processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, flowElementModel, variables, userList);
            } else if (StringUtils.isNotBlank((CharSequence)sponsorHandle) && "true".equals(sponsorHandle)) {
                List taskNextList1 = (List)this.taskApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
                boolean bl3 = tooMuch = taskNextList1.size() > 10;
                if (tooMuch) {
                    TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                    Date date = new Date();
                    if (taskVariable == null) {
                        taskVariable = new TaskVariable();
                        taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                        taskVariable.setProcessInstanceId(processInstanceId);
                        taskVariable.setTaskId(taskId);
                        taskVariable.setKeyName("isForwarding");
                        taskVariable.setCreateTime(sdf.format(date));
                    }
                    taskVariable.setUpdateTime(sdf.format(date));
                    taskVariable.setText("true:" + num);
                    this.taskVariableRepository.save((Object)taskVariable);
                    this.asyncHandleService.forwarding(tenantId, orgUnit, processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, flowElementModel, variables, userList);
                } else {
                    this.asyncHandleService.forwarding4Gfg(processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, flowElementModel, variables, userList);
                }
            } else {
                this.asyncHandleService.forwarding4Gfg(processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, flowElementModel, variables, userList);
            }
            return Y9Result.success((Object)processInstanceId, (String)"\u53d1\u9001\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("\u516c\u6587\u53d1\u9001\u5931\u8d25\uff01");
            e.printStackTrace();
            try {
                StringWriter result = new StringWriter();
                PrintWriter print = new PrintWriter(result);
                e.printStackTrace(print);
                String msg = ((Object)result).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLog errorLog = new ErrorLog();
                errorLog.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLog.setCreateTime(time);
                errorLog.setErrorFlag("forwarding");
                errorLog.setErrorType("taskError");
                errorLog.setExtendField("\u53d1\u9001\u5c11\u6570\u4eba\u5931\u8d25");
                errorLog.setProcessInstanceId(processInstanceId);
                errorLog.setTaskId(taskId);
                errorLog.setText(msg);
                errorLog.setUpdateTime(time);
                this.errorLogService.saveErrorLog(errorLog);
            }
            catch (Exception e2) {
                LOGGER.error("\u4fdd\u5b58\u4efb\u52a1\u53d1\u9001\u9519\u8bef\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e2);
            }
            return Y9Result.failure((String)"\u53d1\u9001\u5931\u8d25!");
        }
    }

    @Override
    public OpenDataModel genDocumentModel(String itemId, String processDefinitionKey, String processDefinitionId, String taskDefinitionKey, boolean mobile, OpenDataModel model) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)processDefinitionId)) {
            processDefinitionId = ((ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData()).getId();
        }
        String formIds = "";
        String showOtherFlag = "";
        String formNames = "";
        if (mobile) {
            List<Y9FormItemMobileBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4Mobile(itemId, processDefinitionId, taskDefinitionKey);
            model.setFormId("");
            model.setFormName("");
            model.setFormJson("");
            if (!eformTaskBinds.isEmpty()) {
                Y9FormItemMobileBind eftb = eformTaskBinds.get(0);
                model.setFormId(eftb.getFormId());
                String formName = eftb.getFormName();
                boolean b = formName.contains("(");
                if (b) {
                    formName = formName.substring(0, formName.indexOf("("));
                }
                model.setFormName(formName);
                Y9Form y9Form = this.y9FormRepository.findById((Object)eftb.getFormId()).orElse(null);
                assert (y9Form != null);
                model.setFormJson(y9Form.getFormJson());
            }
            return model;
        }
        List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
        ArrayList list = new ArrayList();
        if (!eformTaskBinds.isEmpty()) {
            for (Y9FormItemBind eftb : eformTaskBinds) {
                formIds = Y9Util.genCustomStr((String)formIds, (String)eftb.getFormId());
                String formName = eftb.getFormName();
                if (formName.contains("(")) {
                    formName = formName.substring(0, formName.indexOf("("));
                }
                formNames = Y9Util.genCustomStr((String)formNames, (String)formName);
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("formId", eftb.getFormId());
                map.put("formName", formName);
                list.add(map);
            }
            showOtherFlag = this.y9FormItemBindService.getShowOther(eformTaskBinds);
        }
        model.setFormList(list);
        model.setFormIds(formIds);
        model.setFormNames(formNames);
        model.setShowOtherFlag(showOtherFlag);
        String printFormId = "";
        String printFormType = "";
        ItemPrintTemplateBind bind = this.printTemplateItemBindRepository.findByItemId(itemId);
        if (bind != null) {
            printFormId = bind.getTemplateId();
            printFormType = bind.getTemplateType();
        }
        model.setPrintFormId(printFormId);
        model.setPrintFormType(printFormType);
        return model;
    }

    @Override
    public DocumentDetailModel genTabModel(String itemId, String processDefinitionKey, String processDefinitionId, String taskDefinitionKey, boolean isAdmin, DocumentDetailModel model) {
        String showOtherFlag = "";
        List<Y9FormItemBind> y9FormTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
        ArrayList<ItemFormModel> list = new ArrayList<ItemFormModel>();
        if (!y9FormTaskBinds.isEmpty()) {
            for (Y9FormItemBind fib : y9FormTaskBinds) {
                ItemFormModel itemFormModel = new ItemFormModel();
                String formName = fib.getFormName();
                if (formName.contains("(")) {
                    formName = formName.substring(0, formName.indexOf("("));
                }
                itemFormModel.setFormId(fib.getFormId());
                itemFormModel.setFormName(formName);
                list.add(itemFormModel);
            }
            showOtherFlag = this.y9FormItemBindService.getShowOther(y9FormTaskBinds);
        }
        model.setFormList(list);
        model.setShowOtherFlag(showOtherFlag);
        List<SignDeptDetail> signList = this.signDeptDetailService.findByProcessSerialNumber(model.getProcessSerialNumber());
        Integer signStatus = SignStatusEnum.NOTSTART.getValue();
        if (model.getItembox().equals(ItemBoxTypeEnum.TODO.getValue())) {
            ActRuDetail todo = this.actRuDetailService.findByTaskIdAndAssignee(model.getTaskId(), Y9LoginUserHolder.getOrgUnitId());
            signStatus = todo.isSub() ? SignStatusEnum.SUB.getValue() : SignStatusEnum.NONE.getValue();
        } else if (StringUtils.isNotBlank((CharSequence)model.getDocumentId()) && model.getDocumentId().equals(model.getProcessSerialNumber())) {
            signStatus = SignStatusEnum.NONE.getValue();
        } else if (!signList.isEmpty()) {
            ActRuDetail doing = this.actRuDetailService.findByProcessSerialNumberAndAssigneeAndStatusEquals1(model.getProcessSerialNumber(), Y9LoginUserHolder.getOrgUnitId());
            signStatus = isAdmin ? SignStatusEnum.ADMIN.getValue() : (null == doing ? SignStatusEnum.SUB.getValue() : (doing.isSub() ? SignStatusEnum.SUB.getValue() : SignStatusEnum.MAIN.getValue()));
        }
        model.setSignStatus(signStatus.intValue());
        ArrayList modelList = new ArrayList();
        signList.stream().filter(s -> s.getStatus().equals(SignDeptDetailStatusEnum.DONE.getValue())).forEach(sdd -> {
            SignDeptDetailModel ssdModel = new SignDeptDetailModel();
            Y9BeanUtil.copyProperties((Object)sdd, (Object)ssdModel);
            modelList.add(ssdModel);
        });
        model.setSignDeptDetailList(modelList);
        return model;
    }

    private void getAllPosition(List<Position> list, String deptId) {
        List deptList = (List)this.departmentApi.listByParentId(Y9LoginUserHolder.getTenantId(), deptId).getData();
        List list0 = (List)this.positionApi.listByParentId(Y9LoginUserHolder.getTenantId(), deptId).getData();
        if (!list0.isEmpty()) {
            list.addAll(list0);
        }
        for (Department dept : deptList) {
            this.getAllPosition(list, dept.getId());
        }
    }

    @Override
    public List<ItemButtonModel> getButtons(String taskId) {
        DocumentDetailModel model = new DocumentDetailModel();
        String tenantId = Y9LoginUserHolder.getTenantId();
        TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
        String processInstanceId = task.getProcessInstanceId();
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String itemId = processParam.getItemId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        model.setProcessSerialNumber(processParam.getProcessSerialNumber());
        model.setProcessInstanceId(processInstanceId);
        model = this.menuControl4Todo(itemId, processDefinitionId, taskDefinitionKey, taskId, model);
        return model.getButtonList();
    }

    @Override
    public String getFirstItem() {
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            String userId = Y9LoginUserHolder.getOrgUnitId();
            List list = (List)this.appApi.listAccessAppForPosition(tenantId, userId, AuthorityEnum.BROWSE).getData();
            for (Resource r : list) {
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                return url.split("itemId=")[1];
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7b2c\u4e00\u4e2a\u4efb\u52a1\u5931\u8d25\uff01", (Throwable)e);
        }
        return "";
    }

    @Override
    public String getFormIdByItemId(String itemId, String processDefinitionKey) {
        String formIds = "";
        String processDefinitionId = ((ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(Y9LoginUserHolder.getTenantId(), processDefinitionKey).getData()).getId();
        List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, "");
        if (!eformTaskBinds.isEmpty()) {
            for (Y9FormItemBind eftb : eformTaskBinds) {
                formIds = Y9Util.genCustomStr((String)formIds, (String)eftb.getFormId());
            }
        }
        return formIds;
    }

    public List<OrgUnit> getUserChoice(String itemId, String processDefinitionId, String taskDefinitionKey, String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefinitionKey);
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        for (ItemPermission o : list) {
            if (Objects.equals(o.getRoleType(), ItemPermissionEnum.DEPARTMENT.getValue()) || Objects.equals(o.getRoleType(), ItemPermissionEnum.POSITION.getValue()) || Objects.equals(o.getRoleType(), ItemPermissionEnum.USER.getValue())) {
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, o.getRoleId()).getData();
                if (null == orgUnit) continue;
                orgUnitList.add(orgUnit);
                continue;
            }
            if (Objects.equals(o.getRoleType(), ItemPermissionEnum.ROLE.getValue())) {
                List positionList = (List)this.positionRoleApi.listPositionsByRoleId(tenantId, o.getRoleId()).getData();
                orgUnitList.addAll(positionList);
                continue;
            }
            if (!Objects.equals(o.getRoleType(), ItemPermissionEnum.DYNAMICROLE.getValue())) continue;
            ArrayList<OrgUnit> deptList = new ArrayList<OrgUnit>();
            List<Object> positionList = new ArrayList();
            DynamicRole dynamicRole = this.dynamicRoleService.getById(o.getRoleId());
            if (null == dynamicRole.getKinds() || dynamicRole.getKinds().equals(DynamicRoleKindsEnum.NONE.getValue())) {
                List<OrgUnit> orgUnitList1 = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
                for (OrgUnit orgUnit : orgUnitList1) {
                    if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                        positionList.add((Position)orgUnit);
                        continue;
                    }
                    if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
                    deptList.add(orgUnit);
                }
            } else {
                positionList = this.dynamicRoleMemberService.listPositionByDynamicRoleIdAndProcessInstanceId(dynamicRole, processInstanceId);
            }
            for (OrgUnit orgUnit : positionList) {
                orgUnitList.add(orgUnit);
            }
            for (OrgUnit orgUnit : deptList) {
                orgUnitList.add(orgUnit);
            }
        }
        return orgUnitList;
    }

    @Override
    public List<ItemListModel> listItems() {
        ArrayList<ItemListModel> listMap = new ArrayList<ItemListModel>();
        try {
            String userId = Y9LoginUserHolder.getOrgUnitId();
            String tenantId = Y9LoginUserHolder.getTenantId();
            List list = (List)this.appApi.listAccessAppForPosition(tenantId, userId, AuthorityEnum.BROWSE).getData();
            for (Resource r : list) {
                ItemListModel model = new ItemListModel();
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                String itemId = url.split("itemId=")[1];
                model.setId(r.getId());
                model.setUrl(itemId);
                model.setItemId(itemId);
                model.setAppIcon("");
                model.setTodoCount(Integer.valueOf(0));
                SpmApproveItem spmApproveitem = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
                model.setName(r.getName());
                model.setItemName(r.getName());
                if (spmApproveitem == null || spmApproveitem.getId() == null) continue;
                model.setName(spmApproveitem.getName());
                model.setItemName(spmApproveitem.getName());
                long todoCount = (Long)this.processTodoApi.getTodoCountByUserIdAndProcessDefinitionKey(tenantId, userId, spmApproveitem.getWorkflowGuid()).getData();
                model.setTodoCount(Integer.valueOf((int)todoCount));
                model.setAppIcon(StringUtils.isBlank((CharSequence)spmApproveitem.getIconData()) ? "" : spmApproveitem.getIconData());
                model.setProcessDefinitionKey(spmApproveitem.getWorkflowGuid());
                listMap.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff01", (Throwable)e);
        }
        return listMap;
    }

    @Override
    public List<ItemListModel> listMyItems() {
        ArrayList<ItemListModel> listMap = new ArrayList<ItemListModel>();
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            String userId = Y9LoginUserHolder.getOrgUnitId();
            List list = (List)this.appApi.listAccessAppForPosition(tenantId, userId, AuthorityEnum.BROWSE).getData();
            for (Resource r : list) {
                ItemListModel model = new ItemListModel();
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                String itemId = url.split("itemId=")[1];
                model.setId(r.getId());
                model.setItemId(itemId);
                model.setAppIcon("");
                SpmApproveItem spmApproveitem = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
                model.setName(r.getName());
                model.setItemName(r.getName());
                if (spmApproveitem == null || spmApproveitem.getId() == null) continue;
                model.setName(spmApproveitem.getName());
                model.setItemName(spmApproveitem.getName());
                model.setAppIcon(StringUtils.isBlank((CharSequence)spmApproveitem.getIconData()) ? "" : spmApproveitem.getIconData());
                model.setProcessDefinitionKey(spmApproveitem.getWorkflowGuid());
                listMap.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6211\u7684\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff01", (Throwable)e);
        }
        return listMap;
    }

    @Override
    public OpenDataModel menuControl(String itemId, String processDefinitionId, String taskDefKey, String taskId, OpenDataModel model, String itembox) {
        ButtonUtil buttonUtil = new ButtonUtil();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        Map<String, Object> map = buttonUtil.showButton(itemId, taskId, itembox);
        String[] buttonIds = (String[])map.get("buttonIds");
        String[] buttonNames = (String[])map.get("buttonNames");
        String sponsorHandle = (String)map.get("sponsorHandle");
        int[] buttonOrders = (int[])map.get("buttonOrders");
        boolean[] isButtonShow = (boolean[])map.get("isButtonShow");
        String menuName = "";
        String menuKey = "";
        String sendName = "";
        String sendKey = "";
        String repositionName = "";
        String repositionKey = "";
        ArrayList sendMap = new ArrayList();
        ArrayList<Object> menuMap = new ArrayList<Object>();
        ArrayList repositionMap = new ArrayList();
        for (int i = buttonOrders.length - 1; i >= 0; --i) {
            HashMap<String, String> mapTemp;
            List<ItemButtonBind> bibList;
            int k = buttonOrders[i] - 1;
            if (k == 0 && isButtonShow[0]) {
                bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
                block3: for (ItemButtonBind itemButtonBind : bibList) {
                    String buttonName = itemButtonBind.getButtonName();
                    String buttonCustomId = itemButtonBind.getButtonCustomId();
                    if ("\u53d1\u9001".equals(buttonName)) continue;
                    List roleIds = itemButtonBind.getRoleIds();
                    if (roleIds.isEmpty()) {
                        HashMap mapTemp2 = new HashMap(16);
                        mapTemp2.put("menuName", buttonName);
                        mapTemp2.put("menuKey", buttonCustomId);
                        menuName = Y9Util.genCustomStr((String)menuName, (String)buttonName);
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonCustomId);
                        menuMap.add(mapTemp2);
                        continue;
                    }
                    for (String roleId : roleIds) {
                        boolean hasRole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData();
                        if (!hasRole) continue;
                        mapTemp = new HashMap<String, String>(16);
                        mapTemp.put("menuName", buttonName);
                        mapTemp.put("menuKey", buttonCustomId);
                        menuName = Y9Util.genCustomStr((String)menuName, (String)buttonName);
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonCustomId);
                        menuMap.add(mapTemp);
                        continue block3;
                    }
                }
            }
            if (k == 1 && isButtonShow[1] && StringUtils.isNotBlank((CharSequence)taskDefKey)) {
                Object roleIds;
                boolean haveSendButton = false;
                bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
                block5: for (ItemButtonBind bib : bibList) {
                    Object mapTemp3;
                    if (!"\u53d1\u9001".equals(bib.getButtonName())) continue;
                    roleIds = bib.getRoleIds();
                    if (roleIds.isEmpty()) {
                        mapTemp3 = new HashMap(16);
                        mapTemp3.put("menuName", bib.getButtonName());
                        mapTemp3.put("menuKey", bib.getButtonCustomId());
                        menuName = Y9Util.genCustomStr((String)menuName, (String)bib.getButtonName());
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)bib.getButtonCustomId());
                        menuMap.add(mapTemp3);
                        haveSendButton = true;
                        break;
                    }
                    mapTemp3 = roleIds.iterator();
                    while (mapTemp3.hasNext()) {
                        String roleId = (String)mapTemp3.next();
                        boolean hasrole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData();
                        if (!hasrole) continue;
                        HashMap<String, String> mapTemp4 = new HashMap<String, String>(16);
                        mapTemp4.put("menuName", bib.getButtonName());
                        mapTemp4.put("menuKey", bib.getButtonCustomId());
                        menuName = Y9Util.genCustomStr((String)menuName, (String)bib.getButtonName());
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)bib.getButtonCustomId());
                        menuMap.add(mapTemp4);
                        haveSendButton = true;
                        break block5;
                    }
                }
                if (!haveSendButton) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(16);
                    hashMap.put("menuName", buttonNames[k]);
                    hashMap.put("menuKey", buttonIds[k]);
                    menuName = Y9Util.genCustomStr((String)menuName, (String)buttonNames[k]);
                    menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonIds[k]);
                    menuMap.add(hashMap);
                    List routeToTasks = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
                    roleIds = routeToTasks.iterator();
                    while (roleIds.hasNext()) {
                        TargetModel m = (TargetModel)roleIds.next();
                        HashMap<String, String> map2 = new HashMap<String, String>(16);
                        if ("\u9000\u56de".equals(m.getTaskDefName()) || "Exclusive Gateway".equals(m.getTaskDefName())) continue;
                        sendName = Y9Util.genCustomStr((String)sendName, (String)m.getTaskDefName());
                        sendKey = Y9Util.genCustomStr((String)sendKey, (String)m.getTaskDefKey());
                        map2.put("sendName", m.getTaskDefName());
                        map2.put("sendKey", m.getTaskDefKey());
                        sendMap.add(map2);
                    }
                    bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.SEND.getValue(), processDefinitionId, taskDefKey);
                    block8: for (ItemButtonBind bind2 : bibList) {
                        List roleIds2 = bind2.getRoleIds();
                        String buttonName = bind2.getButtonName();
                        String buttonCustomId = bind2.getButtonCustomId();
                        if (roleIds2.isEmpty()) {
                            mapTemp = new HashMap(16);
                            sendName = Y9Util.genCustomStr((String)sendName, (String)buttonName);
                            sendKey = Y9Util.genCustomStr((String)sendKey, (String)buttonCustomId);
                            mapTemp.put("sendName", buttonName);
                            mapTemp.put("sendKey", buttonCustomId);
                            sendMap.add(mapTemp);
                            continue;
                        }
                        for (String roleId : roleIds2) {
                            boolean hasrole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData();
                            if (!hasrole) continue;
                            HashMap<String, String> mapTemp5 = new HashMap<String, String>(16);
                            sendName = Y9Util.genCustomStr((String)sendName, (String)buttonName);
                            sendKey = Y9Util.genCustomStr((String)sendKey, (String)buttonCustomId);
                            mapTemp5.put("sendName", buttonName);
                            mapTemp5.put("sendKey", buttonCustomId);
                            sendMap.add(mapTemp5);
                            continue block8;
                        }
                    }
                }
            }
            if (k == 15 && isButtonShow[15]) {
                String taskDefNameJson;
                List list = (List)this.processDefinitionApi.getNodes(tenantId, processDefinitionId).getData();
                for (TargetModel node : list) {
                    HashMap<String, String> map3 = new HashMap<String, String>(16);
                    if ("\u6d41\u7a0b".equals(node.getTaskDefName())) continue;
                    repositionName = Y9Util.genCustomStr((String)repositionName, (String)node.getTaskDefName());
                    repositionKey = Y9Util.genCustomStr((String)repositionKey, (String)node.getTaskDefKey());
                    map3.put("repositionName", node.getTaskDefName());
                    map3.put("repositionKey", node.getTaskDefKey());
                    repositionMap.add(map3);
                }
                model.setRepositionMap(repositionMap);
                ObjectMapper mapper = new ObjectMapper();
                try {
                    taskDefNameJson = mapper.writeValueAsString(repositionMap);
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("\u89e3\u6790\u91cd\u5b9a\u5411\u6309\u94ae\u5931\u8d25\uff01", (Throwable)e);
                    taskDefNameJson = "[]";
                }
                model.setTaskDefNameJson(taskDefNameJson);
            }
            if (k == 1 || !isButtonShow[k]) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>(16);
            hashMap.put("menuName", buttonNames[k]);
            hashMap.put("menuKey", buttonIds[k]);
            menuName = Y9Util.genCustomStr((String)menuName, (String)buttonNames[k]);
            menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonIds[k]);
            menuMap.add(hashMap);
        }
        model.setSendMap(sendMap);
        model.setMenuMap(menuMap);
        model.setSendName(sendName);
        model.setSendKey(sendKey);
        model.setMenuName(menuName);
        model.setMenuKey(menuKey);
        model.setSponsorHandle(sponsorHandle);
        model.setLastPerson4RefuseClaim(map.get("isLastPerson4RefuseClaim") != null ? (Boolean)map.get("isLastPerson4RefuseClaim") : false);
        model.setMultiInstance(map.get("multiInstance") != null ? (String)map.get("multiInstance") : "");
        model.setNextNode(map.get("nextNode") != null ? (Boolean)map.get("nextNode") : false);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Add(String itemId, String processDefinitionId, String taskDefKey, DocumentDetailModel model) {
        List<ItemButtonBind> bibList;
        ButtonUtil buttonUtil = new ButtonUtil();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        List<ItemButtonModel> buttonList = buttonUtil.showButton4Add(itemId);
        if (buttonList.contains(ItemButton.baoCun)) {
            bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
            for (ItemButtonBind bind : bibList) {
                String buttonName = bind.getButtonName();
                String buttonCustomId = bind.getButtonCustomId();
                List roleIds = bind.getRoleIds();
                if (!roleIds.isEmpty() && !roleIds.stream().anyMatch(roleId -> (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData())) continue;
                buttonList.add(new ItemButtonModel(buttonCustomId, buttonName, ItemButtonTypeEnum.COMMON.getValue()));
            }
        }
        if (buttonList.contains(ItemButton.faSong)) {
            List routeToTasks = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
            for (TargetModel m : routeToTasks) {
                if ("\u9000\u56de".equals(m.getTaskDefName()) || "Exclusive Gateway".equals(m.getTaskDefName())) continue;
                buttonList.add(new ItemButtonModel(m.getTaskDefKey(), m.getTaskDefName(), ItemButtonTypeEnum.SEND.getValue()));
            }
            bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.SEND.getValue(), processDefinitionId, taskDefKey);
            for (ItemButtonBind bind : bibList) {
                List roleIds = bind.getRoleIds();
                String buttonName = bind.getButtonName();
                String buttonCustomId = bind.getButtonCustomId();
                if (!roleIds.isEmpty() && !roleIds.stream().anyMatch(roleId -> (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData())) continue;
                buttonList.add(new ItemButtonModel(buttonCustomId, buttonName, ItemButtonTypeEnum.SEND.getValue()));
            }
        }
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Copy(String itemId, String processDefinitionId, String taskDefKey, DocumentDetailModel model) {
        ButtonUtil buttonUtil = new ButtonUtil();
        List<ItemButtonModel> buttonList = buttonUtil.showButton4Copy();
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Doing(String itemId, String taskId, DocumentDetailModel model) {
        ButtonUtil buttonUtil = new ButtonUtil();
        List<Object> buttonList = new ArrayList();
        if (model.getItembox().equals(ItemBoxTypeEnum.DOING.getValue())) {
            buttonList = buttonUtil.showButton4Doing(itemId, taskId);
        } else if (model.getItembox().equals(ItemBoxTypeEnum.MONITOR_DOING.getValue())) {
            String documentId = model.getDocumentId();
            if (documentId.equals(model.getProcessSerialNumber())) {
                buttonList.add(ItemButton.chongDingWei);
            } else {
                SignDeptDetail signDeptDetail = this.signDeptDetailService.findById(documentId);
                if (signDeptDetail.getStatus().equals(SignDeptDetailStatusEnum.DOING.getValue())) {
                    buttonList.add(ItemButton.chongDingWei);
                }
            }
        }
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Done(String itemId, String processDefinitionId, String taskDefKey, DocumentDetailModel model) {
        ButtonUtil buttonUtil = new ButtonUtil();
        List<ItemButtonModel> buttonList = buttonUtil.showButton4Done(model);
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Recycle(String itemId, String processDefinitionId, String taskDefKey, DocumentDetailModel model) {
        ButtonUtil buttonUtil = new ButtonUtil();
        List<ItemButtonModel> buttonList = buttonUtil.showButton4Recycle();
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public DocumentDetailModel menuControl4Todo(String itemId, String processDefinitionId, String taskDefKey, String taskId, DocumentDetailModel model) {
        List<ItemButtonBind> bibList;
        ButtonUtil buttonUtil = new ButtonUtil();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        List<ItemButtonModel> buttonList = buttonUtil.showButton4Todo(itemId, taskId, model);
        if (buttonList.contains(ItemButton.baoCun)) {
            bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
            bibList.stream().filter(bind -> !"\u53d1\u9001".equals(bind.getButtonName())).forEach(bind -> {
                List roleIds = bind.getRoleIds();
                if (roleIds.isEmpty() || roleIds.stream().anyMatch(roleId -> (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData())) {
                    buttonList.add(new ItemButtonModel(bind.getButtonCustomId(), bind.getButtonName(), ItemButtonTypeEnum.COMMON.getValue()));
                }
            });
        }
        if (buttonList.contains(ItemButton.faSong) && StringUtils.isNotBlank((CharSequence)taskDefKey)) {
            AtomicBoolean haveSendButton = new AtomicBoolean(false);
            bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
            bibList.stream().filter(bib -> "\u53d1\u9001".equals(bib.getButtonName())).forEach(bib -> {
                List roleIds = bib.getRoleIds();
                if (roleIds.isEmpty() || roleIds.stream().anyMatch(roleId -> (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData())) {
                    buttonList.add(new ItemButtonModel(bib.getButtonCustomId(), bib.getButtonName(), ItemButtonTypeEnum.COMMON.getValue()));
                    haveSendButton.set(true);
                }
            });
            if (!haveSendButton.get()) {
                List routeToTasks = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
                routeToTasks.stream().filter(m -> !"\u9000\u56de".equals(m.getTaskDefName()) && !"Exclusive Gateway".equals(m.getTaskDefName())).forEach(m -> buttonList.add(new ItemButtonModel(m.getTaskDefKey(), m.getTaskDefName(), ItemButtonTypeEnum.SEND.getValue())));
                bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.SEND.getValue(), processDefinitionId, taskDefKey);
                bibList.forEach(bind -> {
                    List roleIds = bind.getRoleIds();
                    if (roleIds.isEmpty() || roleIds.stream().anyMatch(roleId -> (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, orgUnitId).getData())) {
                        buttonList.add(new ItemButtonModel(bind.getButtonCustomId(), bind.getButtonName(), ItemButtonTypeEnum.SEND.getValue()));
                    }
                });
            }
        }
        if (buttonList.contains(ItemButton.tuiHui)) {
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            Boolean isSub = (Boolean)this.processDefinitionApi.isSubProcessChildNode(tenantId, processDefinitionId, taskDefKey).getData();
            List results = (List)this.historictaskApi.getByProcessInstanceId(tenantId, task.getProcessInstanceId(), "").getData();
            if (isSub.booleanValue()) {
                String executionId = task.getExecutionId();
                results.stream().filter(r -> r.getExecutionId().equals(executionId) && null != r.getEndTime()).forEach(r -> {
                    Object taskName = r.getName() + "({0})";
                    OrgUnit position = null;
                    if (StringUtils.isNotBlank((CharSequence)r.getAssignee())) {
                        position = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, r.getAssignee()).getData();
                    }
                    taskName = MessageFormat.format((String)taskName, null == position ? "\u65e0" : position.getName());
                    ItemButtonModel itemButtonModel = new ItemButtonModel(r.getTaskDefinitionKey(), (String)taskName, ItemButtonTypeEnum.ROLLBACK.getValue(), List.of(r.getAssignee()), "", null);
                    if (!buttonList.contains(itemButtonModel)) {
                        buttonList.add(itemButtonModel);
                    }
                });
            } else {
                List subNodeList = (List)this.processDefinitionApi.getSubProcessChildNode(tenantId, processDefinitionId).getData();
                results.stream().filter(hisTask -> null != hisTask.getEndTime() && StringUtils.isNotBlank((CharSequence)hisTask.getAssignee())).forEach(hisTask -> {
                    AtomicBoolean isSubNode = new AtomicBoolean(false);
                    subNodeList.forEach(s -> {
                        if (s.getTaskDefKey().equals(hisTask.getTaskDefinitionKey())) {
                            isSubNode.set(true);
                        }
                    });
                    if (!isSubNode.get()) {
                        Object taskName = hisTask.getName() + "({0})";
                        List personList = new ArrayList();
                        if (StringUtils.isNotBlank((CharSequence)hisTask.getAssignee())) {
                            personList = (List)this.positionApi.listPersonsByPositionId(tenantId, hisTask.getAssignee()).getData();
                        }
                        taskName = MessageFormat.format((String)taskName, personList.isEmpty() ? "\u65e0" : ((Person)personList.stream().findFirst().get()).getName());
                        ItemButtonModel itemButtonModel = new ItemButtonModel(hisTask.getTaskDefinitionKey(), (String)taskName, ItemButtonTypeEnum.ROLLBACK.getValue(), List.of(hisTask.getAssignee()), "", null);
                        if (!buttonList.contains(itemButtonModel)) {
                            buttonList.add(itemButtonModel);
                        }
                    }
                });
            }
            if (buttonList.stream().noneMatch(itemButtonModel -> itemButtonModel.getButtonType().equals(ItemButtonTypeEnum.ROLLBACK.getValue()))) {
                buttonList.remove(ItemButton.tuiHui);
            }
        }
        model.setButtonList(buttonList);
        return model;
    }

    @Override
    public List<String> parseUserChoice(String userChoice) {
        String users = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)userChoice)) {
            String[] userChoices;
            for (String s : userChoices = userChoice.split(";")) {
                String[] s2 = s.split(":");
                int principalType = ItemPermissionEnum.POSITION.getValue();
                String userIdTemp = s;
                if (s2.length == 2) {
                    principalType = Integer.parseInt(s2[0]);
                    userIdTemp = s2[1];
                }
                if (principalType == ItemPermissionEnum.POSITION.getValue()) {
                    OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userIdTemp).getData();
                    if (null == orgUnit) continue;
                    users = this.addUserId(users, userIdTemp);
                    continue;
                }
                if (principalType == ItemPermissionEnum.DEPARTMENT.getValue()) {
                    ArrayList<Position> employeeList = new ArrayList<Position>();
                    this.getAllPosition(employeeList, userIdTemp);
                    for (Position pTemp : employeeList) {
                        users = this.addUserId(users, pTemp.getId());
                    }
                    continue;
                }
                if (principalType != ItemPermissionEnum.CUSTOMGROUP.getValue()) continue;
                List list = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), userIdTemp, OrgTypeEnum.POSITION).getData();
                for (Position pTemp : list) {
                    OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, pTemp.getMemberId()).getData();
                    if (orgUnit == null || !StringUtils.isNotBlank((CharSequence)orgUnit.getId())) continue;
                    users = this.addUserId(users, orgUnit.getId());
                }
            }
        }
        List result = Y9Util.stringToList((String)users, (String)";");
        ListUtil.removeDuplicateWithOrder(result);
        return result;
    }

    public Y9Result<TargetModel> parserRouteToTaskId(String itemId, String processSerialNumber, String processDefinitionId, String taskDefKey, String taskId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Y9Result result = Y9Result.failure((String)"\u89e3\u6790\u76ee\u6807\u8def\u7531\u5931\u8d25");
        try {
            List targetNodes = (List)this.processDefinitionApi.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
            if (targetNodes.isEmpty()) {
                return Y9Result.failure((String)"\u76ee\u6807\u8def\u7531\u4e0d\u5b58\u5728");
            }
            if (1 == targetNodes.size()) {
                result.setData((Object)((TargetModel)targetNodes.get(0)));
                result.setSuccess(true);
                return result;
            }
            List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
            Map<String, Object> variables = this.y9FormService.getFormData4Var(eformTaskBinds.get(0).getFormId(), processSerialNumber);
            ArrayList<TargetModel> targetNodesTemp = new ArrayList<TargetModel>();
            for (TargetModel targetNode : targetNodes) {
                for (String columnName : variables.keySet()) {
                    String str = StringUtils.replace((String)variables.get(columnName).toString(), (String)".", (String)"");
                    if (!StringUtils.isNumeric((CharSequence)str)) continue;
                    if (variables.get(columnName).toString().contains(".")) {
                        LOGGER.info("*************************Double:" + variables.get(columnName).toString());
                        variables.put(columnName, Double.valueOf(variables.get(columnName).toString()));
                        continue;
                    }
                    LOGGER.info("*************************Integer:" + variables.get(columnName).toString());
                    variables.put(columnName, Integer.parseInt(variables.get(columnName).toString()));
                }
                LOGGER.info("*************************Y9JsonUtil:" + Y9JsonUtil.writeValueAsString(variables));
                boolean b = (Boolean)this.conditionParserApi.parser(tenantId, targetNode.getConditionExpression(), variables).getData();
                if (!b) continue;
                targetNodesTemp.add(targetNode);
            }
            if (targetNodesTemp.isEmpty()) {
                result.setMsg("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u76ee\u6807\u8def\u7531");
                return result;
            }
            if (targetNodesTemp.size() > 1) {
                result.setMsg("\u7b26\u5408\u8981\u6c42\u7684\u76ee\u6807\u8def\u7531\u8fc7\u591a");
                return result;
            }
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                this.variableApi.setVariables(tenantId, taskId, variables);
            }
            result.setData((Object)((TargetModel)targetNodesTemp.get(0)));
            result.setMsg("\u89e3\u6790\u76ee\u6807\u8def\u7531\u6210\u529f");
            result.setSuccess(true);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u76ee\u6807\u8def\u7531\u5931\u8d25\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    public Y9Result<List<String>> parserUser(String itemId, String processDefinitionId, String routeToTaskId, String routeToTaskName, String processInstanceId, String multiInstance) {
        Y9Result result = Y9Result.failure((String)"\u89e3\u6790\u4eba\u5458\u5931\u8d25");
        List<OrgUnit> orgUnitList = this.roleService.listPermUser4SUbmitTo(itemId, processDefinitionId, routeToTaskId, processInstanceId);
        if (orgUnitList.isEmpty()) {
            result.setMsg("\u76ee\u6807\u8def\u7531\u3010" + routeToTaskName + "\u3011\u672a\u6388\u6743\u4eba\u5458");
            return result;
        }
        if ("common".equals(multiInstance) && orgUnitList.size() > 1) {
            result.setMsg("\u76ee\u6807\u8def\u7531\u3010" + routeToTaskName + "\u3011\u6388\u6743\u4eba\u5458\u8fc7\u591a");
            return result;
        }
        ArrayList<String> userList = new ArrayList<String>();
        for (OrgUnit orgUnit : orgUnitList) {
            userList.add(orgUnit.getId());
        }
        result.setData(userList);
        result.setSuccess(true);
        return result;
    }

    @Override
    public Y9Result<String> reposition(String taskId, String userChoice) {
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            String processInstanceId = task.getProcessInstanceId();
            ArrayList<String> userAndDeptIdList = new ArrayList<String>();
            userChoice = userChoice.substring(2);
            userAndDeptIdList.add(userChoice);
            String multiInstance = (String)this.processDefinitionApi.getNodeType(tenantId, task.getProcessDefinitionId(), task.getTaskDefinitionKey()).getData();
            HashMap<String, String> variables = new HashMap<String, String>(16);
            variables.put("user", userChoice);
            if ("parallel".equals(multiInstance)) {
                List taskNextList = (List)this.taskApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
                for (TaskModel taskNext : taskNextList) {
                    if (!StringUtils.isBlank((CharSequence)taskNext.getFormKey()) && !taskNext.getFormKey().equals("1")) continue;
                    taskId = taskNext.getId();
                    break;
                }
                for (TaskModel taskNext : taskNextList) {
                    if (taskId.equals(taskNext.getId())) continue;
                    if (StringUtils.isBlank((CharSequence)taskNext.getFormKey()) || taskNext.getFormKey().equals("1")) {
                        HashMap<String, String> val = new HashMap<String, String>();
                        val.put("val", "reposition");
                        this.variableApi.setVariableLocal(tenantId, taskNext.getId(), "reposition", val);
                        this.taskApi.complete(tenantId, taskNext.getId());
                        continue;
                    }
                    this.taskApi.complete(tenantId, taskNext.getId());
                }
                TaskModel task1 = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
                task1.setAssignee(userChoice);
                this.taskApi.saveTask(tenantId, task1);
                HashMap<String, String> val = new HashMap<String, String>();
                val.put("val", userChoice.split(":")[0]);
                this.variableApi.setVariableLocal(tenantId, task1.getId(), "parallelSponsor", val);
            } else if ("sequential".equals(multiInstance)) {
                task.setAssignee(userChoice);
                this.taskApi.saveTask(tenantId, task);
            } else {
                task.setAssignee(userChoice);
                this.taskApi.saveTask(tenantId, task);
            }
            return Y9Result.successMsg((String)"\u91cd\u5b9a\u4f4d\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u5b9a\u4f4d\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u91cd\u5b9a\u4f4d\u5931\u8d25\uff01");
        }
    }

    @Override
    public Y9Result<String> saveAndForwarding(String itemId, String processSerialNumber, String processDefinitionKey, String userChoice, String sponsorGuid, String routeToTaskId, Map<String, Object> variables) {
        boolean tooMuch;
        ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
        int num = userList.size();
        boolean bl = tooMuch = num > 100;
        if (tooMuch) {
            return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a");
        }
        StartProcessResultModel model = this.startProcess(itemId, processSerialNumber, processDefinitionKey);
        String taskId = model.getTaskId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (!variables.isEmpty()) {
            String type;
            this.variableApi.setVariables(tenantId, taskId, variables);
            if (variables.get("subProcessNum") != null && "parallel".equals(type = (String)this.processDefinitionApi.getNodeType(tenantId, model.getProcessDefinitionId(), routeToTaskId).getData())) {
                String userId = (String)userList.get(0);
                Integer subProcessNum = Integer.parseInt(variables.get("subProcessNum").toString());
                if (subProcessNum > 1 && userList.size() == 1) {
                    for (int i = 1; i < subProcessNum; ++i) {
                        userList.add(userId);
                    }
                }
            }
        }
        return this.start4Forwarding(taskId, routeToTaskId, sponsorGuid, userList);
    }

    @Override
    public Y9Result<String> saveAndForwardingByTaskKey(String itemId, String processSerialNumber, String processDefinitionKey, String userChoice, String sponsorGuid, String routeToTaskId, String startRouteToTaskId, Map<String, Object> variables) {
        boolean tooMuch;
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
        int num = userList.size();
        boolean bl = tooMuch = num > 100;
        if (tooMuch) {
            return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a");
        }
        Map<String, Object> startMap = this.startProcessByTaskKey(itemId, processSerialNumber, processDefinitionKey, startRouteToTaskId, List.of());
        String taskId = (String)startMap.get("taskId");
        if (!variables.isEmpty()) {
            this.variableApi.setVariables(tenantId, taskId, variables);
        }
        return this.start4Forwarding(taskId, routeToTaskId, sponsorGuid, userList);
    }

    @Override
    public Y9Result<Object> saveAndSubmitTo(String itemId, String processSerialNumber) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getOrgUnitId();
        OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
        try {
            FlowElementModel flowElementModel;
            String routeToTaskName;
            SpmApproveItem item = this.spmApproveitemService.findById(itemId);
            String processDefinitionKey = item.getWorkflowGuid();
            ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
            String processDefinitionId = processDefinitionModel.getId();
            String taskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            Y9Result<TargetModel> routeToTaskIdResult = this.parserRouteToTaskId(itemId, processSerialNumber, processDefinitionId, taskDefKey, "");
            if (!routeToTaskIdResult.isSuccess()) {
                return Y9Result.failure((String)routeToTaskIdResult.getMsg());
            }
            String routeToTaskId = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefKey();
            Y9Result<List<String>> userResult = this.parserUser(itemId, processDefinitionId, routeToTaskId, routeToTaskName = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefName(), "", (flowElementModel = (FlowElementModel)this.processDefinitionApi.getNode(tenantId, processDefinitionId, routeToTaskId).getData()).getMultiInstance());
            if (!userResult.isSuccess()) {
                return Y9Result.failure((String)userResult.getMsg());
            }
            StartProcessResultModel model = this.startProcess(itemId, processSerialNumber, processDefinitionKey);
            String taskId = model.getTaskId();
            String processInstanceId = model.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            List userList = (List)userResult.getData();
            Map<String, Object> variables = CommonOpt.setVariables(userId, orgUnit.getName(), routeToTaskId, userList, flowElementModel);
            this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "", "", taskId, flowElementModel, variables, userList);
            return Y9Result.successMsg((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Override
    public SignTaskConfigModel signTaskConfig(String itemId, String processDefinitionId, String taskDefinitionKey, String processSerialNumber) {
        SignTaskConfigModel model = new SignTaskConfigModel();
        try {
            model.setSignTask(false);
            model.setUserChoice("");
            model.setOnePerson(false);
            boolean searchPerson = true;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String multiInstance = (String)this.processDefinitionApi.getNodeType(tenantId, processDefinitionId, taskDefinitionKey).getData();
            if ("common".equals(multiInstance)) {
                ItemTaskConf itemTaskConf = this.taskConfRepository.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
                ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
                if (itemTaskConf != null && itemTaskConf.getSignTask().booleanValue()) {
                    model.setSignTask(true);
                    if (processParam != null && StringUtils.isNotBlank((CharSequence)processParam.getProcessInstanceId())) {
                        List hisTaskList = (List)this.historictaskApi.findTaskByProcessInstanceIdOrByEndTimeAsc(tenantId, processParam.getProcessInstanceId(), "").getData();
                        for (HistoricTaskInstanceModel hisTask : hisTaskList) {
                            if (!hisTask.getTaskDefinitionKey().equals(taskDefinitionKey) || !StringUtils.isNotBlank((CharSequence)hisTask.getAssignee())) continue;
                            searchPerson = false;
                            model.setUserChoice("6:" + hisTask.getAssignee());
                            break;
                        }
                    }
                    if (searchPerson) {
                        List<OrgUnit> orgUnitList = this.getUserChoice(itemId, processDefinitionId, taskDefinitionKey, processParam != null ? processParam.getProcessInstanceId() : "");
                        if (orgUnitList.isEmpty()) {
                            model.setSignTask(false);
                        } else {
                            Object userChoice = "";
                            for (OrgUnit orgUnit : orgUnitList) {
                                int type = 0;
                                if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                                    type = 2;
                                } else if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                    type = 6;
                                }
                                if (StringUtils.isEmpty((CharSequence)userChoice)) {
                                    userChoice = type + ":" + orgUnit.getId();
                                    continue;
                                }
                                userChoice = (String)userChoice + ";" + type + ":" + orgUnit.getId();
                            }
                            model.setUserChoice((String)userChoice);
                        }
                    }
                } else {
                    List<OrgUnit> orgUnitList = this.getUserChoice(itemId, processDefinitionId, taskDefinitionKey, processParam != null ? processParam.getProcessInstanceId() : "");
                    if (orgUnitList.size() == 1 && orgUnitList.get(0).getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                        model.setOnePerson(true);
                        model.setUserChoice("6:" + orgUnitList.get(0).getId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    @Override
    public Y9Result<String> start4Forwarding(String taskId, String routeToTaskId, String sponsorGuid, List<String> userList) {
        String processInstanceId = "";
        try {
            boolean tooMuch;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String userId = Y9LoginUserHolder.getOrgUnitId();
            OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            FlowElementModel flowElementModel = (FlowElementModel)this.processDefinitionApi.getNode(tenantId, task.getProcessDefinitionId(), routeToTaskId).getData();
            Map<String, Object> variables = CommonOpt.setVariables(userId, orgUnit.getName(), routeToTaskId, userList, flowElementModel);
            int num = userList.size();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            boolean bl = tooMuch = num > 20;
            if ("parallel".equals(flowElementModel.getMultiInstance()) && tooMuch) {
                TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                Date date = new Date();
                if (taskVariable == null) {
                    taskVariable = new TaskVariable();
                    taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    taskVariable.setProcessInstanceId(processInstanceId);
                    taskVariable.setTaskId(taskId);
                    taskVariable.setKeyName("isForwarding");
                    taskVariable.setCreateTime(sdf.format(date));
                }
                taskVariable.setUpdateTime(sdf.format(date));
                taskVariable.setText("true:" + num);
                this.taskVariableRepository.save((Object)taskVariable);
                this.asyncHandleService.forwarding(tenantId, orgUnit, processInstanceId, processParam, "", sponsorGuid, taskId, flowElementModel, variables, userList);
            } else {
                assert (processParam != null);
                this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "true", sponsorGuid, taskId, flowElementModel, variables, userList);
            }
            return Y9Result.success((Object)processInstanceId, (String)"\u53d1\u9001\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("\u516c\u6587\u53d1\u9001\u5931\u8d25\uff01");
            e.printStackTrace();
            try {
                StringWriter result = new StringWriter();
                PrintWriter print = new PrintWriter(result);
                e.printStackTrace(print);
                String msg = ((Object)result).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLog errorLog = new ErrorLog();
                errorLog.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLog.setCreateTime(time);
                errorLog.setErrorFlag("forwarding");
                errorLog.setErrorType("taskError");
                errorLog.setExtendField("\u542f\u52a8\u6d41\u7a0b\u53d1\u9001\u5c11\u6570\u4eba\u5931\u8d25");
                errorLog.setProcessInstanceId(processInstanceId);
                errorLog.setTaskId(taskId);
                errorLog.setText(msg);
                errorLog.setUpdateTime(time);
                this.errorLogService.saveErrorLog(errorLog);
            }
            catch (Exception e2) {
                LOGGER.error("\u4fdd\u5b58\u4efb\u52a1\u53d1\u9001\u9519\u8bef\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e2);
            }
            return Y9Result.failure((String)"\u53d1\u9001\u5931\u8d25!");
        }
    }

    @Override
    public StartProcessResultModel startProcess(String itemId, String processSerialNumber, String processDefinitionKey) {
        StartProcessResultModel model = null;
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            HashMap<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            String startTaskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            vars.put("routeToTaskId", startTaskDefKey);
            vars.put("_FLOWABLE_SKIP_EXPRESSION_ENABLED", true);
            assert (item != null);
            if (item.isShowSubmitButton()) {
                ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
                List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionModel.getId(), "");
                Map<String, Object> variables = this.y9FormService.getFormData4Var(eformTaskBinds.get(0).getFormId(), processSerialNumber);
                for (String columnName : variables.keySet()) {
                    String str = StringUtils.replace((String)variables.get(columnName).toString(), (String)".", (String)"");
                    if (!StringUtils.isNumeric((CharSequence)str)) continue;
                    if (variables.get(columnName).toString().contains(".")) {
                        LOGGER.info("*************************startProcess_Double:" + variables.get(columnName).toString());
                        variables.put(columnName, Double.valueOf(variables.get(columnName).toString()));
                        continue;
                    }
                    LOGGER.info("*************************startProcess_Integer:" + variables.get(columnName).toString());
                    variables.put(columnName, Integer.parseInt(variables.get(columnName).toString()));
                }
                vars.putAll(variables);
            }
            TaskModel task = this.activitiOptService.startProcess(processSerialNumber, processDefinitionKey, item.getSystemName(), List.of(), vars);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getOrgUnitId());
            processParam.setStartorName(Y9LoginUserHolder.getOrgUnit().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getOrgUnit());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            model = new StartProcessResultModel();
            model.setProcessDefinitionId(task.getProcessDefinitionId());
            model.setProcessInstanceId(task.getProcessInstanceId());
            model.setProcessSerialNumber(processSerialNumber);
            model.setTaskId(task.getId());
            model.setTaskDefKey(task.getTaskDefinitionKey());
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    @Override
    public StartProcessResultModel startProcess(String itemId, String processSerialNumber, String processDefinitionKey, String userIds) {
        StartProcessResultModel model = null;
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
            Map<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            String startTaskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            vars.put("routeToTaskId", startTaskDefKey);
            vars = CommonOpt.setVariables(orgUnit.getId(), orgUnit.getName(), "", Arrays.asList(userIds.split(",")), processSerialNumber, null, vars);
            assert (item != null);
            ProcessInstanceModel piModel = (ProcessInstanceModel)this.runtimeApi.startProcessInstanceByKey(tenantId, orgUnit.getId(), processDefinitionKey, item.getSystemName(), vars).getData();
            String processInstanceId = piModel.getId();
            TaskModel task = (TaskModel)((List)this.taskApi.findByProcessInstanceId(tenantId, processInstanceId).getData()).get(0);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getOrgUnitId());
            processParam.setStartorName(Y9LoginUserHolder.getOrgUnit().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getOrgUnit());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            model = new StartProcessResultModel();
            model.setProcessDefinitionId(task.getProcessDefinitionId());
            model.setProcessInstanceId(task.getProcessInstanceId());
            model.setProcessSerialNumber(processSerialNumber);
            model.setTaskId(task.getId());
            model.setTaskDefKey(task.getTaskDefinitionKey());
            return model;
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
            return model;
        }
    }

    @Override
    public Map<String, Object> startProcessByTaskKey(String itemId, String processSerialNumber, String processDefinitionKey, String startRouteToTaskId, List<String> startOrgUnitIdList) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("success", false);
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            HashMap<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            vars.put("routeToTaskId", startRouteToTaskId);
            assert (item != null);
            TaskModel task = this.activitiOptService.startProcess(processSerialNumber, processDefinitionKey, item.getSystemName(), startOrgUnitIdList, vars);
            map.put("processInstanceId", task.getProcessInstanceId());
            map.put("processSerialNumber", processSerialNumber);
            map.put("processDefinitionId", task.getProcessDefinitionId());
            map.put("taskId", task.getId());
            map.put("taskDefKey", task.getTaskDefinitionKey());
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getOrgUnitId());
            processParam.setStartorName(Y9LoginUserHolder.getOrgUnit().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getOrgUnit());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            map.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
        }
        return map;
    }

    @Override
    public StartProcessResultModel startProcessByTheTaskKey(String itemId, String processSerialNumber, String processDefinitionKey, String startTaskDefKey, List<String> startOrgUnitIdList) {
        StartProcessResultModel model = null;
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            startTaskDefKey = StringUtils.isBlank((CharSequence)startTaskDefKey) ? this.itemStartNodeRoleService.getStartTaskDefKey(itemId) : startTaskDefKey;
            HashMap<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            vars.put("routeToTaskId", startTaskDefKey);
            vars.put("_FLOWABLE_SKIP_EXPRESSION_ENABLED", true);
            assert (item != null);
            if (item.isShowSubmitButton()) {
                ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
                List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionModel.getId(), "");
                Map<String, Object> variables = this.y9FormService.getFormData4Var(eformTaskBinds.get(0).getFormId(), processSerialNumber);
                for (String columnName : variables.keySet()) {
                    String str = StringUtils.replace((String)variables.get(columnName).toString(), (String)".", (String)"");
                    if (!StringUtils.isNumeric((CharSequence)str)) continue;
                    if (variables.get(columnName).toString().contains(".")) {
                        LOGGER.info("*************************startProcess_Double:" + variables.get(columnName).toString());
                        variables.put(columnName, Double.valueOf(variables.get(columnName).toString()));
                        continue;
                    }
                    LOGGER.info("*************************startProcess_Integer:" + variables.get(columnName).toString());
                    variables.put(columnName, Integer.parseInt(variables.get(columnName).toString()));
                }
                vars.putAll(variables);
            }
            TaskModel task = this.activitiOptService.startProcess(processSerialNumber, processDefinitionKey, item.getSystemName(), startOrgUnitIdList, vars);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getOrgUnitId());
            processParam.setStartorName(Y9LoginUserHolder.getOrgUnit().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getOrgUnit());
            this.processParamService.saveOrUpdate(processParam);
            model = new StartProcessResultModel();
            model.setProcessDefinitionId(task.getProcessDefinitionId());
            model.setProcessInstanceId(task.getProcessInstanceId());
            model.setProcessSerialNumber(processSerialNumber);
            model.setTaskId(task.getId());
            model.setTaskDefKey(task.getTaskDefinitionKey());
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    @Override
    public Y9Result<Object> submitTo(String processSerialNumber, String taskId) {
        try {
            FlowElementModel flowElementModel;
            String routeToTaskName;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String userId = Y9LoginUserHolder.getOrgUnitId();
            OrgUnit orgUnit = Y9LoginUserHolder.getOrgUnit();
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            String itemId = processParam.getItemId();
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            if (null == task || null == task.getId()) {
                return Y9Result.failure((String)"\u8be5\u4ef6\u5df2\u88ab\u5904\u7406\u3002");
            }
            String processDefinitionId = task.getProcessDefinitionId();
            String taskDefKey = task.getTaskDefinitionKey();
            String processInstanceId = task.getProcessInstanceId();
            Y9Result<TargetModel> routeToTaskIdResult = this.parserRouteToTaskId(itemId, processSerialNumber, processDefinitionId, taskDefKey, taskId);
            if (!routeToTaskIdResult.isSuccess()) {
                return Y9Result.failure((String)routeToTaskIdResult.getMsg());
            }
            String routeToTaskId = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefKey();
            Y9Result<List<String>> userResult = this.parserUser(itemId, processDefinitionId, routeToTaskId, routeToTaskName = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefName(), processInstanceId, (flowElementModel = (FlowElementModel)this.processDefinitionApi.getNode(tenantId, processDefinitionId, routeToTaskId).getData()).getMultiInstance());
            if (!userResult.isSuccess()) {
                return Y9Result.failure((String)userResult.getMsg());
            }
            List userList = (List)userResult.getData();
            Map<String, Object> variables = CommonOpt.setVariables(userId, orgUnit.getName(), routeToTaskId, userList, flowElementModel);
            String subProcessStr = (String)this.variableApi.getVariableByProcessInstanceId(tenantId, processInstanceId, "subProcessNum").getData();
            if (subProcessStr != null && "parallel".equals(flowElementModel.getMultiInstance())) {
                String userChoice = (String)userList.get(0);
                Integer subProcessNum = Integer.parseInt(subProcessStr);
                if (subProcessNum > 1 && userList.size() == 1) {
                    for (int i = 1; i < subProcessNum; ++i) {
                        userList.add(userChoice);
                    }
                }
            }
            variables.put("users", userList);
            this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "true", "", taskId, flowElementModel, variables, userList);
            return Y9Result.successMsg((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Generated
    public DocumentServiceImpl(ActivitiOptServiceImpl activitiOptService, SpmApproveItemService spmApproveitemService, SpmApproveItemRepository spmApproveitemRepository, ItemTaskConfService taskConfService, ItemPermissionService itemPermissionService, Y9FormItemBindService y9FormItemBindService, ItemButtonBindService buttonItemBindService, ItemTodoTaskApi todoTaskApi, TaskApi taskApi, CustomGroupApi customGroupApi, ProcessDefinitionApi processDefinitionApi, VariableApi variableApi, OrgUnitApi orgUnitApi, RepositoryApi repositoryApi, PositionApi positionApi, RoleApi roleApi, PositionRoleApi positionRoleApi, DepartmentApi departmentApi, PositionResourceApi positionResourceApi, HistoricProcessApi historicProcessApi, HistoricTaskApi historictaskApi, RuntimeApi runtimeApi, ProcessParamService processParamService, ProcessTodoApi processTodoApi, PrintTemplateItemBindRepository printTemplateItemBindRepository, OfficeDoneInfoService officeDoneInfoService, TaskVariableRepository taskVariableRepository, AsyncHandleService asyncHandleService, Y9FormRepository y9FormRepository, Process4SearchService process4SearchService, ErrorLogService errorLogService, ItemStartNodeRoleService itemStartNodeRoleService, ItemTaskConfRepository taskConfRepository, DynamicRoleMemberService dynamicRoleMemberService, DynamicRoleService dynamicRoleService, ConditionParserApi conditionParserApi, Y9FormService y9FormService, RoleService roleService, HistoricActivityApi historicActivityApi, ActRuDetailService actRuDetailService, SignDeptDetailService signDeptDetailService, IdentityApi identityApi, AppApi appApi) {
        this.activitiOptService = activitiOptService;
        this.spmApproveitemService = spmApproveitemService;
        this.spmApproveitemRepository = spmApproveitemRepository;
        this.taskConfService = taskConfService;
        this.itemPermissionService = itemPermissionService;
        this.y9FormItemBindService = y9FormItemBindService;
        this.buttonItemBindService = buttonItemBindService;
        this.todoTaskApi = todoTaskApi;
        this.taskApi = taskApi;
        this.customGroupApi = customGroupApi;
        this.processDefinitionApi = processDefinitionApi;
        this.variableApi = variableApi;
        this.orgUnitApi = orgUnitApi;
        this.repositoryApi = repositoryApi;
        this.positionApi = positionApi;
        this.roleApi = roleApi;
        this.positionRoleApi = positionRoleApi;
        this.departmentApi = departmentApi;
        this.positionResourceApi = positionResourceApi;
        this.historicProcessApi = historicProcessApi;
        this.historictaskApi = historictaskApi;
        this.runtimeApi = runtimeApi;
        this.processParamService = processParamService;
        this.processTodoApi = processTodoApi;
        this.printTemplateItemBindRepository = printTemplateItemBindRepository;
        this.officeDoneInfoService = officeDoneInfoService;
        this.taskVariableRepository = taskVariableRepository;
        this.asyncHandleService = asyncHandleService;
        this.y9FormRepository = y9FormRepository;
        this.process4SearchService = process4SearchService;
        this.errorLogService = errorLogService;
        this.itemStartNodeRoleService = itemStartNodeRoleService;
        this.taskConfRepository = taskConfRepository;
        this.dynamicRoleMemberService = dynamicRoleMemberService;
        this.dynamicRoleService = dynamicRoleService;
        this.conditionParserApi = conditionParserApi;
        this.y9FormService = y9FormService;
        this.roleService = roleService;
        this.historicActivityApi = historicActivityApi;
        this.actRuDetailService = actRuDetailService;
        this.signDeptDetailService = signDeptDetailService;
        this.identityApi = identityApi;
        this.appApi = appApi;
    }
}

