/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl.v1;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.entity.DynamicRole;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleFilterSpecial4SubProcessNotRemove
extends AbstractDynamicRoleMember {
    private final OrgUnitApi orgUnitApi;
    private final RoleApi roleApi;
    private final TaskApi taskApi;
    private final HistoricTaskApi historicTaskApi;
    private final PositionRoleApi positionRoleApi;

    @Override
    public List<Position> getPositionList(String taskId, DynamicRole dynamicRole) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String currentOrgUnitId = Y9LoginUserHolder.getOrgUnitId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            String roleId = dynamicRole.getRoleId();
            List<Object> orgUnitList = (List<Position>)this.positionRoleApi.listPositionsByRoleId(Y9LoginUserHolder.getTenantId(), roleId).getData();
            boolean openTodo = task.getAssignee().equals(currentOrgUnitId);
            if (openTodo) {
                OrgUnit currentOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, currentOrgUnitId).getData();
                boolean match = orgUnitList.stream().anyMatch(orgUnit -> orgUnit.getId().equals(currentOrgUnit.getId()));
                if (match) {
                    OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, currentOrgUnitId).getData();
                    orgUnitList = orgUnitList.stream().filter(orgUnit -> orgUnit.getGuidPath().contains(bureau.getId())).collect(Collectors.toList());
                } else {
                    orgUnitList = orgUnitList.stream().filter(orgUnit -> orgUnit.getParentId().equals(currentOrgUnit.getParentId())).collect(Collectors.toList());
                }
            } else {
                String subStartUserId = "";
                List hisTaskList = (List)this.historicTaskApi.findTaskByProcessInstanceIdOrderByStartTimeAsc(tenantId, task.getProcessInstanceId(), "").getData();
                for (HistoricTaskInstanceModel hisTask : hisTaskList) {
                    if (!hisTask.getExecutionId().equals(task.getExecutionId())) continue;
                    subStartUserId = hisTask.getAssignee();
                    break;
                }
                OrgUnit subStartBureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, subStartUserId).getData();
                orgUnitList = orgUnitList.stream().filter(orgUnit -> orgUnit.getGuidPath().contains(subStartBureau.getId())).collect(Collectors.toList());
            }
            return orgUnitList;
        }
        return List.of();
    }

    @Generated
    public RoleFilterSpecial4SubProcessNotRemove(OrgUnitApi orgUnitApi, RoleApi roleApi, TaskApi taskApi, HistoricTaskApi historicTaskApi, PositionRoleApi positionRoleApi) {
        this.orgUnitApi = orgUnitApi;
        this.roleApi = roleApi;
        this.taskApi = taskApi;
        this.historicTaskApi = historicTaskApi;
        this.positionRoleApi = positionRoleApi;
    }
}

