/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl.v1;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.entity.DynamicRole;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.stereotype.Service;

@Service
public class RoleFilterSpecial
extends AbstractDynamicRoleMember {
    private final OrgUnitApi orgUnitApi;
    private final RuntimeApi runtimeApi;
    private final RoleApi roleApi;
    private final PositionRoleApi positionRoleApi;

    @Override
    public List<Position> getPositionList(String processInstanceId, DynamicRole dynamicRole) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getOrgUnitId();
        OrgUnit currentOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, userId).getData();
        if (dynamicRole.isUseProcessInstanceId()) {
            ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeApi.getProcessInstance(tenantId, processInstanceId).getData();
            userId = processInstance.getStartUserId();
        }
        OrgUnit personOrPosition = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
        OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, userId).getData();
        String roleId = dynamicRole.getRoleId();
        List<Object> orgUnitList = (List<Position>)this.positionRoleApi.listPositionsByRoleId(Y9LoginUserHolder.getTenantId(), roleId).getData();
        String assignee = "";
        boolean match = orgUnitList.stream().anyMatch(orgUnit -> orgUnit.getId().equals(currentOrgUnit.getId()));
        orgUnitList = match ? orgUnitList.stream().filter(orgUnit -> orgUnit.getGuidPath().contains(bureau.getId())).collect(Collectors.toList()) : orgUnitList.stream().filter(orgUnit -> orgUnit.getParentId().equals(personOrPosition.getParentId())).collect(Collectors.toList());
        orgUnitList.remove(currentOrgUnit);
        return orgUnitList;
    }

    @Generated
    public RoleFilterSpecial(OrgUnitApi orgUnitApi, RuntimeApi runtimeApi, RoleApi roleApi, PositionRoleApi positionRoleApi) {
        this.orgUnitApi = orgUnitApi;
        this.runtimeApi = runtimeApi;
        this.roleApi = roleApi;
        this.positionRoleApi = positionRoleApi;
    }
}

