/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl.v1;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.entity.DynamicRole;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleFilter4SubProcess
extends AbstractDynamicRoleMember {
    private final OrgUnitApi orgUnitApi;
    private final HistoricTaskApi historicTaskApi;
    private final TaskApi taskApi;
    private final RoleApi roleApi;
    private final PositionRoleApi positionRoleApi;

    @Override
    public List<Position> getPositionList(String taskId, DynamicRole dynamicRole) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getOrgUnitId();
        String roleId = dynamicRole.getRoleId();
        List orgUnitList = (List)this.positionRoleApi.listPositionsByRoleId(Y9LoginUserHolder.getTenantId(), roleId).getData();
        String assignee = "";
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskModel task = (TaskModel)this.taskApi.findById(tenantId, taskId).getData();
            List hisTaskList = (List)this.historicTaskApi.findTaskByProcessInstanceIdOrderByStartTimeAsc(tenantId, task.getProcessInstanceId(), "").getData();
            for (HistoricTaskInstanceModel hisTask : hisTaskList) {
                if (!hisTask.getExecutionId().equals(task.getExecutionId())) continue;
                assignee = hisTask.getAssignee();
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assignee)) {
            userId = assignee;
        }
        OrgUnit personOrPosition = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
        Integer ranges = dynamicRole.getRanges();
        switch (ranges) {
            case 1: {
                orgUnitList = orgUnitList.stream().filter(orgUnit -> orgUnit.getParentId().equals(personOrPosition.getParentId())).collect(Collectors.toList());
                break;
            }
            case 2: {
                OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, userId).getData();
                orgUnitList = orgUnitList.stream().filter(orgUnit -> orgUnit.getGuidPath().contains(bureau.getId())).collect(Collectors.toList());
                break;
            }
        }
        return orgUnitList;
    }

    @Generated
    public RoleFilter4SubProcess(OrgUnitApi orgUnitApi, HistoricTaskApi historicTaskApi, TaskApi taskApi, RoleApi roleApi, PositionRoleApi positionRoleApi) {
        this.orgUnitApi = orgUnitApi;
        this.historicTaskApi = historicTaskApi;
        this.taskApi = taskApi;
        this.roleApi = roleApi;
        this.positionRoleApi = positionRoleApi;
    }
}

