/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl.v1;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.entity.DynamicRole;
import net.risesoft.enums.DynamicRoleRangesEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.stereotype.Service;

@Service
public class DeptPropCategory
extends AbstractDynamicRoleMember {
    private final OrgUnitApi orgUnitApi;
    private final DepartmentApi departmentApi;
    private final RuntimeApi runtimeApi;

    @Override
    public List<Position> getPositionList(String processInstanceId, DynamicRole dynamicRole) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getOrgUnitId();
        OrgUnit currentOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, userId).getData();
        if (dynamicRole.isUseProcessInstanceId()) {
            ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeApi.getProcessInstance(tenantId, processInstanceId).getData();
            userId = processInstance.getStartUserId();
        }
        boolean isInherit = !dynamicRole.getRanges().equals(DynamicRoleRangesEnum.DEPT.getValue());
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
        List orgUnitList = (List)this.departmentApi.listDepartmentPropOrgUnits(tenantId, orgUnit.getParentId(), dynamicRole.getDeptPropCategory(), Boolean.valueOf(isInherit)).getData();
        orgUnitList.remove(currentOrgUnit);
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (OrgUnit orgUnit0 : orgUnitList) {
            if (orgUnit0.getOrgType() != OrgTypeEnum.POSITION) continue;
            Position position = (Position)orgUnit0;
            positionList.add(position);
        }
        return positionList;
    }

    @Generated
    public DeptPropCategory(OrgUnitApi orgUnitApi, DepartmentApi departmentApi, RuntimeApi runtimeApi) {
        this.orgUnitApi = orgUnitApi;
        this.departmentApi = departmentApi;
        this.runtimeApi = runtimeApi;
    }
}

